/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.Assert;
import org.testng.annotations.Test;


public class TreeNodesAdaptorTest extends SeleniumTestBase {

	private String[] nodes = {"1", "2", "3"};
	private String[] roots = {"A", "B", "C"};

	private String tree;

	private void init(Template template) {
        renderPage(template);
        String mainForm = getParentId() + "mainForm";
        tree = mainForm + ":tree";
    }

    /**
     *  component builds right tree structure: data is fetched from nodes collection
     *  and assigned to var variable
     */
	@Test
	public void testTreeStructure(Template template) {
        init(template);
		String locator = "xpath=id('"+ tree + "')/div";
        for (int i = 0; i < roots.length; i++) {
			String rootLocator = locator + "/table[" + (i + 1) + "]/tbody/tr";
			Assert.assertEquals(selenium.getText(rootLocator), roots[i]);
			clickAjaxCommandAndWait(rootLocator + "/td[1]/div/a");
			String nodesLocator = locator + "/div[" + (i + 1) + "]";
	        for (int j = 0; j < nodes.length; j++) {
				Assert.assertEquals(selenium.getText(nodesLocator + "/table[" + (j + 1) + "]/tbody/tr"), roots[i] + nodes[j]);
			}
		}
	}
	
	@Override
	public String getTestUrl() {
		return "pages/treeNodesAdaptor/treeNodesAdaptor.xhtml";
	}

}
