/**
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.seamparser;

import java.io.StringReader;

import junit.framework.TestCase;

import org.jboss.seam.text.SeamTextLexer;
import org.jboss.seam.text.SeamTextParser;
import org.richfaces.antlr.HtmlSeamTextLexer;
import org.richfaces.antlr.HtmlSeamTextParser;

/**
 * HtmlSeamParser  Junit Test
 * @author Denis Morozov
 *
 */
public class HtmlSeamParserTest extends TestCase {


	private final static String SEAM_TEXT_EXPRESSION_1 = "It's easy to make *emphasis*, |monospace|, "
			+ "~deleted text~, super^scripts^ or_underlines_.";

	private final static String SEAM_TEXT_EXPRESSION_2 = "+ This is a big heading\n"
			+ "You /must/ have some text following a heading!\n\n"
			+ "++ This is a smaller heading\n"
			+ "This is the first paragraph. We can split it across multiple"
			+ "lines, but we must end it with a blank line.\n\n"
			+ "This is the second paragraph.";

	private final static String SEAM_TEXT_EXPRESSION_3 = "An ordered list:\n\n"
			+ "# first item\n" + "# second item\n"
			+ "# and even the /third/ item\n\n" + "An unordered list:\n\n"
			+ "= an item\n" + "= another item";

	private final static String SEAM_TEXT_EXPRESSION_4 = "The other guy said: "+ "\"Nyeah nyeah-nee\"";
			
	private final static String SEAM_TEXT_EXPRESSION_5 = "You can write down equations like 2\\*3\\+4-7\\=3 and HTML tagslike \\<body\\> using the escape character: \\\\. foo@tut.by, 100$ cash 100%";

	private final static String SEAM_TEXT_EXPRESSION_6 = "My code doesn't work:"
			+ "`for (int i=0; i<100; i--)\n"
			+ "{\n"
			+ "doSomething(){ String str = \"&amp;&nbsp;&gt;&quot; \"; }; doSomething();\n"
			+ "doSomething() " +
					"}`" + " Any ideas?";
	
	private final static String SEAM_TEXT_EXPRESSION_7 = "+ test value<h1>test1<h2>test2</h2>test4</h1>\ntest";
	
	private final static String SEAM_TEXT_EXPRESSION_8 = "++ test value<h1>test1<h2>test2</h2>test4</h1>\ntest";
	
	private final static String SEAM_TEXT_EXPRESSION_9 = "+++ test value<h1>test1<h2>test2</h2>test4</h1>\ntest";
	
	private final static String SEAM_TEXT_EXPRESSION_10 = "++++ test value<h1>test1<h2>test2</h2>test4</h1>\ntest";
	
	private final static String SEAM_TEXT_EXPRESSION_11 = "+ test value<div>test5</div><h1>test1<div>test2</div>test4</h1>\ntest";

	private final static String SEAM_TEXT_EXPRESSION_12 = "[test link=>http://test.com]";
	
	private final static String SEAM_TEXT_EXPRESSION_13 = "[=>http://test.com]";
	
	private final static String SEAM_TEXT_EXPRESSION_14 = "This is a |<tag attribute=\"value\"/>| example.";
	
	private final static String SEAM_TEXT_EXPRESSION_15 = "= <div class=\"testClass1 testClass2\"></div><h1> test value </h1>";
	
	private final static String SEAM_TEXT_EXPRESSION_16 = "# <div class=\"testClass1 testClass2\"></div><h1> test value </h1>";

	private final static String SEAM_TEXT_EXPRESSION_17 = "paragraph\n\n+ header\ntext after header\n\nanother paragraph";

	private final static String SEAM_TEXT_EXPRESSION_18 = "paragraph\n\n++ header\ntext after header\n\nanother paragraph";
	
	private final static String SEAM_TEXT_EXPRESSION_19 = "paragraph\n\n+++ header\ntext after header\n\nanother paragraph";
	
	private final static String SEAM_TEXT_EXPRESSION_20 = "paragraph\n\n++++ header\ntext after header\n\nanother paragraph";
	
	private final static String SEAM_TEXT_EXPRESSION_21 = "paragraph\n\n= item1\n= item2\n= item3\n\nanother paragraph";
	
	private final static String SEAM_TEXT_EXPRESSION_22 = "paragraph\n\n# item1\n# item2\n# item3\n\nanother paragraph";
	
	private final static String SEAM_TEXT_EXPRESSION_23 = "+ header text *emphasis*, |monospace|, "
			+ "~deleted text~, super^scripts^ or_underlines_\n text after header *emphasis*, |monospace|, "
			+ "~deleted text~, super^scripts^ or_underlines_";
	
	private final static String SEAM_TEXT_EXPRESSION_24 = "++ header text *emphasis*, |monospace|, "
		+ "~deleted text~, super^scripts^ or_underlines_\n text after header *emphasis*, |monospace|, "
		+ "~deleted text~, super^scripts^ or_underlines_";

	private final static String SEAM_TEXT_EXPRESSION_25 = "+++ header text *emphasis*, |monospace|, "
		+ "~deleted text~, super^scripts^ or_underlines_\n text after header *emphasis*, |monospace|, "
		+ "~deleted text~, super^scripts^ or_underlines_";

	private final static String SEAM_TEXT_EXPRESSION_26 = "++++ header text *emphasis*, |monospace|, "
		+ "~deleted text~, super^scripts^ or_underlines_\n text after header *emphasis*, |monospace|, "
		+ "~deleted text~, super^scripts^ or_underlines_";

	
	private final static String SEAM_TEXT_EXPRESSION_27 = "= item1 *emphasis*, |monospace|, "
		+ "~deleted text~, super^scripts^ or_underlines_\n= item2 *emphasis*, |monospace|, "
		+ "~deleted text~, super^scripts^ or_underlines_";
	
	private final static String SEAM_TEXT_EXPRESSION_28 = "# item1 *emphasis*, |monospace|, "
		+ "~deleted text~, super^scripts^ or_underlines_\n# item2 *emphasis*, |monospace|, "
		+ "~deleted text~, super^scripts^ or_underlines_";
	
	private final static String SEAM_TEXT_EXPRESSION_29 = "A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9";
	
	private final static String SEAM_TEXT_EXPRESSION_30 = "<div/>";
	

	
	
	public HtmlSeamParserTest(String name) {
		super(name);
	}
	public void testSeamTextConverting1() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_1);
	}

	public void testStandartSeamTextConverting2() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_2);
	}

	public void testStandartSeamTextConverting3() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_3);
	}
	
	public void testStandartSeamTextConverting4() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_4);
	}

	public void testStandartSeamTextConverting5() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_5);
	}

	public void testStandartSeamTextConverting6() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_6);
	}
	
	public void testStandartSeamTextConverting7() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_7);
	}
	
	public void testStandartSeamTextConverting8() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_8);
	}
	
	public void testStandartSeamTextConverting9() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_9);
	}
	
	public void testStandartSeamTextConverting10() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_10);
	}
	
	public void testStandartSeamTextConverting11() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_11);
	}
	
	public void testStandartSeamTextConverting12() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_12);
	}
	
	public void testStandartSeamTextConverting13() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_13);
	}

	public void testStandartSeamTextConverting14() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_14);
	}
	
	public void testStandartSeamTextConverting15() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_15);
	}
	
	public void testStandartSeamTextConverting16() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_16);
	}

	public void testStandartSeamTextConverting17() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_17);
	}

	
	public void testStandartSeamTextConverting18() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_18);
	}

	public void testStandartSeamTextConverting19() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_19);
	}

	public void testStandartSeamTextConverting20() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_20);
	}

	public void testStandartSeamTextConverting21() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_21);
	}
	
	public void testStandartSeamTextConverting22() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_22);
	}
	
	public void testStandartSeamTextConverting23() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_23);
	}
	
	public void testStandartSeamTextConverting24() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_24);
	}

	public void testStandartSeamTextConverting25() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_25);
	}
	
	public void testStandartSeamTextConverting26() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_26);
	}

	public void testStandartSeamTextConverting27() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_27);
	}
	
	public void testStandartSeamTextConverting28() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_28);
	}
	
	public void testStandartSeamTextConverting29() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_29);
	}
	
	public void testStandartSeamTextConverting30() throws Exception {
		assertSeamConverting(SEAM_TEXT_EXPRESSION_30);
	}




	
	


	/**
	 * Method to assert converting from Seam Text to html and back
	 * @param seamTextExpression
	 * @throws Exception
	 */
	private void assertSeamConverting(String seamTextExpression)
			throws Exception {
		
		SeamTextParser seamParser = new SeamTextParser(new SeamTextLexer(new StringReader(seamTextExpression)));
		seamParser.startRule();
		String html = seamParser.toString(); 
				
        HtmlSeamTextParser htmlParser = new HtmlSeamTextParser(new HtmlSeamTextLexer(new StringReader(html)));
        htmlParser.startRule();
        String seamtext = htmlParser.toString();
        
        assertEquals(seamTextExpression,seamtext.trim());
	}
}
