/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets.html;

import java.io.IOException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagHandlerDelegate;
import org.richfaces.view.facelets.html.BehaviorStack;
import org.richfaces.view.facelets.html.CustomBehaviorHandler;

public class BehaviorTagHandlerDelegate
extends TagHandlerDelegate
implements AttachedObjectHandler {
    TagHandlerDelegate wrappedHandlerDelegate;
    CustomBehaviorHandler owner;
    private String behaviorId;
    private String eventName;
    private MetaRule[] metaRules;

    public BehaviorTagHandlerDelegate(CustomBehaviorHandler owner, TagHandlerDelegate wrappedHandlerDelegate) {
        this.owner = owner;
        this.wrappedHandlerDelegate = wrappedHandlerDelegate;
        this.behaviorId = owner.getBehaviorId();
        this.eventName = owner.getEventName();
        this.metaRules = owner.getMetaRules();
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (this.owner.isWrapping()) {
            Application application = ctx.getFacesContext().getApplication();
            Behavior behavior = application.createBehavior(this.behaviorId);
            if (behavior instanceof org.ajax4jsf.component.behavior.ClientBehavior) {
                org.ajax4jsf.component.behavior.ClientBehavior clientBehavior = (org.ajax4jsf.component.behavior.ClientBehavior)behavior;
                this.owner.setAttributes(ctx, (Object)clientBehavior);
                FacesContext context = ctx.getFacesContext();
                BehaviorStack behaviorStack = BehaviorStack.getBehaviorStack(context, true);
                behaviorStack.pushBehavior(context, (ClientBehavior)clientBehavior, this.behaviorId, this.eventName);
                this.owner.applyNextHandler(ctx, parent);
                behaviorStack.popBehavior();
            }
        } else {
            this.wrappedHandlerDelegate.apply(ctx, parent);
        }
    }

    public MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset metaRuleset = this.wrappedHandlerDelegate.createMetaRuleset(type);
        for (MetaRule metaRule : this.metaRules) {
            metaRuleset.addRule(metaRule);
        }
        return metaRuleset;
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        if (this.wrappedHandlerDelegate instanceof AttachedObjectHandler) {
            ((AttachedObjectHandler)this.wrappedHandlerDelegate).applyAttachedObject(context, parent);
        }
    }

    public String getFor() {
        if (this.wrappedHandlerDelegate instanceof AttachedObjectHandler) {
            return ((AttachedObjectHandler)this.wrappedHandlerDelegate).getFor();
        }
        return null;
    }
}

