/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractCalendar;
import org.richfaces.component.Positioning;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.component.util.InputUtils;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.event.CurrentDateChangeEvent;
import org.richfaces.renderkit.ComponentAttribute;
import org.richfaces.renderkit.InputRendererBase;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.utils.CalendarHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(name="jquery.position.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="json-dom.js"), @ResourceDependency(library="org.richfaces", name="jquery.effects.core.js"), @ResourceDependency(library="org.richfaces", name="jquery.effects.highlight.js"), @ResourceDependency(library="org.richfaces", name="JQuerySpinBtn.js"), @ResourceDependency(library="org.richfaces", name="calendar-utils.js"), @ResourceDependency(library="org.richfaces", name="calendar.js"), @ResourceDependency(library="org.richfaces", name="calendar.ecss")})
public class CalendarRendererBase
extends InputRendererBase
implements MetaComponentRenderer {
    public static final String CALENDAR_BUNDLE = "org.richfaces.renderkit.calendar";
    public static final String OPTION_DISABLED = "disabled";
    public static final String OPTION_MIN_DAYS_IN_FIRST_WEEK = "minDaysInFirstWeek";
    public static final String MONTH_LABELS_SHORT = "monthLabelsShort";
    public static final String MONTH_LABELS = "monthLabels";
    public static final String WEEK_DAY_LABELS_SHORT = "weekDayLabelsShort";
    public static final String WEEK_DAY_LABELS = "weekDayLabels";
    public static final String FIRST_DAY_WEEK = "firstWeekDay";
    public static final String MIN_DAYS_IN_FIRST_WEEK = "minDaysInFirstWeek";
    public static final String CALENDAR_ICON_RESOURCE_NAME = "calendarIcon.png";
    public static final String CALENDAR_DISABLE_ICON_RESOURCE_NAME = "disabledCalendarIcon.png";
    public static final String CURRENT_DATE_INPUT = "InputCurrentDate";
    protected static final Map<String, ComponentAttribute> CALENDAR_INPUT_HANDLER_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap((ComponentAttribute[])new ComponentAttribute[]{new ComponentAttribute("onclick").setEventNames(new String[]{"inputclick"}).setComponentAttributeName("oninputclick"), new ComponentAttribute("ondblclick").setEventNames(new String[]{"inputdblclick"}).setComponentAttributeName("oninputdblclick"), new ComponentAttribute("onmousedown").setEventNames(new String[]{"inputmousedown"}).setComponentAttributeName("oninputmousedown"), new ComponentAttribute("onmouseup").setEventNames(new String[]{"inputmouseup"}).setComponentAttributeName("oninputmouseup"), new ComponentAttribute("onmouseover").setEventNames(new String[]{"inputmouseover"}).setComponentAttributeName("oninputmouseover"), new ComponentAttribute("onmousemove").setEventNames(new String[]{"inputmousemove"}).setComponentAttributeName("oninputmousemove"), new ComponentAttribute("onmouseout").setEventNames(new String[]{"inputmouseout"}).setComponentAttributeName("oninputmouseout"), new ComponentAttribute("onkeypress").setEventNames(new String[]{"inputkeypress"}).setComponentAttributeName("oninputkeypress"), new ComponentAttribute("onkeydown").setEventNames(new String[]{"inputkeydown"}).setComponentAttributeName("oninputkeydown"), new ComponentAttribute("onkeyup").setEventNames(new String[]{"inputkeyup"}).setComponentAttributeName("oninputkeyup"), new ComponentAttribute("onblur").setEventNames(new String[]{"inputblur"}).setComponentAttributeName("oninputblur"), new ComponentAttribute("onfocus").setEventNames(new String[]{"inputfocus"}).setComponentAttributeName("oninputfocus"), new ComponentAttribute("onchange").setEventNames(new String[]{"inputchange"}).setComponentAttributeName("oninputchange"), new ComponentAttribute("onselect").setEventNames(new String[]{"inputselect"}).setComponentAttributeName("oninputselect")}));
    private static final String HOURS_VALUE = "hours";
    private static final String MINUTES_VALUE = "minutes";
    private static final String SECONDS_VALUE = "seconds";
    protected final InputUtils.ConverterLookupStrategy calendarConverterLookupStrategy = new InputUtils.ConverterLookupStrategy(){

        public Converter getConverterByValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
            AbstractCalendar calendar = (AbstractCalendar)component;
            Converter converter = calendar.getConverter();
            if (converter == null && value != null) {
                converter = InputUtils.getConverterForType((FacesContext)context, value.getClass());
            }
            if (converter == null) {
                converter = CalendarRendererBase.this.createDefaultConverter(context);
            }
            CalendarRendererBase.this.setupConverter(context, converter, (AbstractCalendar)component);
            return converter;
        }

        public Converter getConverterByProperty(FacesContext context, UIComponent component) throws ConverterException {
            AbstractCalendar calendar = (AbstractCalendar)component;
            Converter converter = InputUtils.findConverter((FacesContext)context, (UIComponent)calendar, (String)"value");
            if (converter == null) {
                converter = CalendarRendererBase.this.createDefaultConverter(context);
            }
            CalendarRendererBase.this.setupConverter(context, converter, calendar);
            return converter;
        }
    };

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        String selectedDateString;
        String clientId;
        if (!(component instanceof AbstractCalendar)) {
            return;
        }
        AbstractCalendar calendar = (AbstractCalendar)component;
        if (calendar.isDisabled()) {
            return;
        }
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String currentDateString = (String)requestParameterMap.get((clientId = calendar.getClientId(context)) + CURRENT_DATE_INPUT);
        if (currentDateString != null) {
            calendar.queueEvent((FacesEvent)new CurrentDateChangeEvent((UIComponent)calendar, currentDateString));
        }
        if ((selectedDateString = (String)requestParameterMap.get(clientId + "InputDate")) != null) {
            calendar.setSubmittedValue(selectedDateString);
        }
        if (requestParameterMap.get(component.getClientId(context) + ".ajax") != null) {
            PartialViewContext pvc = context.getPartialViewContext();
            pvc.getRenderIds().add(component.getClientId(context) + '@' + "daysData");
            context.renderResponse();
        }
    }

    public void renderInputHandlers(FacesContext facesContext, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThroughAttributesOptimized((FacesContext)facesContext, (UIComponent)component, CALENDAR_INPUT_HANDLER_ATTRIBUTES);
    }

    @Override
    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        if (facesContext == null || component == null) {
            throw new NullPointerException();
        }
        if (submittedValue instanceof Date) {
            return submittedValue;
        }
        return InputUtils.getConvertedValue((FacesContext)facesContext, (UIComponent)component, (InputUtils.ConverterLookupStrategy)this.calendarConverterLookupStrategy, (Object)submittedValue);
    }

    @Override
    public String getInputValue(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof AbstractCalendar)) {
            return null;
        }
        return InputUtils.getInputValue((FacesContext)facesContext, (UIComponent)component, (InputUtils.ConverterLookupStrategy)this.calendarConverterLookupStrategy);
    }

    public String getButtonIcon(FacesContext facesContext, UIComponent component) {
        boolean disable = (Boolean)component.getAttributes().get(OPTION_DISABLED);
        String buttonIcon = (String)component.getAttributes().get("buttonIcon");
        if (disable) {
            buttonIcon = (String)component.getAttributes().get("buttonDisabledIcon");
        }
        if (buttonIcon != null && buttonIcon.trim().length() != 0) {
            buttonIcon = RenderKitUtils.getResourceURL((String)buttonIcon, (FacesContext)facesContext);
        } else {
            buttonIcon = disable ? CALENDAR_DISABLE_ICON_RESOURCE_NAME : CALENDAR_ICON_RESOURCE_NAME;
            buttonIcon = RenderKitUtils.getResourcePath((FacesContext)facesContext, (String)"org.richfaces.images", (String)buttonIcon);
        }
        return buttonIcon;
    }

    public Object getSelectedDate(FacesContext facesContext, UIComponent component) throws IOException {
        Object value;
        Date date;
        Object returnValue = null;
        AbstractCalendar calendar = (AbstractCalendar)component;
        if (calendar.isValid() && (date = CalendarHelper.getAsDate(facesContext, calendar, value = calendar.getValue())) != null) {
            returnValue = CalendarRendererBase.formatSelectedDate(CalendarHelper.getTimeZoneOrDefault(calendar), date);
        }
        return returnValue;
    }

    public static Object formatSelectedDate(TimeZone timeZone, Date date) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        AbstractCalendar calendarInstance = (AbstractCalendar)AbstractCalendar.getCurrentComponent((FacesContext)facesContext);
        Calendar calendar = CalendarHelper.getCalendar(facesContext, calendarInstance);
        calendar.setTimeZone(timeZone);
        calendar.setTime(date);
        JSFunction result = new JSFunction("new Date", new Object[0]);
        result.addParameter((Object)calendar.get(1));
        result.addParameter((Object)calendar.get(2));
        result.addParameter((Object)calendar.get(5));
        result.addParameter((Object)calendar.get(11));
        result.addParameter((Object)calendar.get(12));
        result.addParameter((Object)0);
        return result;
    }

    public Object getCurrentDate(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractCalendar calendar = (AbstractCalendar)component;
        Date date = CalendarHelper.getCurrentDateOrDefault(facesContext, calendar);
        return CalendarRendererBase.formatDate(date);
    }

    public String getCurrentDateAsString(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractCalendar calendar = (AbstractCalendar)component;
        SimpleDateFormat formatter = new SimpleDateFormat("MM/yyyy");
        Date currentDate = CalendarHelper.getCurrentDateOrDefault(facesContext, calendar);
        return formatter.format((Object)currentDate);
    }

    public static Object formatDate(Date date) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        AbstractCalendar calendarInstance = (AbstractCalendar)AbstractCalendar.getCurrentComponent((FacesContext)facesContext);
        Calendar calendar = CalendarHelper.getCalendar(facesContext, calendarInstance);
        calendar.setTime(date);
        JSFunction result = new JSFunction("new Date", new Object[0]);
        result.addParameter((Object)calendar.get(1));
        result.addParameter((Object)calendar.get(2));
        result.addParameter((Object)calendar.get(5));
        return result;
    }

    public String getDayCellClass(FacesContext facesContext, UIComponent component) {
        return null;
    }

    public JSReference getDayEnabled(FacesContext facesContext, UIComponent component) {
        AbstractCalendar calendar = (AbstractCalendar)component;
        String dayEnabled = calendar.getDayDisableFunction();
        return dayEnabled != null && dayEnabled.trim().length() != 0 ? new JSReference(dayEnabled) : null;
    }

    public JSReference getDayStyleClass(FacesContext context, UIComponent component) {
        AbstractCalendar calendar = (AbstractCalendar)component;
        String dayStyleClass = calendar.getDayClassFunction();
        return dayStyleClass != null && dayStyleClass.trim().length() != 0 ? new JSReference(dayStyleClass) : null;
    }

    public Map<String, Object> getLabels(FacesContext facesContext, UIComponent component) {
        AbstractCalendar calendar = (AbstractCalendar)component;
        ResourceBundle bundle1 = null;
        ResourceBundle bundle2 = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String messageBundle = facesContext.getApplication().getMessageBundle();
        Locale locale = CalendarHelper.getAsLocale(facesContext, (UIComponent)calendar);
        if (null != messageBundle) {
            bundle1 = ResourceBundle.getBundle(messageBundle, locale, loader);
        }
        try {
            bundle2 = ResourceBundle.getBundle(CALENDAR_BUNDLE, locale, loader);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        ResourceBundle[] bundles = new ResourceBundle[]{bundle1, bundle2};
        String[] names = new String[]{"apply", "today", "clean", "cancel", "ok", "close"};
        return this.getCollectedLabels(bundles, names);
    }

    protected Map<String, Object> getCollectedLabels(ResourceBundle[] bundles, String[] names) {
        HashMap<String, Object> labels = new HashMap<String, Object>();
        if (bundles != null && names != null) {
            for (String name : names) {
                String label = null;
                String bundleKey = "RICH_CALENDAR_" + name.toUpperCase() + "_LABEL";
                for (ResourceBundle bundle : bundles) {
                    if (bundle != null) {
                        try {
                            label = bundle.getString(bundleKey);
                        }
                        catch (MissingResourceException mre) {
                            // empty catch block
                        }
                    }
                    if (label != null) break;
                }
                RenderKitUtils.addToScriptHash(labels, (String)name, label);
            }
        }
        return labels;
    }

    public Map<String, Object> getPreparedDefaultTime(FacesContext facesContext, UIComponent component) {
        AbstractCalendar abstractCalendar = (AbstractCalendar)component;
        Date date = CalendarHelper.getFormattedDefaultTime(abstractCalendar);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (date != null) {
            Calendar calendar = CalendarHelper.getCalendar(null, null);
            calendar.setTime(date);
            int hours = calendar.get(11);
            int minutes = calendar.get(12);
            int seconds = calendar.get(13);
            if (hours != 12 || minutes != 0 || seconds != 0) {
                result.put(HOURS_VALUE, hours);
                result.put(MINUTES_VALUE, minutes);
                result.put(SECONDS_VALUE, seconds);
            }
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    private static String[] shiftDates(int minimum, int maximum, String[] labels) {
        if (minimum == 0 && maximum - minimum == labels.length - 1) {
            return labels;
        }
        String[] shiftedLabels = new String[maximum - minimum + 1];
        System.arraycopy(labels, minimum, shiftedLabels, 0, maximum - minimum + 1);
        return shiftedLabels;
    }

    protected Map<String, Object> getLocaleOptions(FacesContext facesContext, UIComponent component) {
        int day;
        AbstractCalendar calendarComponent = (AbstractCalendar)component;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Locale locale = CalendarHelper.getAsLocale(facesContext, (UIComponent)calendarComponent);
        DateFormatSymbols dateFormat = new DateFormatSymbols(locale);
        Calendar calendar = CalendarHelper.getCalendar(facesContext, calendarComponent);
        int maximum = calendar.getActualMaximum(7);
        int minimum = calendar.getActualMinimum(7);
        int monthMax = calendar.getActualMaximum(2);
        int monthMin = calendar.getActualMinimum(2);
        String[] weekDayLabels = RenderKitUtils.asArray((Object)calendarComponent.getWeekDayLabels());
        if (this.isEmptyArray(weekDayLabels)) {
            weekDayLabels = dateFormat.getWeekdays();
            weekDayLabels = CalendarRendererBase.shiftDates(minimum, maximum, weekDayLabels);
        }
        RenderKitUtils.addToScriptHash(map, (String)WEEK_DAY_LABELS, (Object)weekDayLabels);
        String[] weekDayLabelsShort = RenderKitUtils.asArray((Object)calendarComponent.getWeekDayLabelsShort());
        if (this.isEmptyArray(weekDayLabelsShort)) {
            weekDayLabelsShort = dateFormat.getShortWeekdays();
            weekDayLabelsShort = CalendarRendererBase.shiftDates(minimum, maximum, weekDayLabelsShort);
        }
        RenderKitUtils.addToScriptHash(map, (String)WEEK_DAY_LABELS_SHORT, (Object)weekDayLabelsShort);
        String[] monthLabels = RenderKitUtils.asArray((Object)calendarComponent.getMonthLabels());
        if (this.isEmptyArray(monthLabels)) {
            monthLabels = dateFormat.getMonths();
            monthLabels = CalendarRendererBase.shiftDates(monthMin, monthMax, monthLabels);
        }
        RenderKitUtils.addToScriptHash(map, (String)MONTH_LABELS, (Object)monthLabels);
        String[] monthLabelsShort = RenderKitUtils.asArray((Object)calendarComponent.getMonthLabelsShort());
        if (this.isEmptyArray(monthLabelsShort)) {
            monthLabelsShort = dateFormat.getShortMonths();
            monthLabelsShort = CalendarRendererBase.shiftDates(monthMin, monthMax, monthLabelsShort);
        }
        RenderKitUtils.addToScriptHash(map, (String)MONTH_LABELS_SHORT, (Object)monthLabelsShort);
        int minDaysInFirstWeek = calendarComponent.getMinDaysInFirstWeek();
        if (1 > minDaysInFirstWeek || minDaysInFirstWeek > 7) {
            minDaysInFirstWeek = calendar.getMinimalDaysInFirstWeek();
        }
        if (0 <= minDaysInFirstWeek && minDaysInFirstWeek <= 7) {
            RenderKitUtils.addToScriptHash(map, (String)"minDaysInFirstWeek", (Object)minDaysInFirstWeek);
        }
        if ((day = calendarComponent.getFirstWeekDay()) < 0 || 6 < day) {
            day = calendar.getFirstDayOfWeek() - calendar.getActualMinimum(7);
        }
        if (0 > day || day > 6) {
            throw new IllegalArgumentException(day + " value of firstWeekDay attribute is not a legal one for component: " + MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)calendarComponent));
        }
        RenderKitUtils.addToScriptHash(map, (String)FIRST_DAY_WEEK, (Object)day);
        return map;
    }

    private boolean isEmptyArray(String[] array) {
        if (array != null) {
            for (String str : array) {
                if (str.trim().length() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public String getPopupStyle(FacesContext facesContext, UIComponent component) {
        AbstractCalendar calendar = (AbstractCalendar)component;
        int zindex = calendar.getZindex();
        if (zindex < 0) {
            zindex = 3;
        }
        return HtmlUtil.concatStyles((Object[])new Object[]{"z-index: " + zindex, calendar.getPopupStyle()});
    }

    public Locale getAsLocale(FacesContext facesContext, UIComponent component) {
        return CalendarHelper.getAsLocale(facesContext, component);
    }

    public String writePreloadBody(FacesContext context, UIComponent component) throws IOException {
        AbstractCalendar calendar = (AbstractCalendar)component;
        Object preload = calendar.getPreload();
        if (preload != null) {
            return RenderKitUtils.toScriptArgs((Object[])new Object[]{preload});
        }
        return null;
    }

    public boolean isUseIcons(FacesContext facesContext, UIComponent component) {
        Object label = component.getAttributes().get("buttonLabel");
        return label == null || ((String)label).trim().length() == 0;
    }

    protected Converter createDefaultConverter(FacesContext facesContext) {
        if (facesContext == null) {
            return null;
        }
        return facesContext.getApplication().createConverter("javax.faces.DateTime");
    }

    protected Converter setupConverter(FacesContext facesContext, Converter converter, AbstractCalendar calendar) {
        if (converter == null || calendar == null) {
            return null;
        }
        if (converter instanceof DateTimeConverter) {
            DateTimeConverter defaultConverter = (DateTimeConverter)converter;
            defaultConverter.setPattern(CalendarHelper.getDatePatternOrDefault(calendar));
            defaultConverter.setLocale(CalendarHelper.getAsLocale(facesContext, (UIComponent)calendar));
            defaultConverter.setTimeZone(CalendarHelper.getTimeZoneOrDefault(calendar));
        }
        return converter;
    }

    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if (!"daysData".equals(metaComponentId)) {
            throw new IllegalArgumentException(metaComponentId);
        }
        Object preload = ((AbstractCalendar)component).getPreload();
        Map dataMap = ExtendedPartialViewContext.getInstance((FacesContext)context).getResponseComponentDataMap();
        dataMap.put(component.getClientId(context), preload);
    }

    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    protected String getTodayControlModeOrDefault(UIComponent component) {
        String value = "";
        if (component instanceof AbstractCalendar && ((value = ((AbstractCalendar)component).getTodayControlMode()) == null || value.length() == 0)) {
            value = "select";
        }
        return value;
    }

    protected String getJointPoint(UIComponent component) {
        Positioning jointPoint;
        if (component instanceof AbstractCalendar && (jointPoint = ((AbstractCalendar)component).getJointPoint()) != null) {
            return jointPoint.getValue();
        }
        return null;
    }

    protected String getDirection(UIComponent component) {
        Positioning direction;
        if (component instanceof AbstractCalendar && (direction = ((AbstractCalendar)component).getDirection()) != null) {
            return direction.getValue();
        }
        return null;
    }

    protected String getBoundaryDatesModeOrDefault(UIComponent component) {
        String value = "";
        if (component instanceof AbstractCalendar && ((value = ((AbstractCalendar)component).getBoundaryDatesMode()) == null || value.length() == 0)) {
            value = "inactive";
        }
        return value;
    }

    protected AbstractCalendar.Mode getModeOrDefault(UIComponent component) {
        AbstractCalendar.Mode value = ((AbstractCalendar)component).getMode();
        if (value == null) {
            value = AbstractCalendar.Mode.client;
        }
        return value;
    }
}

