/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletInputStream;
import org.richfaces.request.ProgressServletInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProgressControl {
    private static final String UPLOAD_PROGRESS_PREFIX = "_richfaces_upload_percents";
    long totalBytesRead = 0L;
    private Map<String, Object> contextMap;
    private String attributeName;
    private long length;
    private byte lastUpdatedPercentValue;

    public ProgressControl(String uploadId, long length) {
        this.attributeName = ProgressControl.getContextAttributeName(uploadId);
        this.length = length;
    }

    public static byte getProgress(FacesContext context, String uploadId) {
        Byte progress = (Byte)context.getExternalContext().getSessionMap().get(ProgressControl.getContextAttributeName(uploadId));
        if (progress != null) {
            return progress;
        }
        return 0;
    }

    static String getContextAttributeName(String uploadId) {
        return UPLOAD_PROGRESS_PREFIX + uploadId;
    }

    void clearProgress() {
        if (this.contextMap != null) {
            this.contextMap.remove(this.attributeName);
        }
    }

    public void advance(long bytesRead) {
        this.totalBytesRead += bytesRead;
        byte percent = this.length != 0L ? (byte)Math.floor((double)this.totalBytesRead / (double)this.length * 100.0) : (byte)100;
        if (percent > this.lastUpdatedPercentValue && this.contextMap != null) {
            this.lastUpdatedPercentValue = percent;
            this.contextMap.put(this.attributeName, this.lastUpdatedPercentValue);
        }
    }

    public void setContextMap(Map<String, Object> contextMap) {
        this.contextMap = contextMap;
    }

    public ServletInputStream wrapStream(ServletInputStream inputStream) {
        return new ProgressServletInputStream(inputStream, this);
    }
}

