/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.apache.maven.model.building;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.sonatype.aether.ant.org.apache.maven.model.InputLocation;
import org.sonatype.aether.ant.org.apache.maven.model.Model;
import org.sonatype.aether.ant.org.apache.maven.model.building.DefaultModelProblem;
import org.sonatype.aether.ant.org.apache.maven.model.building.ModelProblem;
import org.sonatype.aether.ant.org.apache.maven.model.building.ModelProblemCollector;
import org.sonatype.aether.ant.org.apache.maven.model.building.ModelProblemUtils;
import org.sonatype.aether.ant.org.apache.maven.model.io.ModelParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultModelProblemCollector
implements ModelProblemCollector {
    private List<ModelProblem> problems;
    private String source;
    private Model sourceModel;
    private Model rootModel;
    private Set<ModelProblem.Severity> severities = EnumSet.noneOf(ModelProblem.Severity.class);

    public DefaultModelProblemCollector(List<ModelProblem> problems) {
        this.problems = problems != null ? problems : new ArrayList();
        for (ModelProblem problem : this.problems) {
            this.severities.add(problem.getSeverity());
        }
    }

    public boolean hasFatalErrors() {
        return this.severities.contains((Object)ModelProblem.Severity.FATAL);
    }

    public boolean hasErrors() {
        return this.severities.contains((Object)ModelProblem.Severity.ERROR) || this.severities.contains((Object)ModelProblem.Severity.FATAL);
    }

    public List<ModelProblem> getProblems() {
        return this.problems;
    }

    public void setSource(String source) {
        this.source = source;
        this.sourceModel = null;
    }

    public void setSource(Model source) {
        this.sourceModel = source;
        this.source = null;
        if (this.rootModel == null) {
            this.rootModel = source;
        }
    }

    private String getSource() {
        if (this.source == null && this.sourceModel != null) {
            this.source = ModelProblemUtils.toPath(this.sourceModel);
        }
        return this.source;
    }

    private String getModelId() {
        return ModelProblemUtils.toId(this.sourceModel);
    }

    public void setRootModel(Model rootModel) {
        this.rootModel = rootModel;
    }

    public Model getRootModel() {
        return this.rootModel;
    }

    public String getRootModelId() {
        return ModelProblemUtils.toId(this.rootModel);
    }

    public void add(ModelProblem problem) {
        this.problems.add(problem);
        this.severities.add(problem.getSeverity());
    }

    public void addAll(List<ModelProblem> problems) {
        this.problems.addAll(problems);
        for (ModelProblem problem : problems) {
            this.severities.add(problem.getSeverity());
        }
    }

    @Override
    public void add(ModelProblem.Severity severity, String message, InputLocation location, Exception cause) {
        int line = -1;
        int column = -1;
        String source = null;
        String modelId = null;
        if (location != null) {
            line = location.getLineNumber();
            column = location.getColumnNumber();
            if (location.getSource() != null) {
                modelId = location.getSource().getModelId();
                source = location.getSource().getLocation();
            }
        }
        if (modelId == null) {
            modelId = this.getModelId();
            source = this.getSource();
        }
        if (line <= 0 && column <= 0 && cause instanceof ModelParseException) {
            ModelParseException e = (ModelParseException)cause;
            line = e.getLineNumber();
            column = e.getColumnNumber();
        }
        DefaultModelProblem problem = new DefaultModelProblem(message, severity, source, line, column, modelId, cause);
        this.add(problem);
    }
}

