/*
 * Copyright 2008-2012 Red Hat, Inc, and individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.torquebox.jobs;

import java.io.IOException;

import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;
import org.projectodd.polyglot.jobs.BaseJobScheduler;
import org.quartz.SchedulerException;
import org.torquebox.core.component.ComponentResolver;
import org.torquebox.core.runtime.RubyRuntimePool;

public class JobScheduler extends BaseJobScheduler  {

	public JobScheduler(String name, int threadCount) {
		super( name, threadCount );
	}
	
    public void start() throws IOException, SchedulerException {
        RubyJobProxyFactory jobFactory = new RubyJobProxyFactory();
        jobFactory.setRubyRuntimePool( this.rubyRuntimePoolInjector.getValue() );
        setJobFactory( jobFactory );
        super.start();
    }

    public void addComponentResolver(String rubyClass, ComponentResolver resolver) {
    	((RubyJobProxyFactory)getJobFactory()).addComponentResolver( rubyClass, resolver );
    }
       
    public Injector<RubyRuntimePool> getRubyRuntimePoolInjector() {
        return this.rubyRuntimePoolInjector;
    }
    
    private InjectedValue<RubyRuntimePool> rubyRuntimePoolInjector = new InjectedValue<RubyRuntimePool>();
    
	private static final Logger log = Logger.getLogger( "org.torquebox.jobs" );
}
