/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.model.SelectionMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtendedDataTable
extends UIDataTableBase
implements MetaComponentResolver,
MetaComponentEncoder {
    public static final String COMPONENT_TYPE = "org.richfaces.ExtendedDataTable";
    public static final String COMPONENT_FAMILY = "org.richfaces.Data";
    public static final String SCROLL = "scroll";
    public static final String SUBMITTED_CLIENT_FIRST = "submittedClientFirst";
    public static final String OLD_CLIENT_FIRST = "oldClientFirst";
    private static final Logger RENDERKIT_LOG = RichfacesLogger.RENDERKIT.getLogger();

    @Attribute
    public abstract int getFrozenColumns();

    @Attribute
    public abstract String getStyleClass();

    @Attribute
    public abstract SelectionMode getSelectionMode();

    @Attribute(events={@EventName(value="selectionchange", defaultEvent=true)})
    public abstract String getOnselectionchange();

    @Attribute(events={@EventName(value="beforeselectionchange")})
    public abstract String getOnbeforeselectionchange();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (SCROLL.equals(metaComponentId)) {
            Object oldRowKey = this.getRowKey();
            try {
                this.setRowKey(facesContext, null);
                String string = this.getClientId(facesContext) + '@' + metaComponentId;
                return string;
            }
            finally {
                try {
                    this.setRowKey(facesContext, oldRowKey);
                }
                catch (Exception e) {
                    RENDERKIT_LOG.error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
        return super.resolveClientId(facesContext, contextComponent, metaComponentId);
    }

    @Override
    public void encodeMetaComponent(FacesContext context, String metaComponentId) throws IOException {
        Map attributes;
        Integer submittedClientFirst;
        if (SCROLL.equals(metaComponentId) && (submittedClientFirst = (Integer)(attributes = this.getAttributes()).remove(SUBMITTED_CLIENT_FIRST)) != null) {
            attributes.put(OLD_CLIENT_FIRST, this.getClientFirst());
            this.setClientFirst(submittedClientFirst);
        }
        super.encodeMetaComponent(context, metaComponentId);
    }

    @Override
    protected boolean visitDataChildren(VisitContext visitContext, VisitCallback callback, boolean visitRows) {
        ExtendedVisitContext extendedVisitContext;
        if (visitContext instanceof ExtendedVisitContext && visitRows && (extendedVisitContext = (ExtendedVisitContext)visitContext).getVisitMode() == ExtendedVisitContextMode.RENDER) {
            this.setRowKey(visitContext.getFacesContext(), null);
            VisitResult result = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, SCROLL);
            if (result != VisitResult.ACCEPT && result == VisitResult.COMPLETE) {
                return true;
            }
        }
        return super.visitDataChildren(visitContext, callback, visitRows);
    }

    protected int getActualFirst() {
        return this.getFirst() + this.getClientFirst();
    }

    protected int getActualRows() {
        int rows = this.getClientRows();
        if (rows > 0) {
            int r = this.getRows();
            if (r > 0 && r < rows) {
                rows = r;
            }
        } else {
            rows = this.getRows();
        }
        return rows;
    }

    public int getClientFirst() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.clientFirst), (Object)0);
    }

    public void setClientFirst(int clientFirst) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.clientFirst), (Object)clientFirst);
        this.updateState();
    }

    public void setFirst(int first) {
        super.setFirst(first);
        this.setClientFirst(0);
    }

    public int getClientRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.clientRows), (Object)0);
    }

    public void setClientRows(int clientRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.clientRows), (Object)clientRows);
        this.updateState();
    }

    public void setValueBinding(String name, ValueBinding binding) {
        super.setValueBinding(name, binding);
        if ("clientRows".equals(name)) {
            this.updateState();
        }
    }

    public void setValueExpression(String name, ValueExpression binding) {
        super.setValueExpression(name, binding);
        if ("clientRows".equals(name)) {
            this.updateState();
        }
    }

    @Attribute
    public abstract Collection<Object> getSelection();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        clientFirst,
        clientRows;

    }
}

