/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.jboss.netty.channel;

import org.sonatype.aether.ant.org.jboss.netty.channel.Channel;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChannelFuture;
import org.sonatype.aether.ant.org.jboss.netty.channel.Channels;
import org.sonatype.aether.ant.org.jboss.netty.channel.ChildChannelStateEvent;

public class DefaultChildChannelStateEvent
implements ChildChannelStateEvent {
    private final Channel parentChannel;
    private final Channel childChannel;

    public DefaultChildChannelStateEvent(Channel parentChannel, Channel childChannel) {
        if (parentChannel == null) {
            throw new NullPointerException("parentChannel");
        }
        if (childChannel == null) {
            throw new NullPointerException("childChannel");
        }
        this.parentChannel = parentChannel;
        this.childChannel = childChannel;
    }

    public Channel getChannel() {
        return this.parentChannel;
    }

    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    public Channel getChildChannel() {
        return this.childChannel;
    }

    public String toString() {
        String channelString = this.getChannel().toString();
        StringBuilder buf = new StringBuilder(channelString.length() + 32);
        buf.append(channelString);
        buf.append(this.getChildChannel().isOpen() ? " CHILD_OPEN: " : " CHILD_CLOSED: ");
        buf.append(this.getChildChannel().getId());
        return buf.toString();
    }
}

