/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.tasks;

import org.apache.tools.ant.Task;
import org.sonatype.aether.ant.org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.ant.org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.ant.org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.ant.org.sonatype.aether.graph.DependencyVisitor;

class DependencyGraphLogger
implements DependencyVisitor {
    private Task task;
    private String indent = "";

    public DependencyGraphLogger(Task task) {
        this.task = task;
    }

    public boolean visitEnter(DependencyNode node) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.indent);
        Dependency dep = node.getDependency();
        if (dep != null) {
            Artifact art = dep.getArtifact();
            buffer.append(art);
            buffer.append(':').append(dep.getScope());
            if (node.getPremanagedScope() != null && !node.getPremanagedScope().equals(dep.getScope())) {
                buffer.append(" (scope managed from ").append(node.getPremanagedScope()).append(")");
            }
            if (node.getPremanagedVersion() != null && !node.getPremanagedVersion().equals(art.getVersion())) {
                buffer.append(" (version managed from ").append(node.getPremanagedVersion()).append(")");
            }
        } else {
            buffer.append("Resolved Dependency Graph:");
        }
        this.task.log(buffer.toString(), 3);
        this.indent = this.indent + "   ";
        return true;
    }

    public boolean visitLeave(DependencyNode node) {
        this.indent = this.indent.substring(0, this.indent.length() - 3);
        return true;
    }
}

