/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.apache.maven.repository.internal;

import org.sonatype.aether.ant.org.apache.maven.model.Repository;
import org.sonatype.aether.ant.org.apache.maven.model.RepositoryPolicy;
import org.sonatype.aether.ant.org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.ant.org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.ant.org.sonatype.aether.util.artifact.DefaultArtifact;

public class ArtifactDescriptorUtils {
    public static Artifact toPomArtifact(Artifact artifact) {
        Artifact pomArtifact = artifact;
        if (pomArtifact.getClassifier().length() > 0 || !"pom".equals(pomArtifact.getExtension())) {
            pomArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
        }
        return pomArtifact;
    }

    public static RemoteRepository toRemoteRepository(Repository repository) {
        RemoteRepository result = new RemoteRepository(repository.getId(), repository.getLayout(), repository.getUrl());
        result.setPolicy(true, ArtifactDescriptorUtils.toRepositoryPolicy(repository.getSnapshots()));
        result.setPolicy(false, ArtifactDescriptorUtils.toRepositoryPolicy(repository.getReleases()));
        return result;
    }

    public static org.sonatype.aether.ant.org.sonatype.aether.repository.RepositoryPolicy toRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new org.sonatype.aether.ant.org.sonatype.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }
}

