/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.sonatype.aether.transfer;

import org.sonatype.aether.ant.org.sonatype.aether.RepositoryException;
import org.sonatype.aether.ant.org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.ant.org.sonatype.aether.repository.RemoteRepository;

public class MetadataTransferException
extends RepositoryException {
    private final Metadata metadata;
    private final RemoteRepository repository;

    static String getString(String prefix, RemoteRepository repository) {
        if (repository == null) {
            return "";
        }
        return prefix + repository.getId() + " (" + repository.getUrl() + ")";
    }

    public MetadataTransferException(Metadata metadata, RemoteRepository repository, String message) {
        super(message);
        this.metadata = metadata;
        this.repository = repository;
    }

    public MetadataTransferException(Metadata metadata, RemoteRepository repository, Throwable cause) {
        super("Could not transfer metadata " + metadata + MetadataTransferException.getString(" from/to ", repository) + MetadataTransferException.getMessage(": ", cause), cause);
        this.metadata = metadata;
        this.repository = repository;
    }

    public MetadataTransferException(Metadata metadata, RemoteRepository repository, String message, Throwable cause) {
        super(message, cause);
        this.metadata = metadata;
        this.repository = repository;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }
}

