/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.generators;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.sonatype.aether.ant.com.ning.http.client.BodyGenerator;
import org.sonatype.aether.ant.com.ning.http.client.RandomAccessBody;

public class FileBodyGenerator
implements BodyGenerator {
    private final File file;

    public FileBodyGenerator(File file) {
        if (file == null) {
            throw new IllegalArgumentException("no file specified");
        }
        this.file = file;
    }

    public RandomAccessBody createBody() throws IOException {
        return new FileBody(this.file);
    }

    protected static class FileBody
    implements RandomAccessBody {
        private final RandomAccessFile file;
        private final FileChannel channel;
        private final long length;

        public FileBody(File file) throws IOException {
            this.file = new RandomAccessFile(file, "r");
            this.channel = this.file.getChannel();
            this.length = this.file.length();
        }

        public long getContentLength() {
            return this.length;
        }

        public long read(ByteBuffer buffer) throws IOException {
            return this.channel.read(buffer);
        }

        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            return this.channel.transferTo(position, count, target);
        }

        public void close() throws IOException {
            this.file.close();
        }
    }
}

