/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.sonatype.aether.util.graph;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.sonatype.aether.ant.org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.ant.org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.ant.org.sonatype.aether.util.graph.DefaultDependencyNode;

public class CloningDependencyVisitor
implements DependencyVisitor {
    private final Map<DependencyNode, DependencyNode> clones;
    private final LinkedList<DependencyNode> parents = new LinkedList();
    private DependencyNode root;

    public CloningDependencyVisitor() {
        this.clones = new IdentityHashMap<DependencyNode, DependencyNode>(256);
    }

    public DependencyNode getRootNode() {
        return this.root;
    }

    protected DependencyNode clone(DependencyNode node) {
        DefaultDependencyNode clone = new DefaultDependencyNode(node);
        return clone;
    }

    public boolean visitEnter(DependencyNode node) {
        boolean recurse = true;
        DependencyNode clone = this.clones.get(node);
        if (clone == null) {
            clone = this.clone(node);
            this.clones.put(node, clone);
        } else {
            recurse = false;
        }
        DependencyNode parent = this.parents.peek();
        if (parent == null) {
            this.root = clone;
        } else {
            parent.getChildren().add(clone);
        }
        this.parents.addFirst(clone);
        return recurse;
    }

    public boolean visitLeave(DependencyNode node) {
        this.parents.remove();
        return true;
    }
}

