/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.extra;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.sonatype.aether.ant.com.ning.http.client.AsyncHandler;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseBodyPart;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseHeaders;
import org.sonatype.aether.ant.com.ning.http.client.HttpResponseStatus;
import org.sonatype.aether.ant.com.ning.http.client.filter.FilterContext;
import org.sonatype.aether.ant.com.ning.http.client.filter.FilterException;
import org.sonatype.aether.ant.com.ning.http.client.filter.RequestFilter;
import org.sonatype.aether.ant.org.slf4j.Logger;
import org.sonatype.aether.ant.org.slf4j.LoggerFactory;

public class ThrottleRequestFilter
implements RequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ThrottleRequestFilter.class);
    private final int maxConnections;
    private final Semaphore available;
    private final int maxWait;

    public ThrottleRequestFilter(int maxConnections) {
        this.maxConnections = maxConnections;
        this.maxWait = Integer.MAX_VALUE;
        this.available = new Semaphore(maxConnections, true);
    }

    public ThrottleRequestFilter(int maxConnections, int maxWait) {
        this.maxConnections = maxConnections;
        this.maxWait = maxWait;
        this.available = new Semaphore(maxConnections, true);
    }

    public FilterContext filter(FilterContext ctx) throws FilterException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Current Throttling Status {}", this.available.availablePermits());
            }
            if (!this.available.tryAcquire(this.maxWait, TimeUnit.MILLISECONDS)) {
                throw new FilterException(String.format("No slot available for processing Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
            }
        }
        catch (InterruptedException e) {
            throw new FilterException(String.format("Interrupted Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
        }
        return new FilterContext.FilterContextBuilder(ctx).asyncHandler(new AsyncHandlerWrapper(ctx.getAsyncHandler())).build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncHandlerWrapper<T>
    implements AsyncHandler {
        private final AsyncHandler<T> asyncHandler;

        public AsyncHandlerWrapper(AsyncHandler<T> asyncHandler) {
            this.asyncHandler = asyncHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onThrowable(Throwable t) {
            try {
                this.asyncHandler.onThrowable(t);
            }
            finally {
                ThrottleRequestFilter.this.available.release();
                if (logger.isDebugEnabled()) {
                    logger.debug("Current Throttling Status after onThrowable {}", ThrottleRequestFilter.this.available.availablePermits());
                }
            }
        }

        @Override
        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            return this.asyncHandler.onBodyPartReceived(bodyPart);
        }

        @Override
        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            return this.asyncHandler.onStatusReceived(responseStatus);
        }

        @Override
        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            return this.asyncHandler.onHeadersReceived(headers);
        }

        @Override
        public T onCompleted() throws Exception {
            ThrottleRequestFilter.this.available.release();
            if (logger.isDebugEnabled()) {
                logger.debug("Current Throttling Status {}", ThrottleRequestFilter.this.available.availablePermits());
            }
            return this.asyncHandler.onCompleted();
        }
    }
}

