/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.com.ning.http.client.oauth;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.sonatype.aether.ant.com.ning.http.client.oauth.ConsumerKey;
import org.sonatype.aether.ant.com.ning.http.client.oauth.RequestToken;
import org.sonatype.aether.ant.com.ning.http.util.UTF8Codec;

public class ThreadSafeHMAC {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private final Mac mac;

    public ThreadSafeHMAC(ConsumerKey consumerAuth, RequestToken userAuth) {
        byte[] keyBytes = UTF8Codec.toUTF8(consumerAuth.getSecret() + "&" + userAuth.getSecret());
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1_ALGORITHM);
        try {
            this.mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            this.mac.init(signingKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized byte[] digest(byte[] message) {
        this.mac.reset();
        return this.mac.doFinal(message);
    }
}

