/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.apache.maven.model.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.sonatype.aether.ant.org.apache.maven.model.Activation;
import org.sonatype.aether.ant.org.apache.maven.model.Profile;
import org.sonatype.aether.ant.org.apache.maven.model.building.ModelProblem;
import org.sonatype.aether.ant.org.apache.maven.model.building.ModelProblemCollector;
import org.sonatype.aether.ant.org.apache.maven.model.profile.ProfileActivationContext;
import org.sonatype.aether.ant.org.apache.maven.model.profile.ProfileSelector;
import org.sonatype.aether.ant.org.apache.maven.model.profile.activation.ProfileActivator;
import org.sonatype.aether.ant.org.codehaus.plexus.component.annotations.Component;
import org.sonatype.aether.ant.org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProfileSelector.class)
public class DefaultProfileSelector
implements ProfileSelector {
    @Requirement(role=ProfileActivator.class)
    private List<ProfileActivator> activators = new ArrayList<ProfileActivator>();

    public DefaultProfileSelector addProfileActivator(ProfileActivator profileActivator) {
        if (profileActivator != null) {
            this.activators.add(profileActivator);
        }
        return this;
    }

    @Override
    public List<Profile> getActiveProfiles(Collection<Profile> profiles, ProfileActivationContext context, ModelProblemCollector problems) {
        HashSet<String> activatedIds = new HashSet<String>(context.getActiveProfileIds());
        HashSet<String> deactivatedIds = new HashSet<String>(context.getInactiveProfileIds());
        ArrayList<Profile> activeProfiles = new ArrayList<Profile>(profiles.size());
        ArrayList<Profile> activePomProfilesByDefault = new ArrayList<Profile>();
        boolean activatedPomProfileNotByDefault = false;
        for (Profile profile : profiles) {
            if (deactivatedIds.contains(profile.getId())) continue;
            if (activatedIds.contains(profile.getId()) || this.isActive(profile, context, problems)) {
                activeProfiles.add(profile);
                if (!"pom".equals(profile.getSource())) continue;
                activatedPomProfileNotByDefault = true;
                continue;
            }
            if (!this.isActiveByDefault(profile)) continue;
            if ("pom".equals(profile.getSource())) {
                activePomProfilesByDefault.add(profile);
                continue;
            }
            activeProfiles.add(profile);
        }
        if (!activatedPomProfileNotByDefault) {
            activeProfiles.addAll(activePomProfilesByDefault);
        }
        return activeProfiles;
    }

    private boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        for (ProfileActivator activator : this.activators) {
            try {
                if (!activator.isActive(profile, context, problems)) continue;
                return true;
            }
            catch (RuntimeException e) {
                problems.add(ModelProblem.Severity.ERROR, "Failed to determine activation for profile " + profile.getId(), profile.getLocation(""), e);
                return false;
            }
        }
        return false;
    }

    private boolean isActiveByDefault(Profile profile) {
        Activation activation = profile.getActivation();
        return activation != null && activation.isActiveByDefault();
    }
}

