/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.sonatype.aether.repository;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Authentication {
    private final String username;
    private final char[] password;
    private final String privateKeyFile;
    private final char[] passphrase;

    private static char[] toChars(String str) {
        return str != null ? str.toCharArray() : null;
    }

    private static String toStr(char[] chars) {
        return chars != null ? new String(chars) : null;
    }

    private static char[] clone(char[] chars) {
        return chars != null ? (char[])chars.clone() : null;
    }

    private Authentication(String username, String privateKeyFile, char[] password, char[] passphrase) {
        this.username = username;
        this.password = password;
        this.privateKeyFile = privateKeyFile;
        this.passphrase = passphrase;
    }

    public Authentication(String username, char[] password, String privateKeyFile, char[] passphrase) {
        this(username, privateKeyFile, Authentication.clone(password), Authentication.clone(passphrase));
    }

    public Authentication(String username, String password, String privateKeyFile, String passphrase) {
        this(username, privateKeyFile, Authentication.toChars(password), Authentication.toChars(passphrase));
    }

    public Authentication(String username, String password) {
        this(username, (String)null, Authentication.toChars(password), null);
    }

    public Authentication(String username, char[] password) {
        this(username, password, null, null);
    }

    public String getUsername() {
        return this.username;
    }

    public Authentication setUsername(String username) {
        if (Authentication.eq(this.username, username)) {
            return this;
        }
        return new Authentication(username, this.privateKeyFile, this.password, this.passphrase);
    }

    public String getPassword() {
        return Authentication.toStr(this.password);
    }

    public Authentication setPassword(String password) {
        return this.setPasswordInternal(Authentication.toChars(password));
    }

    public Authentication setPassword(char[] password) {
        return this.setPasswordInternal(Authentication.clone(password));
    }

    private Authentication setPasswordInternal(char[] password) {
        if (Arrays.equals(this.password, password)) {
            return this;
        }
        return new Authentication(this.username, this.privateKeyFile, password, this.passphrase);
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public Authentication setPrivateKeyFile(String privateKeyFile) {
        if (Authentication.eq(this.privateKeyFile, privateKeyFile)) {
            return this;
        }
        return new Authentication(this.username, privateKeyFile, this.password, this.passphrase);
    }

    public String getPassphrase() {
        return Authentication.toStr(this.passphrase);
    }

    public Authentication setPassphrase(String passphrase) {
        return this.setPassphraseInternal(Authentication.toChars(passphrase));
    }

    public Authentication setPassphrase(char[] passphrase) {
        return this.setPassphraseInternal(Authentication.clone(passphrase));
    }

    private Authentication setPassphraseInternal(char[] passphrase) {
        if (Arrays.equals(this.passphrase, passphrase)) {
            return this;
        }
        return new Authentication(this.username, this.privateKeyFile, this.password, passphrase);
    }

    public String toString() {
        return this.getUsername();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Authentication that = (Authentication)obj;
        return Authentication.eq(this.username, that.username) && Arrays.equals(this.password, that.password) && Authentication.eq(this.privateKeyFile, that.privateKeyFile) && Arrays.equals(this.passphrase, this.passphrase);
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + Authentication.hash(this.username);
        hash = hash * 31 + Arrays.hashCode(this.password);
        hash = hash * 31 + Authentication.hash(this.privateKeyFile);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

