import groovy.transform.BaseScript
import groovy.util.logging.Slf4j
import org.apache.maven.model.Model
import org.commonjava.maven.ext.manip.model.Project
import groovy.json.JsonOutput
import groovy.json.JsonSlurper

@BaseScript org.commonjava.maven.ext.manip.groovy.BaseScript pme

@Slf4j
public class Processor {
    File basedir
    Project project

    def execute() {
        Model model = project.getModel();
        if (model.getParent().getGroupId() == "io.hawt" &&
            model.getParent().getArtifactId() == "hawtio-plugin-examples")
        {
            log.info("Running HawtIO fixup on {} ...", project.getKey())
            log.info ("Model id is " + model.getId())
            if (model.getParent().getVersion() == "1.4.55")
            {
                log.info ("Parent reference is 1.4.55")
                model.getParent().setVersion("1.4.redhat-621107")
            }
        }
    }
}

def Processor sp = new Processor(basedir:pme.getBaseDir(), project:pme.getProject())
sp.execute()
