/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.ConstantPool;
import com.claritysys.jvm.classfile.CpEntry;
import java.io.DataOutput;
import java.io.IOException;

public final class CpUtf8
extends CpEntry {
    String string;

    CpUtf8(ConstantPool cpool, int h, String s) {
        super(cpool, (byte)1, h);
        if (s == null) {
            throw new IllegalArgumentException("Cannot have null utf8");
        }
        this.string = s;
    }

    public CpUtf8(ConstantPool pool) {
        super(pool, (byte)1, 0);
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        if (this.string != null) {
            throw new IllegalArgumentException("Cannot change existing utf8 value");
        }
        this.string = string;
        this.computeHash();
    }

    void write(DataOutput dstr) throws IOException {
        dstr.writeByte(1);
        this.pool.writeUTF(dstr, this.string);
    }

    public String toString() {
        return "Utf8:    \"" + this.string + "\"";
    }

    public void computeHash() {
        this.hash = this.string.hashCode();
    }

    void postClone() {
        super.postClone();
    }
}

