/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public abstract class Assignation
extends ComputedExpression
implements Binding {
    protected int slotNumber = -1;
    protected Expression sequence;
    protected Expression action;
    protected String variableName;
    protected transient RangeVariableDeclaration declaration;

    public void setVariableDeclaration(RangeVariableDeclaration rangeVariableDeclaration) {
        this.declaration = rangeVariableDeclaration;
        this.variableName = rangeVariableDeclaration.getVariableName();
    }

    public void setAction(Expression expression) {
        this.action = expression;
        this.declaration.fixupReferences(this);
    }

    public void setSequence(Expression expression) {
        this.sequence = expression;
    }

    public void setSlotNumber(int n) {
        this.slotNumber = n;
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        this.action = this.action.simplify();
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.sequence = this.sequence.promote(promotionOffer);
        if (promotionOffer.action == 12 || promotionOffer.action == 13) {
            this.action = this.action.promote(promotionOffer);
        }
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence, this.action};
        return expressionArray;
    }

    public SequenceType getRequiredType() {
        return new SequenceType(this.sequence.getItemType(), 512);
    }

    public String getVariableName() {
        if (this.variableName == null) {
            return "zz:var" + this.hashCode();
        }
        return this.variableName;
    }

    public Value evaluateVariable(XPathContext xPathContext) throws XPathException {
        return xPathContext.evaluateLocalVariable(this.slotNumber);
    }
}

