/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.elementvalues;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructure;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.elementvalues.ElementValue;

public class ElementValuePair
extends AbstractStructure {
    public static final String ENTRY_NAME = "ElementValuePair";
    private static final int INITIAL_LENGTH = 2;
    private int elementNameIndex;
    private ElementValue elementValue;

    public static ElementValuePair create(DataInput dataInput, ClassFile classFile) throws InvalidByteCodeException, IOException {
        ElementValuePair elementValuePair = new ElementValuePair();
        elementValuePair.setClassFile(classFile);
        elementValuePair.read(dataInput);
        return elementValuePair;
    }

    public ElementValue getElementValue() {
        return this.elementValue;
    }

    public void setElementValue(ElementValue elementValue) {
        this.elementValue = elementValue;
    }

    public int getElementNameIndex() {
        return this.elementNameIndex;
    }

    public void setElementNameIndex(int n) {
        this.elementNameIndex = n;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        this.elementNameIndex = dataInput.readUnsignedShort();
        this.elementValue = ElementValue.create(dataInput, this.classFile);
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.elementNameIndex);
        this.elementValue.write(dataOutput);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected String printAccessFlagsVerbose(int n) {
        if (n != 0) {
            throw new RuntimeException("Access flags should be zero: " + Integer.toHexString(n));
        }
        return "";
    }

    protected int getLength() {
        return 2 + this.elementValue.getLength();
    }

    public String getEntryName() {
        return ENTRY_NAME;
    }
}

