/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cxf.ws.security.wss4j;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.apache.wss4j.dom.callback.DOMCallbackLookup;
import org.apache.wss4j.dom.util.WSSecurityUtil;

/**
 * This class uses a DOM-based approach to locate Elements that are referenced via an Id.
 */
public class CXFCallbackLookup extends DOMCallbackLookup {
    
    private Document doc;
    private Element soapBody;
    
    public CXFCallbackLookup(Document doc, Element soapBody) {
        super(doc);
        this.doc = doc;
        this.soapBody = soapBody;
    }
    
    /**
     * Get the SOAP Body
     */
    @Override
    public Element getSOAPBody() {
        if (soapBody != null) {
            return soapBody;
        }
        return WSSecurityUtil.findBodyElement(doc);
    }
}
