/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cxf.systest.jaxrs.security.oidc;

import java.util.List;

import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oidc.common.UserInfo;
import org.apache.cxf.rs.security.oidc.idp.UserInfoProvider;

public class UserInfoProviderImpl implements UserInfoProvider {
    
    @Override
    public UserInfo getUserInfo(String clientId, UserSubject authenticatedUser, List<String> scopes) {
        UserInfo userInfo = new UserInfo();
        userInfo.setSubject(authenticatedUser.getLogin());
        userInfo.setAudience(clientId);
        userInfo.setIssuer("xyz");
        return userInfo;
    }
}