/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.tools.corba.common;

public final class ToolCorbaConstants  {

    public static final String TOOLSPECS_BASE = "/org/apache/cxf/tools/corba/common/toolspec/toolspecs/";
    public static final String CFG_CORBA = "corba";
    public static final String CFG_IDL = "idl";
    public static final String CFG_WSDLOUTPUTFILE = "wsdloutputfile";
    public static final String CFG_IDLOUTPUTFILE = "idloutputfile";   

    public static final String CFG_IDLFILE = "idl";
    public static final String CFG_TNS = "tns";
    public static final String CFG_SCHEMA = "schema";
    public static final String CFG_IMPORTSCHEMA = "importschema";
    public static final String CFG_ADDRESS = "address";
    public static final String CFG_SEQUENCE_OCTET_TYPE = "sequencetype";
    public static final String CFG_SEQUENCE_OCTET_TYPE_BASE64BINARY = "base64Binary";
    public static final String CFG_SEQUENCE_OCTET_TYPE_HEXBINARY = "hexBinary";
    public static final String CFG_SCHEMA_NAMESPACE = "schemans";
    public static final String CFG_SCHEMA_NAMESPACE_PREFIX = "xsd1";
    public static final String CFG_ADDRESSFILE = "addressfile";
    public static final String CFG_CORBATYPEMAP_NAMESPACE = "corbatypemapns";
    public static final String CFG_WSDL_ENCODING = "encoding";
    public static final String CFG_BOUNDEDSTRINGS = "boundedstrings";
    public static final String CFG_LOGICAL = "logical";
    public static final String CFG_PHYSICAL = "physical";
    public static final String CFG_MODULETONS = "moduletonamespace";
    public static final String CFG_QUALIFIED = "qualified";
    public static final String CFG_INCLUDEDIR = "includedir";
    public static final String CFG_EXCLUDEMODULES = "excludemodules";
    public static final String CFG_POLYMORPHIC_FACTORIES = "polymorphicfactories";
                               

    public static final String MODULE_SEPARATOR = "::";
    
    private ToolCorbaConstants() {
        //utility class
    }
}
