/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.hocon;

import com.mchange.v2.cfg.DelayedLogItem;
import com.mchange.v2.cfg.PropertiesConfigSource;
import com.mchange.v3.hocon.HoconUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HoconPropertiesConfigSource
implements PropertiesConfigSource {
    private static Config extractConfig(ClassLoader cl, String identifier, List<DelayedLogItem> dlis) throws FileNotFoundException, Exception {
        int pfx_index = identifier.indexOf(58);
        ArrayList<Config> configs = new ArrayList<Config>();
        if (pfx_index >= 0 && "hocon".equals(identifier.substring(0, pfx_index).toLowerCase())) {
            String[] allFiles;
            String allFilesStr = identifier.substring(pfx_index + 1).trim();
            for (String file : allFiles = allFilesStr.split("\\s*,\\s*")) {
                String scopePath;
                String resourcePath;
                int sfx_index = file.lastIndexOf(35);
                if (sfx_index > 0) {
                    resourcePath = file.substring(0, sfx_index);
                    scopePath = file.substring(sfx_index + 1).replace('/', '.').trim();
                } else {
                    resourcePath = file;
                    scopePath = null;
                }
                Config config = null;
                if ("/".equals(resourcePath)) {
                    config = ConfigFactory.systemProperties();
                } else {
                    Config rawConfig = null;
                    if ("application".equals(resourcePath) || "/application".equals(resourcePath)) {
                        String check = System.getProperty("config.resource");
                        if (check != null) {
                            resourcePath = check;
                        } else {
                            check = System.getProperty("config.file");
                            if (check != null) {
                                File f = new File(check);
                                if (f.exists()) {
                                    if (f.canRead()) {
                                        rawConfig = ConfigFactory.parseFile((File)f);
                                    } else {
                                        dlis.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, String.format("Specified config.file '%s' is not readable. Falling back to standard application.(conf|json|properties).}", f.getAbsolutePath())));
                                    }
                                } else {
                                    dlis.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, String.format("Specified config.file '%s' does not exist. Falling back to standard application.(conf|json|properties).}", f.getAbsolutePath())));
                                }
                            } else {
                                check = System.getProperty("config.url");
                                if (check != null) {
                                    rawConfig = ConfigFactory.parseURL((URL)new URL(check));
                                }
                            }
                        }
                    }
                    if (rawConfig == null) {
                        if (resourcePath.charAt(0) == '/') {
                            resourcePath = resourcePath.substring(1);
                        }
                        boolean includes_suffix = resourcePath.indexOf(46) >= 0;
                        rawConfig = includes_suffix ? ConfigFactory.parseResources((ClassLoader)cl, (String)resourcePath) : ConfigFactory.parseResourcesAnySyntax((ClassLoader)cl, (String)resourcePath);
                    }
                    if (rawConfig.isEmpty()) {
                        dlis.add(new DelayedLogItem(DelayedLogItem.Level.FINE, String.format("Missing or empty HOCON configuration for resource path '%s'.", resourcePath)));
                    } else {
                        config = rawConfig;
                    }
                }
                if (config == null) continue;
                if (scopePath != null) {
                    config = config.getConfig(scopePath);
                }
                configs.add(config);
            }
            if (configs.size() == 0) {
                throw new FileNotFoundException(String.format("Could not find HOCON configuration at any of the listed resources in '%s'", identifier));
            }
            Config bigConfig = ConfigFactory.empty();
            int i = configs.size();
            while (--i >= 0) {
                bigConfig = bigConfig.withFallback((ConfigMergeable)configs.get(i));
            }
            return bigConfig.resolve();
        }
        throw new IllegalArgumentException(String.format("Invalid resource identifier for hocon config file: '%s'", identifier));
    }

    public PropertiesConfigSource.Parse propertiesFromSource(ClassLoader cl, String identifier) throws FileNotFoundException, Exception {
        LinkedList<DelayedLogItem> dlis = new LinkedList<DelayedLogItem>();
        Config config = HoconPropertiesConfigSource.extractConfig(cl, identifier, dlis);
        HoconUtils.PropertiesConversion pc = HoconUtils.configToProperties(config);
        for (String path : pc.unrenderable) {
            dlis.add(new DelayedLogItem(DelayedLogItem.Level.FINE, String.format("Value at path '%s' could not be converted to a String. Skipping.", path)));
        }
        return new PropertiesConfigSource.Parse(pc.properties, dlis);
    }

    @Override
    public PropertiesConfigSource.Parse propertiesFromSource(String identifier) throws FileNotFoundException, Exception {
        return this.propertiesFromSource(HoconPropertiesConfigSource.class.getClassLoader(), identifier);
    }
}

