/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class TerseFormatter
extends SimpleFormatter {
    private static final String LSEP = System.getProperty("line.separator");
    private Date date = new Date();
    private DateFormat dateFormat;
    protected String separator;
    private String formatString;
    private String[] args = new String[5];
    private boolean showClass;
    private boolean showClassShort;
    private boolean showMethod;
    private boolean showLevel;

    public TerseFormatter(boolean showLevel, boolean showClass, boolean showClassShort, boolean showMethod) {
        this.showLevel = showLevel;
        this.showClass = showClass;
        this.showClassShort = showClassShort;
        this.showMethod = showMethod;
        this.createFormatString();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    }

    public TerseFormatter(boolean showClass, boolean showClassShort, boolean showMethod) {
        this(true, showClass, showClassShort, showMethod);
    }

    public TerseFormatter() {
        this(true, false, false, false);
    }

    public void setDateFormat(DateFormat df) {
        this.dateFormat = df;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public synchronized void setSeparator(String sep) {
        this.separator = sep;
        this.createFormatString();
    }

    private void createFormatString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{0}");
        if (this.showLevel) {
            sb.append(" {1}");
        }
        if (this.showClass) {
            sb.append(" ({2}");
            if (this.showMethod) {
                sb.append("#{3}");
            }
            sb.append(" )");
        }
        sb.append(this.separator == null ? ": " : this.separator);
        sb.append("{4}");
        sb.append(LSEP);
        this.formatString = sb.toString();
    }

    public String format(LogRecord record) {
        this.date.setTime(record.getMillis());
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateTimeInstance();
        }
        this.args[0] = this.dateFormat.format(this.date);
        this.args[1] = record.getLevel().getLocalizedName();
        if (this.showClass) {
            this.args[2] = record.getSourceClassName();
        }
        if (this.showMethod) {
            this.args[3] = record.getSourceMethodName().trim();
        }
        this.args[4] = this.formatMessage(record);
        if (this.showClassShort) {
            this.args[2] = this.args[2].substring(this.args[2].lastIndexOf(46) + 1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format(this.formatString, this.args));
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return sb.toString();
    }
}

