/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import snaq.util.EventNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatcher<L extends EventListener, E extends EventObject>
extends Thread {
    private final List<L> listeners;
    private final EventNotifier<L, E> notifier;
    private final Queue<E> events = new ConcurrentLinkedQueue();
    private volatile boolean stopped = false;

    public EventDispatcher(List<L> listeners, EventNotifier<L, E> notifier) {
        this.listeners = listeners;
        this.notifier = notifier;
    }

    @Override
    public void start() {
        this.stopped = false;
        super.start();
    }

    public void halt() {
        this.stopped = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(E event) {
        if (event == null) {
            return;
        }
        this.events.add(event);
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            if (this.events.isEmpty()) {
                EventDispatcher eventDispatcher = this;
                synchronized (eventDispatcher) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ix) {
                        // empty catch block
                    }
                    continue;
                }
            }
            EventObject event = (EventObject)this.events.poll();
            if (event == null) continue;
            List<L> temp = null;
            boolean safe = this.listeners instanceof CopyOnWriteArrayList;
            if (safe) {
                temp = this.listeners;
            } else {
                List<L> list = this.listeners;
                synchronized (list) {
                    temp = new ArrayList<L>(this.listeners);
                }
            }
            for (EventListener listener : temp) {
                try {
                    this.notifier.notifyListener(listener, event);
                }
                catch (RuntimeException rx) {
                    rx.printStackTrace();
                }
            }
        }
    }
}

