/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.jazzpect;

import alt.jiapi.InstrumentationContext;
import alt.jiapi.InstrumentationDescriptor;
import alt.jiapi.JiapiException;
import alt.jiapi.interceptor.InvocationInterceptor;
import alt.jiapi.jazzpect.interceptor.MInterceptor;
import alt.jiapi.util.Bootstrapper;
import alt.jiapi.util.InstrumentingClassLoader;
import java.lang.reflect.InvocationHandler;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.log4j.Category;

public class Initializer {
    private static Category log = Category.getInstance(Initializer.class);
    private InstrumentationContext ctx = new InstrumentationContext();
    private ClassLoader classLoader;

    public Initializer(MethodInterceptor mi) throws JiapiException {
        this(new String[]{"*"}, new String[]{"java.*", "org.*", "javax.*"}, "*", mi);
    }

    public Initializer(String inclusionRule, MethodInterceptor mi) throws JiapiException {
        this(new String[]{inclusionRule}, null, "*", mi);
    }

    public Initializer(String[] inclusionRules, MethodInterceptor mi) throws JiapiException {
        this(inclusionRules, null, "*", mi);
    }

    public Initializer(String[] inclusionRules, String[] exclusionRules, String resolution, MethodInterceptor mi) throws JiapiException {
        int i;
        InstrumentationDescriptor id = new InstrumentationDescriptor();
        this.ctx.addInstrumentationDescriptor(id);
        if (inclusionRules != null) {
            for (i = 0; i < inclusionRules.length; ++i) {
                if (inclusionRules[i] != null) {
                    id.addInclusionRule(inclusionRules[i]);
                    continue;
                }
                log.warn((Object)"Skipping null inclusion rule");
            }
        }
        if (exclusionRules != null) {
            for (i = 0; i < exclusionRules.length; ++i) {
                if (exclusionRules[i] != null) {
                    id.addExclusionRule(exclusionRules[i]);
                    continue;
                }
                log.warn((Object)"Skipping null exclusion rule");
            }
        }
        if (resolution == null) {
            log.warn((Object)"Null resolution, no invocation is trapped");
            resolution = "";
        }
        InvocationInterceptor ii = new InvocationInterceptor(id, resolution, (InvocationHandler)new MInterceptor(mi));
        this.classLoader = InstrumentingClassLoader.createClassLoader(this.ctx);
    }

    public InstrumentationContext getContext() {
        return this.ctx;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void runMainMethod(String className, String[] args) {
        Bootstrapper.launch(className, args, this.getContext(), this.getClassLoader());
    }
}

