/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.ObjectValue;

public class ExternalObjectType
extends AtomicType {
    private Class javaClass;

    public ExternalObjectType(Class javaClass) {
        this.javaClass = javaClass;
    }

    public boolean isBuiltIn() {
        return true;
    }

    public boolean matchesItem(Item item) {
        if (item instanceof ObjectValue) {
            Object obj = ((ObjectValue)item).getObject();
            return this.javaClass.isAssignableFrom(obj.getClass());
        }
        return false;
    }

    public void validateContent(CharSequence value, NamespaceResolver namespaceResolver) throws ValidationException {
        throw new ValidationException("Cannot use an external object type for validation");
    }

    public ItemType getSuperType() {
        return Type.ATOMIC_TYPE;
    }

    public int getFingerprint() {
        return 285;
    }

    public String toString() {
        String name = this.javaClass.getName();
        name = name.replace('$', '-');
        return "java:" + name;
    }
}

