/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Loader;
import net.sf.saxon.expr.AppendExpression;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.CastableExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TreatExpression;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.pattern.AnyChildNodePattern;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.IDPattern;
import net.sf.saxon.pattern.KeyPattern;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.sort.Reverser;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponentMarker;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class ExpressionParser {
    protected Tokenizer t;
    protected StaticContext env;
    protected int numberOfRangeVariables = 0;
    protected Stack rangeVariables = null;
    protected boolean scanOnly = false;

    public Tokenizer getTokenizer() {
        return this.t;
    }

    protected void nextToken() throws XPathException {
        try {
            this.t.next();
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    protected void expect(int n) throws XPathException {
        if (this.t.currentToken != n) {
            this.grumble("expected \u00ab" + Tokenizer.tokens[n] + "\u00bb" + ", found \u00ab" + this.currentTokenDisplay() + "\u00bb");
        }
    }

    protected void grumble(String string) throws XPathException {
        String string2 = this.t.recentText();
        int n = this.t.getLineNumber();
        String string3 = n == 1 ? "" : "on line " + n + " ";
        String string4 = this.getLanguage() + " syntax error " + string3 + (string.startsWith("...") ? "near" : "in") + " \u00ab" + string2 + "\u00bb:\n    ";
        throw new XPathException.Static(string4 + string);
    }

    protected void warning(String string) throws XPathException {
        String string2 = this.t.recentText();
        int n = this.t.getLineNumber();
        String string3 = n == 1 ? "" : "on line " + n + " ";
        String string4 = "Warning " + string3 + (string.startsWith("...") ? "near" : "in") + " \u00ab" + string2 + "\u00bb:\n    ";
        this.env.issueWarning(string4 + string);
    }

    protected String getLanguage() {
        return "XPath";
    }

    protected String currentTokenDisplay() {
        if (this.t.currentToken == 101) {
            return "name \"" + this.t.currentTokenValue + "\"";
        }
        if (this.t.currentToken == -1) {
            return "(unknown token)";
        }
        return "\"" + Tokenizer.tokens[this.t.currentToken] + "\"";
    }

    public Expression parse(String string, int n, int n2, StaticContext staticContext) throws XPathException {
        this.numberOfRangeVariables = 0;
        this.env = staticContext;
        this.t = new Tokenizer();
        this.t.tokenize(string, n, -1);
        Expression expression = this.parseExpression();
        if (this.t.currentToken != n2) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of expression");
        }
        return expression;
    }

    public Pattern parsePattern(String string, StaticContext staticContext) throws XPathException {
        this.env = staticContext;
        this.t = new Tokenizer();
        this.t.tokenize(string, 0, -1);
        Pattern pattern = this.parseUnionPattern();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of pattern");
        }
        return pattern;
    }

    public SequenceType parseSequenceType(String string, StaticContext staticContext) throws XPathException {
        this.env = staticContext;
        this.t = new Tokenizer();
        this.t.tokenize(string, 0, -1);
        SequenceType sequenceType = this.parseSequenceType();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of SequenceType");
        }
        return sequenceType;
    }

    protected Expression parseExpression() throws XPathException {
        Expression expression = this.parseExprSingle();
        while (this.t.currentToken == 7) {
            this.nextToken();
            expression = new AppendExpression(expression, 7, this.parseExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    protected Expression parseExprSingle() throws XPathException {
        switch (this.t.currentToken) {
            case 111: 
            case 116: {
                return this.parseForExpression();
            }
            case 31: 
            case 32: {
                return this.parseQuantifiedExpression();
            }
            case 36: {
                return this.parseIfExpression();
            }
            case 58: {
                return this.parseTypeswitchExpression();
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return this.parseValidateExpression();
            }
        }
        return this.parseOrExpression();
    }

    protected Expression parseTypeswitchExpression() throws XPathException {
        this.grumble("typeswitch is not allowed in XPath");
        return null;
    }

    protected Expression parseValidateExpression() throws XPathException {
        this.grumble("validate{} expressions are not allowed in XPath");
        return null;
    }

    private Expression parseOrExpression() throws XPathException {
        Expression expression = this.parseAndExpression();
        while (this.t.currentToken == 9) {
            this.nextToken();
            expression = new BooleanExpression(expression, 9, this.parseAndExpression());
        }
        return expression;
    }

    private Expression parseAndExpression() throws XPathException {
        Expression expression = this.parseInstanceOfExpression();
        while (this.t.currentToken == 10) {
            this.nextToken();
            expression = new BooleanExpression(expression, 10, this.parseInstanceOfExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    protected Expression parseForExpression() throws XPathException {
        if (this.t.currentToken == 116) {
            this.grumble("'let' is not supported in XPath");
        }
        return this.parseMappingExpression();
    }

    private Expression parseQuantifiedExpression() throws XPathException {
        return this.parseMappingExpression();
    }

    protected Expression parseMappingExpression() throws XPathException {
        Object object;
        Object object2;
        Object object3;
        int n = this.t.currentToken;
        ArrayList<ForClause> arrayList = new ArrayList<ForClause>();
        do {
            object3 = new ForClause();
            ((ForClause)object3).lineNumber = this.t.getLineNumber();
            arrayList.add((ForClause)object3);
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            object2 = new RangeVariableDeclaration();
            ((RangeVariableDeclaration)object2).setVariableFingerprint(this.makeNameCode(string, false) & 0xFFFFF);
            ((RangeVariableDeclaration)object2).setRequiredType(SequenceType.SINGLE_ITEM);
            ((RangeVariableDeclaration)object2).setVariableName(string);
            ((ForClause)object3).rangeVariable = object2;
            this.nextToken();
            ((ForClause)object3).positionVariable = null;
            this.expect(30);
            this.nextToken();
            ((ForClause)object3).sequence = this.parseExprSingle();
            this.declareRangeVariable(((ForClause)object3).rangeVariable);
            if (((ForClause)object3).positionVariable == null) continue;
            this.declareRangeVariable(((ForClause)object3).positionVariable);
        } while (this.t.currentToken == 7);
        if (n == 111) {
            this.expect(25);
        } else {
            this.expect(33);
        }
        this.nextToken();
        object3 = this.parseExprSingle();
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            object2 = (ForClause)arrayList.get(n2);
            if (n == 111) {
                object = new ForExpression();
            } else {
                object = new QuantifiedExpression();
                ((QuantifiedExpression)object).setOperator(n);
            }
            this.setLocation((Expression)object);
            ((Assignation)object).setVariableDeclaration(((ForClause)object2).rangeVariable);
            ((Assignation)object).setSequence(((ForClause)object2).sequence);
            SequenceType sequenceType = new SequenceType(((ForClause)object2).sequence.getItemType(), 512);
            ((ForClause)object2).rangeVariable.setRequiredType(sequenceType);
            ((Assignation)object).setAction((Expression)object3);
            object3 = object;
            --n2;
        }
        int n3 = arrayList.size() - 1;
        while (n3 >= 0) {
            object = arrayList.get(n3);
            if (object instanceof ForClause && ((ForClause)object).positionVariable != null) {
                this.undeclareRangeVariable();
            }
            this.undeclareRangeVariable();
            --n3;
        }
        return object3;
    }

    private Expression parseIfExpression() throws XPathException {
        this.nextToken();
        Expression expression = this.parseExpression();
        this.expect(104);
        this.nextToken();
        this.expect(26);
        this.nextToken();
        Expression expression2 = this.parseExpression();
        this.expect(27);
        this.nextToken();
        Expression expression3 = this.parseExprSingle();
        IfExpression ifExpression = new IfExpression(expression, expression2, expression3);
        this.setLocation(ifExpression);
        return ifExpression;
    }

    private Expression parseInstanceOfExpression() throws XPathException {
        Expression expression = this.parseTreatExpression();
        if (this.t.currentToken == 41) {
            this.nextToken();
            expression = new InstanceOfExpression(expression, this.parseSequenceType());
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseTreatExpression() throws XPathException {
        Expression expression = this.parseCastableExpression();
        if (this.t.currentToken == 43) {
            this.nextToken();
            SequenceType sequenceType = this.parseSequenceType();
            expression = TreatExpression.make(expression, sequenceType);
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseCastableExpression() throws XPathException {
        Expression expression = this.parseCastExpression();
        if (this.t.currentToken == 51) {
            boolean bl;
            this.nextToken();
            this.expect(101);
            AtomicType atomicType = this.getAtomicType(this.t.currentTokenValue);
            this.nextToken();
            boolean bl2 = bl = this.t.currentToken == 113;
            if (bl) {
                this.nextToken();
            }
            expression = new CastableExpression(expression, atomicType, bl);
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseCastExpression() throws XPathException {
        Expression expression = this.parseComparisonExpression();
        if (this.t.currentToken == 42) {
            boolean bl;
            this.nextToken();
            this.expect(101);
            AtomicType atomicType = this.getAtomicType(this.t.currentTokenValue);
            this.nextToken();
            boolean bl2 = bl = this.t.currentToken == 113;
            if (bl) {
                this.nextToken();
            }
            expression = new CastExpression(expression, atomicType, bl);
            this.setLocation(expression);
        }
        return expression;
    }

    private AtomicType getAtomicType(String string) throws XPathException {
        if (this.scanOnly) {
            return Type.ATOMIC_TYPE;
        }
        try {
            String string2;
            int n;
            String[] stringArray = Name.getQNameParts(string);
            if (stringArray[0].equals("")) {
                n = this.env.getDefaultElementNamespace();
                string2 = this.env.getNamePool().getURIFromURICode((short)n);
            } else {
                try {
                    string2 = this.env.getURIForPrefix(stringArray[0]);
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage());
                    string2 = "";
                }
            }
            if (string2.equals("http://www.w3.org/2001/XMLSchema") || string2.equals("http://www.w3.org/2003/11/xpath-datatypes")) {
                ItemType itemType = Type.getBuiltInItemType(string2, stringArray[1]);
                if (itemType == null) {
                    this.grumble("Unknown atomic type " + string);
                }
                if (itemType instanceof AtomicType) {
                    return (AtomicType)itemType;
                }
                this.grumble("The type " + string + " is not atomic");
            } else {
                if (string2.equals("http://saxon.sf.net/java-type")) {
                    Class clazz = null;
                    try {
                        String string3 = stringArray[1].replace('-', '$');
                        clazz = Loader.getClass(string3);
                    }
                    catch (TransformerException transformerException) {
                        this.grumble("Unknown Java class " + stringArray[1]);
                    }
                    return new ExternalObjectType(clazz);
                }
                if (!this.env.isImportedSchema(string2)) {
                    this.grumble("There is no imported schema for namespace " + string2);
                    return null;
                }
                n = this.env.getNamePool().allocate(stringArray[0], string2, stringArray[1]);
                SchemaType schemaType = this.env.getNamePool().getSchemaType(n & 0xFFFFF);
                if (schemaType == null) {
                    this.grumble("Unknown atomic type " + string);
                } else {
                    if (schemaType instanceof AtomicType) {
                        return (AtomicType)schemaType;
                    }
                    if (schemaType.isComplexType()) {
                        this.grumble("Cannot cast to a complex type (" + string + ")");
                        return null;
                    }
                    this.grumble("Cannot cast to a list or union type (" + string + ")");
                    return null;
                }
            }
            this.grumble("Unknown atomic type " + string);
        }
        catch (QNameException qNameException) {
            this.grumble(qNameException.getMessage());
        }
        return null;
    }

    private Expression parseComparisonExpression() throws XPathException {
        Expression expression = this.parseRangeExpression();
        switch (this.t.currentToken) {
            case 20: 
            case 37: 
            case 38: {
                int n = this.t.currentToken;
                this.nextToken();
                expression = new IdentityComparison(expression, n, this.parseRangeExpression());
                this.setLocation(expression);
                return expression;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                int n = this.t.currentToken;
                this.nextToken();
                return new GeneralComparison(expression, n, this.parseRangeExpression());
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                int n = this.t.currentToken;
                this.nextToken();
                expression = new ValueComparison(expression, n, this.parseRangeExpression());
                this.setLocation(expression);
                return expression;
            }
        }
        return expression;
    }

    private Expression parseRangeExpression() throws XPathException {
        Expression expression = this.parseAdditiveExpression();
        if (this.t.currentToken == 29) {
            this.nextToken();
            expression = new RangeExpression(expression, 29, this.parseAdditiveExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    protected SequenceType parseSequenceType() throws XPathException {
        int n;
        ItemType itemType;
        if (this.t.currentToken == 101) {
            itemType = this.getAtomicType(this.t.currentTokenValue);
            this.nextToken();
        } else if (this.t.currentToken == 110) {
            if (this.t.currentTokenValue == "item") {
                this.nextToken();
                this.expect(104);
                this.nextToken();
                itemType = AnyItemType.getInstance();
            } else {
                itemType = this.parseKindTest();
            }
        } else {
            this.grumble("Expected type name in SequenceType, found " + Tokenizer.tokens[this.t.currentToken]);
            return null;
        }
        switch (this.t.currentToken) {
            case 17: 
            case 107: {
                n = 1792;
                this.nextToken();
                break;
            }
            case 15: {
                n = 1536;
                this.nextToken();
                break;
            }
            case 113: {
                n = 768;
                this.nextToken();
                break;
            }
            default: {
                n = 512;
            }
        }
        return new SequenceType(itemType, n);
    }

    private Expression parseAdditiveExpression() throws XPathException {
        Expression expression = this.parseMultiplicativeExpression();
        while (this.t.currentToken == 15 || this.t.currentToken == 16) {
            int n = this.t.currentToken;
            this.nextToken();
            expression = new ArithmeticExpression(expression, n, this.parseMultiplicativeExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseMultiplicativeExpression() throws XPathException {
        Expression expression = this.parseUnaryExpression();
        while (this.t.currentToken == 17 || this.t.currentToken == 18 || this.t.currentToken == 50 || this.t.currentToken == 19) {
            int n = this.t.currentToken;
            this.nextToken();
            expression = new ArithmeticExpression(expression, n, this.parseUnaryExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseUnaryExpression() throws XPathException {
        Expression expression;
        if (this.t.currentToken == 16) {
            this.nextToken();
            expression = new ArithmeticExpression(new IntegerValue(0L), 199, this.parseUnaryExpression());
            this.setLocation(expression);
        } else if (this.t.currentToken == 15) {
            this.nextToken();
            expression = new ArithmeticExpression(new IntegerValue(0L), 15, this.parseUnaryExpression());
            this.setLocation(expression);
        } else {
            expression = this.parseUnionExpression();
        }
        return expression;
    }

    private Expression parseUnionExpression() throws XPathException {
        Expression expression = this.parseIntersectExpression();
        while (this.t.currentToken == 1) {
            this.nextToken();
            expression = new VennExpression(expression, 1, this.parseIntersectExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    private Expression parseIntersectExpression() throws XPathException {
        Expression expression = this.parsePathExpression();
        while (this.t.currentToken == 23 || this.t.currentToken == 24) {
            int n = this.t.currentToken;
            this.nextToken();
            expression = new VennExpression(expression, n, this.parsePathExpression());
            this.setLocation(expression);
        }
        return expression;
    }

    private boolean atStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 3: 
            case 5: 
            case 34: 
            case 35: 
            case 101: 
            case 102: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: {
                return true;
            }
        }
        return false;
    }

    private Expression parsePathExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 2: {
                this.nextToken();
                ComputedExpression computedExpression = this.atStartOfRelativePath() ? new PathExpression(new RootExpression(), this.parseRelativePath()) : new RootExpression();
                this.setLocation(computedExpression);
                return computedExpression;
            }
            case 8: {
                this.nextToken();
                PathExpression pathExpression = new PathExpression(new RootExpression(), new PathExpression(new AxisExpression(5, null), this.parseRelativePath()));
                this.setLocation(pathExpression);
                return pathExpression;
            }
        }
        return this.parseRelativePath();
    }

    protected Expression parseRelativePath() throws XPathException {
        Expression expression = this.parseStepExpression();
        while (this.t.currentToken == 2 || this.t.currentToken == 8) {
            int n = this.t.currentToken;
            this.nextToken();
            Expression expression2 = this.parseRelativePath();
            expression = n == 2 ? new PathExpression(expression, expression2) : new PathExpression(expression, new PathExpression(new AxisExpression(5, null), expression2));
            this.setLocation(expression);
        }
        return expression;
    }

    protected Expression parseStepExpression() throws XPathException {
        Expression expression = this.parseBasicStep();
        boolean bl = expression instanceof AxisExpression && Axis.isReverse[((AxisExpression)expression).getAxis()];
        while (this.t.currentToken == 4) {
            this.nextToken();
            Expression expression2 = this.parseExprSingle();
            this.expect(103);
            this.nextToken();
            expression = new FilterExpression(expression, expression2);
            this.setLocation(expression);
        }
        if (bl) {
            return new Reverser(expression);
        }
        return expression;
    }

    private Expression parseBasicStep() throws XPathException {
        switch (this.t.currentToken) {
            case 21: {
                VariableReference variableReference;
                this.nextToken();
                this.expect(101);
                String string = this.t.currentTokenValue;
                this.nextToken();
                if (this.scanOnly) {
                    return new ContextItemExpression();
                }
                int n = this.makeNameCode(string, false) & 0xFFFFF;
                VariableDeclaration variableDeclaration = this.findRangeVariable(n);
                if (variableDeclaration != null) {
                    variableReference = new VariableReference(variableDeclaration);
                } else {
                    try {
                        variableReference = new VariableReference(this.env.bindVariable(n));
                    }
                    catch (XPathException xPathException) {
                        this.grumble("Variable $" + string + " has not been declared");
                        variableReference = null;
                    }
                }
                this.setLocation(variableReference);
                return variableReference;
            }
            case 5: {
                this.nextToken();
                if (this.t.currentToken == 104) {
                    this.nextToken();
                    return EmptySequence.getInstance();
                }
                Expression expression = this.parseExpression();
                this.expect(104);
                this.nextToken();
                return expression;
            }
            case 102: {
                StringValue stringValue = this.makeStringLiteral(this.t.currentTokenValue);
                this.nextToken();
                return stringValue;
            }
            case 109: {
                NumericValue numericValue = null;
                try {
                    if (this.t.currentTokenValue.indexOf(101) >= 0 || this.t.currentTokenValue.indexOf(69) >= 0) {
                        double d = new Double(this.t.currentTokenValue);
                        numericValue = new DoubleValue(d);
                    } else if (this.t.currentTokenValue.indexOf(46) >= 0 || this.t.currentTokenValue.length() > 18) {
                        numericValue = new DecimalValue(this.t.currentTokenValue);
                    } else {
                        long l = new Long(this.t.currentTokenValue);
                        numericValue = new IntegerValue(l);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.grumble("Invalid numeric literal [" + this.t.currentTokenValue + "]");
                }
                this.nextToken();
                return numericValue;
            }
            case 34: {
                return this.parseFunctionCall();
            }
            case 105: {
                this.nextToken();
                ContextItemExpression contextItemExpression = new ContextItemExpression();
                this.setLocation(contextItemExpression);
                return contextItemExpression;
            }
            case 106: {
                this.nextToken();
                ParentNodeExpression parentNodeExpression = new ParentNodeExpression();
                this.setLocation(parentNodeExpression);
                return parentNodeExpression;
            }
            case 101: 
            case 107: 
            case 108: 
            case 110: 
            case 112: {
                byte by = 3;
                if (this.t.currentToken == 110 && this.t.currentTokenValue == "attribute") {
                    by = 2;
                }
                return new AxisExpression(by, this.parseNodeTest((short)1));
            }
            case 3: {
                this.nextToken();
                switch (this.t.currentToken) {
                    case 101: 
                    case 107: 
                    case 108: 
                    case 110: 
                    case 112: {
                        return new AxisExpression(2, this.parseNodeTest((short)2));
                    }
                }
                this.grumble("@ must be followed by a NodeTest");
                break;
            }
            case 35: {
                byte by = Axis.getAxisNumber(this.t.currentTokenValue);
                short s = Axis.principalNodeType[by];
                this.nextToken();
                switch (this.t.currentToken) {
                    case 101: 
                    case 107: 
                    case 108: 
                    case 110: 
                    case 112: {
                        AxisExpression axisExpression = new AxisExpression(by, this.parseNodeTest(s));
                        this.setLocation(axisExpression);
                        return axisExpression;
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 117: {
                return this.parseConstructor();
            }
            default: {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " in path expression");
            }
        }
        return null;
    }

    protected StringValue makeStringLiteral(String string) throws XPathException {
        return new StringValue(string);
    }

    protected Expression parseConstructor() throws XPathException {
        this.grumble("Node constructor expressions are allowed only in XQuery, not in XPath");
        return null;
    }

    protected NodeTest parseNodeTest(short s) throws XPathException {
        int n = this.t.currentToken;
        String string = this.t.currentTokenValue;
        switch (n) {
            case 101: {
                this.nextToken();
                return this.makeNameTest(s, string, s == 1);
            }
            case 108: {
                this.nextToken();
                return this.makeNamespaceTest(s, string);
            }
            case 112: {
                this.nextToken();
                string = this.t.currentTokenValue;
                this.expect(101);
                this.nextToken();
                return this.makeLocalNameTest(s, string);
            }
            case 107: {
                this.nextToken();
                return NodeKindTest.makeNodeKindTest(s);
            }
            case 110: {
                return this.parseKindTest();
            }
        }
        this.grumble("Unrecognized node test");
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private NodeTest parseKindTest() throws XPathException {
        var1_1 = this.t.currentTokenValue;
        var2_2 = ExpressionParser.getSystemType(var1_1);
        var3_3 = -1;
        var4_4 = -1;
        var5_5 = false;
        this.nextToken();
        if (this.t.currentToken == 104) {
            var5_5 = true;
            this.nextToken();
        }
        switch (var2_2) {
            case 88: {
                this.grumble("item() is not allowed in a path expression");
                return null;
            }
            case 0: {
                if (var5_5) {
                    return AnyNodeTest.getInstance();
                }
                this.grumble("No arguments are allowed in node()");
                return null;
            }
            case 3: {
                if (var5_5) {
                    return NodeKindTest.TEXT;
                }
                this.grumble("No arguments are allowed in text()");
                return null;
            }
            case 8: {
                if (var5_5) {
                    return NodeKindTest.COMMENT;
                }
                this.grumble("No arguments are allowed in comment()");
                return null;
            }
            case 13: {
                this.grumble("No node test is defined for namespace nodes");
                return null;
            }
            case 9: {
                if (var5_5) {
                    return NodeKindTest.DOCUMENT;
                }
                var6_6 = 15;
                try {
                    var6_6 = ExpressionParser.getSystemType(this.t.currentTokenValue);
                }
                catch (XPathException var7_12) {
                    var6_6 = 15;
                }
                if (var6_6 != 1) {
                    this.grumble("Argument to document-node() must be an element type descriptor");
                    return null;
                }
                var7_13 = this.parseKindTest();
                this.expect(104);
                this.nextToken();
                return new DocumentNodeTest(var7_13);
            }
            case 7: {
                if (var5_5) {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                if (this.t.currentToken != 102) ** GOTO lbl64
                try {
                    var6_7 = Name.getQNameParts(this.t.currentTokenValue);
                    if (var6_7[0].equals("")) ** GOTO lbl58
                    this.warning("No processing instruction name will ever contain a colon");
                    var3_3 = this.env.getNamePool().allocate("prefix", "http://saxon.sf.net/ nonexistent namespace", "___invalid-name");
                    ** GOTO lbl74
lbl58:
                    // 1 sources

                    var3_3 = this.makeNameCode(var6_7[1], false);
                }
                catch (QNameException var6_8) {
                    this.warning("No processing instruction will ever be named '" + this.t.currentTokenValue + "'. " + var6_8.getMessage());
                    var3_3 = this.env.getNamePool().allocate("prefix", "http://saxon.sf.net/ nonexistent namespace", "___invalid-name");
                }
                ** GOTO lbl74
lbl64:
                // 1 sources

                if (this.t.currentToken == 101) {
                    try {
                        var6_9 = Name.getQNameParts(this.t.currentTokenValue);
                        if (!var6_9[0].equals("")) {
                            this.grumble("Processing instruction name must not contain a colon");
                        } else {
                            var3_3 = this.makeNameCode(var6_9[1], false);
                        }
                    }
                    catch (QNameException var6_10) {
                        this.grumble("Invalid processing instruction name. " + var6_10.getMessage());
                    }
                }
lbl74:
                // 8 sources

                this.nextToken();
                this.expect(104);
                this.nextToken();
                return new NameTest(7, var3_3);
            }
            case 1: 
            case 2: {
                var6_11 = "";
                if (var5_5) {
                    return NodeKindTest.makeNodeKindTest(var2_2);
                }
                if (this.t.currentToken == 107 || this.t.currentToken == 17) {
                    var3_3 = -1;
                } else if (this.t.currentToken == 101) {
                    var6_11 = this.t.currentTokenValue;
                    var3_3 = this.makeNameCode(this.t.currentTokenValue, true) & 1048575;
                } else {
                    this.grumble("Unexpected " + Tokenizer.tokens[this.t.currentToken] + " after '(' in SequenceType");
                }
                this.nextToken();
                if (this.t.currentToken == 2) {
                    this.grumble("Schema context paths are not yet supported");
                } else {
                    if (this.t.currentToken == 104) {
                        this.nextToken();
                        if (var3_3 == -1) {
                            return NodeKindTest.makeNodeKindTest(var2_2);
                        }
                        var7_14 /* !! */  = null;
                        var8_16 = null;
                        if (var2_2 == 2) {
                            var9_18 = this.env.getNamePool().getAttributeDeclaration(var3_3);
                            if (var9_18 == null) {
                                this.grumble("There is no declaration for attribute @" + var6_11 + " in an imported schema");
                            } else {
                                var8_16 = this.env.getConfiguration().getAttributeType((SchemaComponentMarker)var9_18);
                                var7_14 /* !! */  = new NameTest(2, var3_3);
                            }
                        } else {
                            var9_18 = this.env.getNamePool().getElementDeclaration(var3_3);
                            if (var9_18 == null) {
                                this.grumble("There is no declaration for element <" + var6_11 + "> in an imported schema");
                            } else {
                                var8_16 = this.env.getConfiguration().getElementType((SchemaComponentMarker)var9_18);
                                var7_14 /* !! */  = this.env.getConfiguration().makeSubstitutionGroupTest((SchemaComponentMarker)var9_18);
                            }
                        }
                        var9_18 = null;
                        if (var8_16 != null) {
                            var9_18 = new ContentTypeTest(var2_2, var8_16);
                        }
                        if (var9_18 == null) {
                            return var7_14 /* !! */ ;
                        }
                        return new CombinedNodeTest(var7_14 /* !! */ , 23, (NodeTest)var9_18);
                    }
                    if (this.t.currentToken == 7) {
                        this.nextToken();
                        if (this.t.currentToken == 107) {
                            var7_15 = var3_3 == -1 ? NodeKindTest.makeNodeKindTest(var2_2) : (var2_2 == 2 ? new NameTest(2, var3_3) : new NameTest(1, var3_3));
                        } else if (this.t.currentToken == 101) {
                            var4_4 = this.makeNameCode(this.t.currentTokenValue, true) & 1048575;
                            var9_19 = this.env.getNamePool().getURI(var4_4);
                            var10_20 = this.env.getNamePool().getLocalName(var4_4);
                            if (var9_19.equals("http://www.w3.org/2001/XMLSchema") || var9_19.equals("http://www.w3.org/2003/11/xpath-datatypes")) {
                                var8_17 = this.env.getNamePool().getSchemaType(var4_4);
                            } else {
                                if (!this.env.isImportedSchema(var9_19)) {
                                    this.grumble("No schema has been imported for namespace '" + var9_19 + "'");
                                }
                                var8_17 = this.env.getNamePool().getSchemaType(var4_4);
                            }
                            if (var8_17 == null) {
                                this.grumble("Unknown type name " + var10_20);
                            }
                            if (var2_2 == 2 && var8_17.isComplexType()) {
                                this.grumble("An attribute cannot have a complex type");
                            }
                            var11_21 = new ContentTypeTest(var2_2, var8_17);
                            if (var3_3 == -1) {
                                var7_15 = var11_21;
                            } else if (var2_2 == 2) {
                                var12_22 = this.env.getNamePool().getAttributeDeclaration(var3_3 & 1048575);
                                if (var12_22 == null) {
                                    this.grumble("Attribute " + var6_11 + " is not declared in an imported schema");
                                    return null;
                                }
                                var13_24 = new NameTest(2, var3_3);
                                var7_15 = new CombinedNodeTest(var13_24, 23, var11_21);
                            } else {
                                var12_23 = this.env.getNamePool().getElementDeclaration(var3_3 & 1048575);
                                if (var12_23 == null) {
                                    this.grumble("Element " + var6_11 + " is not declared in an imported schema");
                                    return null;
                                }
                                var13_25 = new NameTest(1, var3_3);
                                var7_15 = new CombinedNodeTest(var13_25, 23, var11_21);
                            }
                        } else {
                            this.grumble("Unexpected " + Tokenizer.tokens[this.t.currentToken] + " after ',' in SequenceType");
                            return null;
                        }
                        this.nextToken();
                        if (this.isKeyword("nillable")) {
                            this.grumble("'nillable' in a sequence type is not yet supported");
                            return null;
                        }
                        this.expect(104);
                        this.nextToken();
                        return var7_15;
                    }
                    this.grumble("Expected ')' or ',' in SequenceType");
                }
                return null;
            }
        }
        this.grumble("Unknown node kind");
        return null;
    }

    private static int getSystemType(String string) throws XPathException {
        if (string.equals("item")) {
            return 88;
        }
        if (string.equals("document-node")) {
            return 9;
        }
        if (string.equals("element")) {
            return 1;
        }
        if (string.equals("attribute")) {
            return 2;
        }
        if (string.equals("text")) {
            return 3;
        }
        if (string.equals("comment")) {
            return 8;
        }
        if (string.equals("processing-instruction")) {
            return 7;
        }
        if (string.equals("namespace")) {
            return 13;
        }
        if (string.equals("node")) {
            return 0;
        }
        if (string.equals("empty")) {
            return 15;
        }
        throw new XPathException.Static("Unknown type " + string);
    }

    private Expression parseFunctionCall() throws XPathException {
        Object object;
        String string = this.t.currentTokenValue;
        ArrayList<Expression[]> arrayList = new ArrayList<Expression[]>(10);
        this.nextToken();
        if (this.t.currentToken != 104) {
            object = this.parseExprSingle();
            arrayList.add((Expression[])object);
            while (this.t.currentToken == 7) {
                this.nextToken();
                object = this.parseExprSingle();
                arrayList.add((Expression[])object);
            }
            this.expect(104);
        }
        this.nextToken();
        object = new Expression[arrayList.size()];
        arrayList.toArray((T[])object);
        try {
            Expression expression = this.env.bindFunction(string, (Expression[])object);
            this.setLocation(expression);
            return expression;
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
            return null;
        }
    }

    protected void declareRangeVariable(VariableDeclaration variableDeclaration) throws XPathException {
        if (this.rangeVariables == null) {
            this.rangeVariables = new Stack();
        }
        this.rangeVariables.push(variableDeclaration);
    }

    protected void undeclareRangeVariable() {
        this.rangeVariables.pop();
    }

    private VariableDeclaration findRangeVariable(int n) {
        if (this.rangeVariables == null) {
            return null;
        }
        int n2 = this.rangeVariables.size() - 1;
        while (n2 >= 0) {
            VariableDeclaration variableDeclaration = (VariableDeclaration)this.rangeVariables.elementAt(n2);
            if (variableDeclaration.getVariableFingerprint() == n) {
                return variableDeclaration;
            }
            --n2;
        }
        return null;
    }

    public Stack getRangeVariableStack() {
        return this.rangeVariables;
    }

    public void setRangeVariableStack(Stack stack) {
        this.rangeVariables = stack;
    }

    private Pattern parseUnionPattern() throws XPathException {
        Pattern pattern = this.parsePathPattern();
        while (this.t.currentToken == 1) {
            this.nextToken();
            Pattern pattern2 = this.parsePathPattern();
            pattern = new UnionPattern(pattern, pattern2);
        }
        return pattern;
    }

    private Pattern parsePathPattern() throws XPathException {
        Pattern pattern;
        Pattern pattern2 = null;
        int n = -1;
        boolean bl = false;
        switch (this.t.currentToken) {
            case 2: {
                n = this.t.currentToken;
                this.nextToken();
                pattern2 = NodeKindTest.makeNodeKindTest(9);
                bl = true;
                break;
            }
            case 8: {
                n = this.t.currentToken;
                this.nextToken();
                pattern2 = NodeKindTest.makeNodeKindTest(9);
                bl = false;
                break;
            }
        }
        while (true) {
            pattern = null;
            switch (this.t.currentToken) {
                case 35: {
                    if (this.t.currentTokenValue.equals("child")) {
                        this.nextToken();
                        pattern = this.parsePatternStep((short)1);
                        break;
                    }
                    if (this.t.currentTokenValue.equals("attribute")) {
                        this.nextToken();
                        pattern = this.parsePatternStep((short)2);
                        break;
                    }
                    this.grumble("Axis in pattern must be child or attribute");
                    break;
                }
                case 101: 
                case 107: 
                case 108: 
                case 110: 
                case 112: {
                    pattern = this.parsePatternStep((short)1);
                    break;
                }
                case 3: {
                    this.nextToken();
                    pattern = this.parsePatternStep((short)2);
                    break;
                }
                case 34: {
                    Object object;
                    if (pattern2 != null) {
                        this.grumble("Function call may appear only at the start of a pattern");
                    }
                    if (this.t.currentTokenValue.equals("id")) {
                        this.nextToken();
                        object = null;
                        if (this.t.currentToken == 102) {
                            object = new StringValue(this.t.currentTokenValue);
                        } else if (this.t.currentToken == 21) {
                            this.nextToken();
                            this.expect(101);
                            int n2 = this.makeNameCode(this.t.currentTokenValue, false) & 0xFFFFF;
                            object = new VariableReference(this.env.bindVariable(n2));
                        } else {
                            this.grumble("id value must be either a literal or a variable reference");
                        }
                        pattern = new IDPattern((Expression)object);
                        this.nextToken();
                        this.expect(104);
                        this.nextToken();
                        break;
                    }
                    if (this.t.currentTokenValue.equals("key")) {
                        this.nextToken();
                        this.expect(102);
                        object = this.t.currentTokenValue;
                        this.nextToken();
                        this.expect(7);
                        this.nextToken();
                        Expression expression = null;
                        if (this.t.currentToken == 102) {
                            expression = new StringValue(this.t.currentTokenValue);
                        } else if (this.t.currentToken == 21) {
                            this.nextToken();
                            this.expect(101);
                            int n3 = this.makeNameCode(this.t.currentTokenValue, false) & 0xFFFFF;
                            expression = new VariableReference(this.env.bindVariable(n3));
                        } else {
                            this.grumble("key value must be either a literal or a variable reference");
                        }
                        pattern = new KeyPattern(this.makeNameCode((String)object, false), expression);
                        this.nextToken();
                        this.expect(104);
                        this.nextToken();
                        break;
                    }
                    this.grumble("The only functions allowed in a pattern are id() and key()");
                    break;
                }
                default: {
                    if (bl) {
                        return pattern2;
                    }
                    this.grumble("Unexpected token in pattern, found " + this.currentTokenDisplay());
                }
            }
            if (pattern2 != null) {
                if (n == 2) {
                    ((LocationPathPattern)pattern).parentPattern = pattern2;
                } else {
                    ((LocationPathPattern)pattern).ancestorPattern = pattern2;
                }
            }
            n = this.t.currentToken;
            bl = false;
            if (n != 2 && n != 8) break;
            pattern2 = pattern;
            this.nextToken();
        }
        return pattern;
    }

    private Pattern parsePatternStep(short s) throws XPathException {
        LocationPathPattern locationPathPattern = new LocationPathPattern();
        NodeTest nodeTest = this.parseNodeTest(s);
        if (nodeTest instanceof AnyNodeTest) {
            nodeTest = s == 1 ? new AnyChildNodePattern() : NodeKindTest.makeNodeKindTest(s);
        }
        int n = nodeTest.getNodeKind();
        if (s == 1 && (n == 2 || n == 13)) {
            nodeTest = new NoNodeTest();
        } else if (s == 2 && (n == 8 || n == 3 || n == 7 || n == 1 || n == 9)) {
            nodeTest = new NoNodeTest();
        }
        locationPathPattern.nodeTest = nodeTest;
        this.parseFilters(locationPathPattern);
        return locationPathPattern;
    }

    private void parseFilters(LocationPathPattern locationPathPattern) throws XPathException {
        while (this.t.currentToken == 4) {
            this.nextToken();
            Expression expression = this.parseExprSingle();
            this.expect(103);
            this.nextToken();
            locationPathPattern.addFilter(expression);
        }
    }

    public final int makeNameCode(String string, boolean bl) throws XPathException {
        if (this.scanOnly) {
            return -1;
        }
        try {
            String[] stringArray = Name.getQNameParts(string);
            String string2 = stringArray[0];
            if (string2.equals("")) {
                short s = 0;
                if (bl) {
                    s = this.env.getDefaultElementNamespace();
                }
                return this.env.getNamePool().allocate(string2, s, string);
            }
            try {
                String string3 = this.env.getURIForPrefix(string2);
                return this.env.getNamePool().allocate(string2, string3, stringArray[1]);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage());
                return -1;
            }
        }
        catch (QNameException qNameException) {
            this.grumble(qNameException.getMessage());
            return -1;
        }
    }

    public NameTest makeNameTest(short s, String string, boolean bl) throws XPathException {
        int n = this.makeNameCode(string, bl);
        NameTest nameTest = new NameTest(s, n);
        nameTest.setOriginalText(string);
        return nameTest;
    }

    public NamespaceTest makeNamespaceTest(short s, String string) throws XPathException {
        if (this.scanOnly) {
            return new NamespaceTest(this.env.getNamePool(), s, "http://saxon.sf.net/");
        }
        NamespaceTest namespaceTest = new NamespaceTest(this.env.getNamePool(), s, this.env.getURIForPrefix(string));
        namespaceTest.setOriginalText(string + ":*");
        return namespaceTest;
    }

    public LocalNameTest makeLocalNameTest(short s, String string) throws XPathException {
        if (!XMLChar.isValidNCName(string)) {
            this.grumble("Local name [" + string + "] contains invalid characters");
        }
        return new LocalNameTest(this.env.getNamePool(), s, string);
    }

    protected void setLocation(Expression expression) {
        if (expression instanceof ComputedExpression) {
            ((ComputedExpression)expression).setLineNumber((short)this.t.getLineNumber());
        }
        if (expression instanceof Instruction) {
            ((Instruction)((Object)expression)).setSourceLocation(0, this.t.getLineNumber());
        }
    }

    protected void setLocation(Expression expression, int n) {
        if (expression instanceof ComputedExpression) {
            ((ComputedExpression)expression).setLineNumber((short)n);
        }
        if (expression instanceof Instruction) {
            ((Instruction)((Object)expression)).setSourceLocation(0, n);
        }
    }

    protected SourceLocator makeLocator() {
        ExpressionLocation expressionLocation = new ExpressionLocation();
        expressionLocation.setLineNumber((short)this.t.getLineNumber());
        return expressionLocation;
    }

    protected boolean isKeyword(String string) {
        return this.t.currentToken == 101 && this.t.currentTokenValue.equals(string);
    }

    public void setScanOnly(boolean bl) {
        this.scanOnly = bl;
    }

    public static class ForClause {
        public RangeVariableDeclaration rangeVariable;
        public RangeVariableDeclaration positionVariable;
        public Expression sequence;
        public int lineNumber;
    }
}

