%define version 4.0.7
%define kversion %(uname -r)

summary: Intel(R) PRO/1000 driver for Linux
name: e1000
version: %{version}
release: 1
source: %{name}-%{version}.tar.gz
vendor: Intel Corporation
license: BSD with patent grant
exclusiveos: linux
group: System Environment/Kernel
url: http://support.intel.com/support/go/linux/e1000.htm
BuildRoot: /var/tmp/%{name}-%{version}-root

%description
This package contains the Linux driver for the
Intel(R) PRO/1000 Family of Server Adapters.

%package %{kversion}
summary: Intel(R) PRO/1000 driver for Linux %{kversion}
group: System Environment/Kernel
provides: %{name}
%description %{kversion}
This package contains the Linux driver for the
Intel(R) PRO/1000 Family of Server Adapters.
The driver has been compiled for use with the %{kversion} Linux kernel.

%package source
summary: Source for the Intel(R) PRO/1000 driver for Linux
group: System Environment/Kernel
%description source
This package contains the source to the Linux driver for the
Intel(R) PRO/1000 Family of Server Adapters.

%prep
%setup

%build
# compile the driver
make -C src

%install
# install the driver into the build root
make -C src INSTALL_MOD_PATH=$RPM_BUILD_ROOT MANDIR=%{_mandir} install
# clean out the files created by running depmod in make install
rm -f $RPM_BUILD_ROOT/lib/modules/%{kversion}/modules.*
# put the source back into it's original state
make -C src clean
# save off a copy of the source
mkdir -p $RPM_BUILD_ROOT/usr/src/%{name}-%{version}
cp -R * $RPM_BUILD_ROOT/usr/src/%{name}-%{version}

%clean
rm -rf $RPM_BUILD_ROOT

%files %{kversion}
%defattr(-,root,root)
/lib/modules/%{kversion}/*
%{_mandir}/*
%doc LICENSE
%doc README
%doc ldistrib.txt

%files source
%defattr(-,root,root)
/usr/src/%{name}-%{version}
%doc LICENSE
%doc README
%doc ldistrib.txt

%post %{kversion}
depmod -a

%postun %{kversion}
depmod -a

