/*******************************************************************************

  Recipient has requested a license and Intel Corporation ("Intel") is
  willing to grant a license for the software entitled Linux Base Driver
  for the Intel(R) PRO/1000 Familty of Adapters (e1000) (the "Software")
  being provided by Intel Corporation.
  
  The following definitions apply to this License:
  
  "Licensed Patents" means patent claims licensable by Intel Corporation
  which are necessarily infringed by the use or sale of the Software alone
  or when combined with the operating system referred to below.
  "Recipient" means the party to whom Intel delivers this Software.
  "Licensee" means Recipient and those third parties that receive a license
  to any operating system available under the GNU Public License version
  2.0 or later.
  
  Copyright (c) 1999-2001 Intel Corporation All rights reserved.
  
  The license is provided to Recipient and Recipient's Licensees under
  the following terms.
  
  Redistribution and use in source and binary forms of the Software,
  with or without modification, are permitted provided that the following
  conditions are met:
  
  Redistributions of source code of the Software may retain the above
  copyright notice, this list of conditions and the following disclaimer.
  Redistributions in binary form of the Software may reproduce the above
  copyright notice, this list of conditions and the following disclaimer in
  the documentation and/or other materials provided with the distribution.
  Neither the name of Intel Corporation nor the names of its contributors
  shall be used to endorse or promote products derived from this Software
  without specific prior written permission.
  
  Intel hereby grants Recipient and Licensees a non-exclusive, worldwide,
  royalty-free patent license under Licensed Patents to make, use, sell,
  offer to sell, import and otherwise transfer the Software, if any, in
  source code and object code form. This license shall include changes
  to the Software that are error corrections or other minor changes
  to the Software that do not add functionality or features when the
  Software is incorporated in any version of a operating system that has
  been distributed under the GNU General Public License 2.0 or later.
  This patent license shall apply to the combination of the Software and
  any operating system licensed under the GNU Public License version 2.0
  or later if, at the time Intel provides the Software to Recipient, such
  addition of the Software to the then publicly available versions of such
  operating system available under the GNU Public License version 2.0 or
  later (whether in gold, beta or alpha form) causes such combination to
  be covered by the Licensed Patents. The patent license shall not apply
  to any other combinations which include the Software. No hardware per
  se is licensed hereunder.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR ITS CONTRIBUTORS
  BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

/**********************************************************************
 *                                                                     *
 * INTEL CORPORATION                                                   *
 *                                                                     *
 * This software is supplied under the terms of the license included   *
 * above.  All use of this software must be in accordance with the     *
 * terms of that license.                                              *
 *                                                                     *
 * Module Name:  idiag_pro.h                                           *
 *                                                                     *
 * Abstract:     Header file for data structure definition for common  *
 *               diagnostics support                                   *
 *                                                                     *
 **********************************************************************/

#ifndef _IDIAG_PRO_H
#define _IDIAG_PRO_H

#ifndef u16
#define u16 uint16_t
#endif

#ifndef u32
#define u32 uint32_t
#endif

#define IDIAG_PRO_VERSION           0x100
#define IDIAG_PRO_PARAM_SIZE        0x80

#define IDIAG_PRO_DRIVER_UNKNOWN    0x0
#define IDIAG_PRO_IDENTIFY_DRIVER   0x0

#define IDIAG_PRO_BASE_SIOC    (SIOCDEVPRIVATE + 2)

/* Enumeration typedefines */
typedef enum {
    IDIAG_PRO_STAT_OK,
    IDIAG_PRO_STAT_BAD_PARAM,
    IDIAG_PRO_STAT_TEST_FAILED,
    IDIAG_PRO_STAT_INVALID_STATE,
    IDIAG_PRO_STAT_NOT_SUPPORTED,
    IDIAG_PRO_STAT_TEST_FATAL
} idiag_pro_stat_t;

typedef struct {
    unsigned int cmd;
    unsigned int interface_ver;
    unsigned int driver_id;
    unsigned int reserved_in[8];
    idiag_pro_stat_t status;
    unsigned int reserved_out[8];
    unsigned char diag_param[IDIAG_PRO_PARAM_SIZE];
} idiag_pro_data_t;

#endif
