/**********************************************************************
This software program is available to you under a choice of one of two 
licenses. You may choose to be licensed under either the GNU General Public 
License (GPL) Version 2, June 1991, available at 
http://www.fsf.org/copyleft/gpl.html, or the Intel BSD + Patent License, the 
text of which follows:

Recipient has requested a license and Intel Corporation ("Intel") is willing
to grant a license for the software entitled Linux Base Driver for the 
Intel(R) PRO/100 Family of Adapters (e100) (the "Software") being provided 
by Intel Corporation. The following definitions apply to this license:

"Licensed Patents" means patent claims licensable by Intel Corporation which 
are necessarily infringed by the use of sale of the Software alone or when 
combined with the operating system referred to below.

"Recipient" means the party to whom Intel delivers this Software.

"Licensee" means Recipient and those third parties that receive a license to 
any operating system available under the GNU Public License version 2.0 or 
later.

Copyright (c) 1999 - 2002 Intel Corporation.
All rights reserved.

The license is provided to Recipient and Recipient's Licensees under the 
following terms.

Redistribution and use in source and binary forms of the Software, with or 
without modification, are permitted provided that the following conditions 
are met:

Redistributions of source code of the Software may retain the above 
copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form of the Software may reproduce the above 
copyright notice, this list of conditions and the following disclaimer in 
the documentation and/or materials provided with the distribution.

Neither the name of Intel Corporation nor the names of its contributors 
shall be used to endorse or promote products derived from this Software 
without specific prior written permission.

Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
royalty-free patent license under Licensed Patents to make, use, sell, offer 
to sell, import and otherwise transfer the Software, if any, in source code 
and object code form. This license shall include changes to the Software 
that are error corrections or other minor changes to the Software that do 
not add functionality or features when the Software is incorporated in any 
version of an operating system that has been distributed under the GNU 
General Public License 2.0 or later. This patent license shall apply to the 
combination of the Software and any operating system licensed under the GNU 
Public License version 2.0 or later if, at the time Intel provides the 
Software to Recipient, such addition of the Software to the then publicly 
available versions of such operating systems available under the GNU Public 
License version 2.0 or later (whether in gold, beta or alpha form) causes 
such combination to be covered by the Licensed Patents. The patent license 
shall not apply to any other combinations which include the Software. NO 
hardware per se is licensed hereunder.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/

#ifndef _E100_INC_
#define _E100_INC_

#ifdef MODULE
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif /* MODVERSIONS */
#include <linux/module.h>
#endif /* MODULE */
#include <linux/types.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/version.h>
#include <linux/string.h>
#include <linux/wait.h>
#include <asm/io.h>
#include <asm/unaligned.h>


#ifdef IANS
#include "ans_driver.h"
#endif

#ifdef IDIAG_PRO_SUPPORT
#include "idiag_pro.h"
#include "idiag_e100.h"
#endif

#include <linux/if.h>
#include <linux/config.h>
#include <asm/uaccess.h>
#include <linux/proc_fs.h>
#include <linux/ip.h>
#include "e100_kcompat.h"

/* E100 compile time configurable parameters */

/* Power Management */
#define   PMCSR         0xe0
#define   PM_ENABLE_BIT 0x0100

/*
 *  Configure parameters for buffers per controller.
 *  If the machine this is being used on is a faster machine (i.e. > 150MHz)
 *  and running on a 10MBS network then more queueing of data occurs. This
 *  may indicate the some of the numbers below should be adjusted.  Here are
 *  some typical numbers:
 *                             MAX_TCB 64
 *                             MAX_RFD 64
 *  The default numbers give work well on most systems tests so no real
 *  adjustments really need to take place.  Also, if the machine is connected
 *  to a 100MBS network the numbers described above can be lowered from the
 *  defaults as considerably less data will be queued.
 */

#define MAX_TCB        64           /* number of transmit control blocks */
#define MAX_TBD        MAX_TCB
#define TX_FRAME_CNT   7        /* consecutive transmit frames per interrupt */
/* TX_FRAME_CNT must be less than MAX_TCB    */
#define MAX_RFD      64

#define E100_DEFAULT_TCB   MAX_TCB
#define E100_MIN_TCB       2*TX_FRAME_CNT + 3 /* make room for at least 2 interrupts */

#ifdef __ia64__
 /* We can't use too many DMAble buffers on IA64 machines with >4 GB mem*/
#define E100_MAX_TCB       64
#else
#define E100_MAX_TCB       1024
#endif /*  __ia64__ */

#define E100_DEFAULT_RFD   MAX_RFD
#define E100_MIN_RFD       8

#ifdef __ia64__
 /* We can't use too many DMAble buffers on IA64 machines with >4 GB mem*/
#define E100_MAX_RFD       64  
#else
#define E100_MAX_RFD       1024
#endif /*  __ia64__ */

#define E100_DEFAULT_XSUM         TRUE
#define E100_DEFAULT_BER          ZLOCK_MAX_ERRORS
#define E100_DEFAULT_SPEED_DUPLEX 0
#define E100_DEFAULT_FC           0
#define E100_DEFAULT_IFS          TRUE
#define E100_DEFAULT_UCODE        TRUE


#define TX_CONG_DFLT   0       /* congestion enable flag for National TX Phy */
#define TX_FIFO_LMT    0
#define RX_FIFO_LMT    8
#define TX_DMA_CNT     0
#define RX_DMA_CNT     0
#define TX_UR_RETRY    3
#define TX_THRSHLD     8

/* These are special #defs and are NOT TO BE TOUCHED! */
#define DEFAULT_TX_FIFO_LIMIT      0x00
#define DEFAULT_RX_FIFO_LIMIT      0x08
#define DEFAULT_TRANSMIT_THRESHOLD     12   /* 12 -> 96 bytes */
/* IFS parameters */
#define MIN_NUMBER_OF_TRANSMITS_100 1000
#define MIN_NUMBER_OF_TRANSMITS_10  100

#define MAX_NIC 16

/* Note: The parameter below might affect NFS performance. If there are
 * problems with NFS, set CFG_BYTE_PARM6 to 0x32.
 */

/* CFG_BYTE_PARM6: Determines whether the card generates CNA interrupts
 * or not. 
 * 0x32 configures the card to generate CNA interrupts
 * 0x3a configures the card not to generate CNA interrupts
 */
#define CFG_BYTE_PARM6         0x32

/* CPUSAVER_BUNDLE_MAX: Sets the maximum number of frames that will be bundled.
 * In some situations, such as the TCP windowing algorithm, it may be
 * better to limit the growth of the bundle size than let it go as
 * high as it can, because that could cause too much added latency.
 * The default is six, because this is the number of packets in the
 * default TCP window size.  A value of 1 would make CPUSaver indicate
 * an interrupt for every frame received.  If you do not want to put
 * a limit on the bundle size, set this value to xFFFF.
 */
#define E100_DEFAULT_CPUSAVER_BUNDLE_MAX	6
#define E100_DEFAULT_CPUSAVER_INTERRUPT_DELAY	0x600
#define E100_DEFAULT_BUNDLE_SMALL_FR		FALSE

/* end of configurables */

/* ====================================================================== */
/*                                hw                                      */
/* ====================================================================== */


/* timeout for command completion */
#define E100_CMD_WAIT   100     /* iterations */

struct driver_stats {
    struct net_device_stats net_stats;

    unsigned long tx_late_col;
    unsigned long tx_ok_defrd;
    unsigned long tx_one_retry;
    unsigned long tx_mt_one_retry;
    unsigned long rcv_cdt_frames;
    unsigned long xmt_fc_pkts;
    unsigned long rcv_fc_pkts;
    unsigned long rcv_fc_unsupported;
    unsigned long xmt_tco_pkts;
    unsigned long rcv_tco_pkts;
};

#define B_TRUE          1
#define B_FALSE         0
#define TRUE            1
#define FALSE           0

/* Changed for 82558 and 82559 enhancements */
/* defines for 82558/9 flow control configure paramters */
#define DFLT_FC_DELAY_LSB  0x1f /* Delay for outgoing Pause frames */
#define DFLT_FC_DELAY_MSB  0x01 /* Delay for outgoing Pause frames */

/* defines for 82558/9 flow control CSR values */
#define DFLT_FC_THLD       0x00 /* Rx FIFO threshold of 0.5KB free  */
#define DFLT_FC_CMD        0x00 /* FC Command in CSR */

/* ====================================================================== */
/*                              equates                                   */
/* ====================================================================== */

/*
 * These are general purpose defines 
 */

/* Bit Mask definitions */
#define BIT_0       0x0001
#define BIT_1       0x0002
#define BIT_2       0x0004
#define BIT_3       0x0008
#define BIT_4       0x0010
#define BIT_5       0x0020
#define BIT_6       0x0040
#define BIT_7       0x0080
#define BIT_8       0x0100
#define BIT_9       0x0200
#define BIT_10      0x0400
#define BIT_11      0x0800
#define BIT_12      0x1000
#define BIT_13      0x2000
#define BIT_14      0x4000
#define BIT_15      0x8000
#define BIT_28      0x10000000

#define BIT_0_2     0x0007
#define BIT_0_3     0x000F
#define BIT_0_4     0x001F
#define BIT_0_5     0x003F
#define BIT_0_6     0x007F
#define BIT_0_7     0x00FF
#define BIT_0_8     0x01FF
#define BIT_0_13    0x3FFF
#define BIT_0_15    0xFFFF
#define BIT_1_2     0x0006
#define BIT_1_3     0x000E
#define BIT_2_5     0x003C
#define BIT_3_4     0x0018
#define BIT_4_5     0x0030
#define BIT_4_6     0x0070
#define BIT_4_7     0x00F0
#define BIT_5_7     0x00E0
#define BIT_5_12    0x1FE0
#define BIT_5_15    0xFFE0
#define BIT_6_7     0x00c0
#define BIT_7_11    0x0F80
#define BIT_8_10    0x0700
#define BIT_9_13    0x3E00
#define BIT_12_15   0xF000
#define BIT_8_15    0xFF00

#define BIT_16_20   0x001F0000
#define BIT_21_25   0x03E00000
#define BIT_26_27   0x0C000000

#define E100_NULL ((u32)0xffffffff)

/* Phy related constants */
#define PHY_503                 0
#define PHY_100_A               0x000003E0
#define PHY_100_C               0x035002A8
#define PHY_NSC_TX              0x5c002000
#define PHY_82562ET             0x033002A8
#define PHY_82562EM             0x032002A8
#define PHY_82562EH             0x017002A8
#define PHY_82555_TX            0x015002a8   /* added this for 82555 */
#define PHY_OTHER               0xFFFF
#define MAX_PHY_ADDR            31

#define PHY_MODEL_REV_ID_MASK   0xFFF0FFFF

/* Transmit Threshold related constants */
#define DEFAULT_TX_PER_UNDERRUN         20000

#define MAX_MULTICAST_ADDRS             64

#define FULL_DUPLEX      2
#define HALF_DUPLEX      1

/*
 * These defines are specific to the 82557 
 */


/* E100 PORT functions -- lower 4 bits */
#define PORT_SOFTWARE_RESET         0
#define PORT_SELFTEST               1
#define PORT_SELECTIVE_RESET        2
#define PORT_DUMP                   3

/* SCB Status Word bit definitions */
/* Interrupt status/ack fields */
/* ER and FCP interrupts for 82558 masks  */
#define SCB_STATUS_ACK_MASK        BIT_8_15   /* Status Mask */
#define SCB_STATUS_ACK_CX          BIT_15   /* CU Completed Action Cmd */
#define SCB_STATUS_ACK_FR          BIT_14   /* RU Received A Frame */
#define SCB_STATUS_ACK_CNA         BIT_13   /* CU Became Inactive (IDLE) */
#define SCB_STATUS_ACK_RNR         BIT_12   /* RU Became Not Ready */
#define SCB_STATUS_ACK_MDI         BIT_11   /* MDI read or write done */
#define SCB_STATUS_ACK_SWI         BIT_10   /* S/W generated interrupt */
#define SCB_STATUS_ACK_ER          BIT_9   /* Early Receive */
#define SCB_STATUS_ACK_FCP         BIT_8   /* Flow Control Pause */

/*- CUS Fields */
#define SCB_CUS_MASK            (BIT_6 | BIT_7)   /* CUS 2-bit Mask */
#define SCB_CUS_IDLE            0   /* CU Idle */
#define SCB_CUS_SUSPEND         BIT_6   /* CU Suspended */
#define SCB_CUS_ACTIVE          BIT_7   /* CU Active */

/*- RUS Fields */
#define SCB_RUS_IDLE            0   /* RU Idle */
#define SCB_RUS_MASK            BIT_2_5   /* RUS 3-bit Mask */
#define SCB_RUS_SUSPEND         BIT_2   /* RU Suspended */
#define SCB_RUS_NO_RESOURCES    BIT_3   /* RU Out Of Resources */
#define SCB_RUS_READY           BIT_4   /* RU Ready */
#define SCB_RUS_SUSP_NO_RBDS    (BIT_2 | BIT_5)   /* RU No More RBDs */
#define SCB_RUS_NO_RBDS         (BIT_3 | BIT_5)   /* RU No More RBDs */
#define SCB_RUS_READY_NO_RBDS   (BIT_4 | BIT_5)   /* RU Ready, No RBDs */


/* SCB Command Word bit definitions */
/*- CUC fields */
/* Changing mask to 4 bits */
#define SCB_CUC_MASK            BIT_4_7   /* CUC 4-bit Mask */
#define SCB_CUC_NOOP            0
#define SCB_CUC_START           BIT_4   /* CU Start */
#define SCB_CUC_RESUME          BIT_5   /* CU Resume */
/* Changed for 82558 enhancements */
#define SCB_CUC_STATIC_RESUME   (BIT_5 | BIT_7)   /* 82558/9 Static Resume */
#define SCB_CUC_DUMP_ADDR       BIT_6   /* CU Dump Counters Address */
#define SCB_CUC_DUMP_STAT       (BIT_4 | BIT_6)   /* CU Dump stat. counters */
#define SCB_CUC_LOAD_BASE       (BIT_5 | BIT_6)   /* Load the CU base */
/* Below was defined as BIT_4_7 */
#define SCB_CUC_DUMP_RST_STAT   BIT_4_6   /* CU Dump & reset statistics cntrs */

/*- RUC fields */
#define SCB_RUC_MASK            BIT_0_2   /* RUC 3-bit Mask */
#define SCB_RUC_START           BIT_0   /* RU Start */
#define SCB_RUC_RESUME          BIT_1   /* RU Resume */
#define SCB_RUC_ABORT           BIT_2   /* RU Abort */
#define SCB_RUC_LOAD_HDS        (BIT_0 | BIT_2)   /* Load RFD Header Data Size */
#define SCB_RUC_LOAD_BASE       (BIT_1 | BIT_2)   /* Load the RU base */
#define SCB_RUC_RBD_RESUME      BIT_0_2   /* RBD resume */

/* Interrupt fields (assuming byte addressing) */
#define SCB_INT_MASK            BIT_0   /* Mask interrupts */
#define SCB_SOFT_INT            BIT_1   /* Generate a S/W interrupt */
/*  Specific Interrupt Mask Bits (upper byte of SCB Command word) */
#define SCB_FCP_INT_MASK        BIT_2   /* Flow Control Pause */
#define SCB_ER_INT_MASK         BIT_3   /* Early Receive */
#define SCB_RNR_INT_MASK        BIT_4   /* RU Not Ready */
#define SCB_CNA_INT_MASK        BIT_5   /* CU Not Active */
#define SCB_FR_INT_MASK         BIT_6   /* Frame Received */
#define SCB_CX_INT_MASK         BIT_7   /* CU eXecution w/ I-bit done */
#define SCB_BACHELOR_INT_MASK   BIT_2_7   /* 82558 interrupt mask bits */

#define SCB_GCR2_EEPROM_ACCESS_SEMAPHORE BIT_7

/* EEPROM bit definitions */
/*- EEPROM control register bits */
#define EN_TRNF          0x10     /* Enable turnoff */
#define EEDO             0x08     /* EEPROM data out */
#define EEDI             0x04     /* EEPROM data in (set for writing data) */
#define EECS             0x02     /* EEPROM chip select (1=hi, 0=lo) */
#define EESK             0x01     /* EEPROM shift clock (1=hi, 0=lo) */

/*- EEPROM opcodes */
#define EEPROM_READ_OPCODE          06
#define EEPROM_WRITE_OPCODE         05
#define EEPROM_ERASE_OPCODE         07
#define EEPROM_EWEN_OPCODE          19   /* Erase/write enable */
#define EEPROM_EWDS_OPCODE          16   /* Erase/write disable */

/*- EEPROM data locations */
#define EEPROM_NODE_ADDRESS_BYTE_0      0
#define EEPROM_COMPATIBILITY_WORD       3
#define EEPROM_PWA_NO                   8
#define EEPROM_ID_WORD			0x0A

#define EEPROM_SUM                      0xbaba

/* MDI Control register bit definitions */
#define MDI_DATA_MASK       BIT_0_15   /* MDI Data port */
#define MDI_REG_ADDR        BIT_16_20   /* which MDI register to read/write */
#define MDI_PHY_ADDR        BIT_21_25   /* which PHY to read/write */
#define MDI_PHY_OPCODE      BIT_26_27   /* which PHY to read/write */
#define MDI_PHY_READY       BIT_28   /* PHY is ready for next MDI cycle */
#define MDI_PHY_INT_ENABLE  BIT_29   /* Assert INT at MDI cycle compltion */

#define MDI_NC3133_CONFIG_REG           0x19
#define MDI_NC3133_100FX_ENABLE         BIT_2
#define MDI_NC3133_INT_ENABLE_REG       0x17
#define MDI_NC3133_INT_ENABLE           BIT_1

/* MDI Control register opcode definitions */
#define MDI_WRITE       1        /* Phy Writ */
#define MDI_READ        2        /* Phy read */

// Zero Locking Algorithm definitions:
#define ZLOCK_ZERO_MASK		0x00F0
#define ZLOCK_MAX_READS		50 
#define ZLOCK_SET_ZERO		0x2010
#define ZLOCK_MAX_SLEEP		300 * HZ 
#define ZLOCK_MAX_ERRORS	300

/* E100 Action Commands */
#define CB_IA_ADDRESS           1
#define CB_CONFIGURE            2
#define CB_MULTICAST            3
#define CB_TRANSMIT             4
#define CB_LOAD_MICROCODE       5
#define CB_IPCB_TRANSMIT        9


/* Command Block (CB) Field Definitions */
/*- CB Command Word */
#define CB_EL_BIT           BIT_15   /* CB EL Bit */
#define CB_S_BIT            BIT_14   /* CB Suspend Bit */
#define CB_I_BIT            BIT_13   /* CB Interrupt Bit */
#define CB_TX_SF_BIT        BIT_3   /* TX CB Flexible Mode */
#define CB_CMD_MASK         BIT_0_2   /* CB 3-bit CMD Mask */
#define CB_CID_DEFAULT      (0x1f << 8)  /* CB 5-bit CID (max value) */

/*- CB Status Word */
#define CB_STATUS_MASK          BIT_12_15   /* CB Status Mask (4-bits) */
#define CB_STATUS_COMPLETE      BIT_15   /* CB Complete Bit */
#define CB_STATUS_OK            BIT_13   /* CB OK Bit */
#define CB_STATUS_UNDERRUN      BIT_12   /* CB A Bit */
#define CB_STATUS_FAIL          BIT_11   /* CB Fail (F) Bit */

/*misc command bits */
#define CB_TX_EOF_BIT           BIT_15   /* TX CB/TBD EOF Bit */

/* Config params */
#define CB_CFIG_BYTE_COUNT          22   /* 22 config bytes */
#define CB_CFIG_D102_BYTE_COUNT    10          


/* Receive Frame Descriptor Fields */

/*- RFD Status Bits */
#define RFD_RECEIVE_COLLISION   BIT_0   /* Collision detected on Receive */
#define RFD_IA_MATCH            BIT_1   /* Indv Address Match Bit */
#define RFD_RX_ERR              BIT_4   /* RX_ERR pin on Phy was set */
#define RFD_FRAME_TOO_SHORT     BIT_7   /* Receive Frame Short */
#define RFD_DMA_OVERRUN         BIT_8   /* Receive DMA Overrun */
#define RFD_NO_RESOURCES        BIT_9   /* No Buffer Space */
#define RFD_ALIGNMENT_ERROR     BIT_10   /* Alignment Error */
#define RFD_CRC_ERROR           BIT_11   /* CRC Error */
#define RFD_STATUS_OK           BIT_13   /* RFD OK Bit */
#define RFD_STATUS_COMPLETE     BIT_15   /* RFD Complete Bit */

/*- RFD Command Bits*/
#define RFD_EL_BIT      BIT_15  /* RFD EL Bit */
#define RFD_S_BIT       BIT_14  /* RFD Suspend Bit */
#define RFD_H_BIT       BIT_4     /* Header RFD Bit */
#define RFD_SF_BIT      BIT_3     /* RFD Flexible Mode */

/*- RFD misc bits*/
#define RFD_EOF_BIT         BIT_15   /* RFD End-Of-Frame Bit */
#define RFD_F_BIT           BIT_14   /* RFD Buffer Fetch Bit */
#define RFD_ACT_COUNT_MASK  BIT_0_13   /* RFD Actual Count Mask */


/* Receive Buffer Descriptor Fields*/
#define RBD_EOF_BIT             BIT_15   /* RBD End-Of-Frame Bit */
#define RBD_F_BIT               BIT_14   /* RBD Buffer Fetch Bit */
#define RBD_ACT_COUNT_MASK      BIT_0_13   /* RBD Actual Count Mask */

#define SIZE_FIELD_MASK     BIT_0_13   /* Size of the associated buffer */
#define RBD_EL_BIT          BIT_15   /* RBD EL Bit */


/* Self Test Results*/
#define CB_SELFTEST_FAIL_BIT        BIT_12
#define CB_SELFTEST_DIAG_BIT        BIT_5
#define CB_SELFTEST_REGISTER_BIT    BIT_3
#define CB_SELFTEST_ROM_BIT         BIT_2

#define CB_SELFTEST_ERROR_MASK ( \
                CB_SELFTEST_FAIL_BIT | CB_SELFTEST_DIAG_BIT | \
                CB_SELFTEST_REGISTER_BIT | CB_SELFTEST_ROM_BIT)

/* adapter vendor & device ids */
#define PCI_OHIO_BOARD   0x10f0 /* subdevice ID, Ohio dual port nic */

/* Values for PCI_REV_ID_REGISTER values */
#define D101A4_REV_ID      4     /* 82558 A4 stepping */
#define D101B0_REV_ID      5     /* 82558 B0 stepping */
#define D101MA_REV_ID      8     /* 82559 A0 stepping */
#define D101S_REV_ID      9        /* 82559S A-step */
#define D102_REV_ID      12
#define D102C_REV_ID     13        /* 82550 step C */
#define D102E_REV_ID     15

/* PHY 100 MDI Register/Bit Definitions*/

/* MDI register set*/
#define MDI_CONTROL_REG             0x00   /* MDI control register */
#define MDI_STATUS_REG              0x01   /* MDI Status regiser */
#define PHY_ID_REG_1                0x02   /* Phy indentification reg (word 1) */
#define PHY_ID_REG_2                0x03   /* Phy indentification reg (word 2) */
#define AUTO_NEG_ADVERTISE_REG      0x04   /* Auto-negotiation advertisement */
#define AUTO_NEG_LINK_PARTNER_REG   0x05   /* Auto-negotiation link partner 
                                            * ability */
#define AUTO_NEG_EXPANSION_REG      0x06   /* Auto-negotiation expansion */
#define AUTO_NEG_NEXT_PAGE_REG      0x07   /* Auto-negotiation next page xmit */
#define EXTENDED_REG_0              0x10   /* Extended reg 0 (Phy 100 modes) */
#define EXTENDED_REG_1              0x14   /* Extended reg 1 (Phy 100 error 
                                            * indications) */
#define NSC_CONG_CONTROL_REG        0x17   /* National (TX) congestion control */
#define NSC_SPEED_IND_REG           0x19   /* National (TX) speed indication */

/* ############Start of 82555 specific defines################## */

/* Intel 82555 specific registers */
#define PHY_82555_CSR            		0x10   /* 82555 CSR */
#define PHY_82555_SPECIAL_CONTROL    	0x11   /* 82555 special control register */

#define PHY_82555_RCV_ERR				0x15   /* 82555 100BaseTx Receive Error 
												* Frame Counter */
#define PHY_82555_SYMBOL_ERR			0x16   /* 82555 RCV Symbol Error Counter */
#define PHY_82555_PREM_EOF_ERR			0x17   /* 82555 100BaseTx RCV Premature End
												* of Frame Error Counter */
#define PHY_82555_EOF_COUNTER    		0x18   /* 82555 end of frame error counter */
#define PHY_82555_MDI_EQUALIZER_CSR     0x1a   /* 82555 specific equalizer reg. */
#define PHY_82555_LED_SWITCH_CONTROL    	0x1b   /* 82555 led switch control register */


/* 82555 CSR bits */
#define PHY_82555_SPEED_BIT       BIT_1
#define PHY_82555_POLARITY_BIT    BIT_8

/* 82555 equalizer reg. opcodes */
#define ENABLE_ZERO_FORCING     0x2010   /* write to ASD conf. reg. 0 */
#define DISABLE_ZERO_FORCING    0x2000   /* write to ASD conf. reg. 0 */

/* 82555 special control reg. opcodes */
#define DISABLE_AUTO_POLARITY       0x0010
#define EXTENDED_SQUELCH_BIT         BIT_2

/* 82555 led switch control reg. opcodes */
#define PHY_82555_LED_NORMAL_CONTROL    0                       // control back to the 8255X
#define PHY_82555_LED_DRIVER_CONTROL    BIT_2                   // the driver is in control
#define PHY_82555_LED_OFF               BIT_2                   // activity LED is off
#define PHY_82555_LED_ON_559           (BIT_0 | BIT_2)          // activity LED is on for 559 and later
#define PHY_82555_LED_ON_PRE_559       (BIT_0 | BIT_1 | BIT_2)  // activity LED is on for 558 and before


// Describe the state of the phy led.
// needed for the function : 'e100_blink_timer'
enum led_state_e {
	LED_OFF,
	LED_ON,
};


/* ############End of 82555 specific defines##################### */

/* MDI Control register bit definitions*/
#define MDI_CR_COLL_TEST_ENABLE     BIT_7   /* Collision test enable */
#define MDI_CR_FULL_HALF            BIT_8   /* FDX =1, half duplex =0 */
#define MDI_CR_RESTART_AUTO_NEG     BIT_9   /* Restart auto negotiation */
#define MDI_CR_ISOLATE              BIT_10   /* Isolate PHY from MII */
#define MDI_CR_POWER_DOWN           BIT_11   /* Power down */
#define MDI_CR_AUTO_SELECT          BIT_12   /* Auto speed select enable */
#define MDI_CR_10_100               BIT_13   /* 0 = 10Mbs, 1 = 100Mbs */
#define MDI_CR_LOOPBACK             BIT_14   /* 0 = normal, 1 = loopback */
#define MDI_CR_RESET                BIT_15   /* 0 = normal, 1 = PHY reset */

/* MDI Status register bit definitions*/
#define MDI_SR_EXT_REG_CAPABLE      BIT_0   /* Extended register capabilities */
#define MDI_SR_JABBER_DETECT        BIT_1   /* Jabber detected */
#define MDI_SR_LINK_STATUS          BIT_2   /* Link Status -- 1 = link */
#define MDI_SR_AUTO_SELECT_CAPABLE  BIT_3   /* Auto speed select capable */
#define MDI_SR_REMOTE_FAULT_DETECT  BIT_4   /* Remote fault detect */
#define MDI_SR_AUTO_NEG_COMPLETE    BIT_5   /* Auto negotiation complete */
#define MDI_SR_10T_HALF_DPX         BIT_11   /* 10BaseT Half Duplex capable */
#define MDI_SR_10T_FULL_DPX         BIT_12   /* 10BaseT full duplex capable */
#define MDI_SR_TX_HALF_DPX          BIT_13   /* TX Half Duplex capable */
#define MDI_SR_TX_FULL_DPX          BIT_14   /* TX full duplex capable */
#define MDI_SR_T4_CAPABLE           BIT_15   /* T4 capable */

/* Auto-Negotiation advertisement register bit definitions*/
#define NWAY_AD_10T_HALF_DPX    BIT_5   /* 10BaseT Half Duplex capable */
#define NWAY_AD_10T_FULL_DPX    BIT_6   /* 10BaseT full duplex capable */
#define NWAY_AD_TX_HALF_DPX     BIT_7   /* TX Half Duplex capable */
#define NWAY_AD_TX_FULL_DPX     BIT_8   /* TX full duplex capable */
#define NWAY_AD_T4_CAPABLE      BIT_9   /* T4 capable */

/* Auto-Negotiation link partner ability register bit definitions*/
#define NWAY_LP_ABILITY         BIT_5_12   /* technologies supported */

/* Auto-Negotiation expansion register bit definitions*/
#define NWAY_EX_LP_NWAY         BIT_0   /* link partner is NWAY */

/* PHY 100 Extended Register 0 bit definitions*/
#define PHY_100_ER0_FDX_INDIC       BIT_0   /* 1 = FDX, 0 = half duplex */
#define PHY_100_ER0_SPEED_INDIC     BIT_1   /* 1 = 100Mbps, 0= 10Mbps */

/* National Semiconductor TX phy congestion control register bit definitions*/
#define NSC_TX_CONG_TXREADY         BIT_10   /* Makes TxReady an input */
#define NSC_TX_CONG_ENABLE          BIT_8   /* Enables congestion control */

/* National Semiconductor TX phy speed indication register bit definitions*/
#define NSC_TX_SPD_INDC_SPEED       BIT_6   /* 0 = 100Mbps, 1=10Mbps */

#define RFD_PARSE_BIT			BIT_3
#define RFD_TCP_PACKET			0x00
#define RFD_UDP_PACKET			0x01
#define TCPUDP_CHECKSUM_BIT_VALID	BIT_4
#define TCPUDP_CHECKSUM_VALID		BIT_5
#define CHECKSUM_PROTOCOL_MASK		0x03

#define VLAN_SIZE   4
#define CHKSUM_SIZE 2
#define RFD_DATA_SIZE (ETH_FRAME_LEN + CHKSUM_SIZE + VLAN_SIZE)

/* Bits for bdp->flags */
#define DF_CSUM_OFFLOAD    0x0002
#define DF_OPENED          0x0004
#define DF_UCODE_LOADED    0x0008
#define USE_IPCB           0x0020    /* set if using ipcb for transmits */
#define IS_BACHELOR        0x0040   /* set if 82558 or newer board */
#define IS_ICH             0x0800
#define DF_PHY_82555       0x2000
#define DF_SPEED_FORCED    0x4000   /* set if speed is forced */
#define DF_LINK_UP         0x8000   /* set if link is up */

typedef struct net_device_stats net_dev_stats_t;

/* needed macros */
/* These macros use the bdp pointer. If you use them it better be defined */
#define PREV_TCB_USED(X)  ((X)->tail? (X)->tail-1:TxDescriptors[bdp->bd_number]-1)
#define NEXT_TCB_TOUSE(X) ((((X)+1) >= TxDescriptors[bdp->bd_number] )? 0:(X)+1)
#define TCB_TO_USE(X)     ((X)->tail)
#define TCBS_AVAIL(X)     (NEXT_TCB_TOUSE( NEXT_TCB_TOUSE((X)->tail)) != (X)->head)

/* leave a gap of 2 TCB's in e100_tx_srv */
#define IS_IT_GAP(X) (NEXT_TCB_TOUSE(NEXT_TCB_TOUSE((X)->head))==(X)->tail)

#define DELAY_LOOP_USEC		4 	

#define E100_WAIT_FOR_CONDITION(timeout,expr)	\
{						\
  while(!(expr) && ((timeout) > 0) ){		\
    udelay( DELAY_LOOP_USEC);			\
    (timeout) -= DELAY_LOOP_USEC;		\
  }						\
}

#define E100_MIN(X,Y)         ( (X) < (Y)? (X):(Y) )
#define E100_MAX(X,Y)         ( (X) > (Y)? (X):(Y) )

#define RFD_POINTER(skb,bdp)      ((rfd_t *) (((unsigned char *)((skb)->data))-((bdp)->rfd_size)))
#define SKB_RFD_STATUS(skb,bdp)   ((RFD_POINTER((skb),(bdp)))->rfd_header.cb_status)
#define GET_SKB_DMA_ADDR(skb)		( *(dma_addr_t *)( (skb)->cb) )
#define SET_SKB_DMA_ADDR(skb,dma_addr)	( *(dma_addr_t *)( (skb)->cb) = (dma_addr) ) 

/* ====================================================================== */
/*                              82557                                     */
/* ====================================================================== */


/* Changed for 82558 enhancement */
typedef struct _d101_scb_ext_t
{
    volatile u32 scb_rx_dma_cnt;   /* Rx DMA byte count */
    volatile u8 scb_early_rx_int;   /* Early Rx DMA byte count */
    volatile u8 scb_fc_thld;   /* Flow Control threshold */
    volatile u8 scb_fc_xon_xoff;   /* Flow Control XON/XOFF values */
    volatile u8 scb_pmdr;     /* Power Mgmt. Driver Reg */
} d101_scb_ext __attribute__ ((__packed__));

/* Changed for 82559 enhancement */
typedef struct _d101m_scb_ext_t
{
    volatile u32 scb_rx_dma_cnt;   /* Rx DMA byte count */
    volatile u8 scb_early_rx_int;   /* Early Rx DMA byte count */
    volatile u8 scb_fc_thld;   /* Flow Control threshold */
    volatile u8 scb_fc_xon_xoff;   /* Flow Control XON/XOFF values */
    volatile u8 scb_pmdr;     /* Power Mgmt. Driver Reg */
    volatile u8 scb_gen_ctrl;   /* General Control */
    volatile u8 scb_gen_stat;   /* General Status */
    volatile u16 scb_reserved;   /* Reserved */
    volatile u32 scb_function_event;   /* Cardbus Function Event */
    volatile u32 scb_function_event_mask;   /* Cardbus Function Mask */
    volatile u32 scb_function_present_state;   /* Cardbus Function state */
    volatile u32 scb_force_event;   /* Cardbus Force Event */
} d101m_scb_ext __attribute__ ((__packed__));

/* Changed for 82550 enhancement */
typedef struct _d102_scb_ext_t
{
    volatile u32 scb_rx_dma_cnt;   /* Rx DMA byte count */
    volatile u8 scb_early_rx_int;   /* Early Rx DMA byte count */
    volatile u8 scb_fc_thld;   /* Flow Control threshold */
    volatile u8 scb_fc_xon_xoff;   /* Flow Control XON/XOFF values */
    volatile u8 scb_pmdr;     /* Power Mgmt. Driver Reg */
    volatile u8 scb_gen_ctrl;   /* General Control */
    volatile u8 scb_gen_stat;   /* General Status */
    volatile u8 scb_gen_ctrl2;
    volatile u8 scb_reserved;   /* Reserved */
    volatile u32 scb_scheduling_reg;
    volatile u32 scb_reserved2;
    volatile u32 scb_function_event;   /* Cardbus Function Event */
    volatile u32 scb_function_event_mask;   /* Cardbus Function Mask */
    volatile u32 scb_function_present_state;   /* Cardbus Function state */
    volatile u32 scb_force_event;   /* Cardbus Force Event */
} d102_scb_ext __attribute__ ((__packed__));


/*
 * 82557 status control block. this will be memory mapped & will hang of the
 * the bdp, which hangs of the bdp. This is the brain of it.
 */
typedef struct _scb_t
{               
    volatile u16 scb_status;  /* SCB Status register */
    volatile u8 scb_cmd_low;   /* SCB Command register (low byte) */
    volatile u8 scb_cmd_hi; /* SCB Command register (high byte) */
    volatile u32 scb_gen_ptr;   /* SCB General pointer */
    volatile u32 scb_port;     /* PORT register */
    volatile u16 scb_flsh_cntrl;   /* Flash Control register */
    volatile u16 scb_eprm_cntrl;   /* EEPROM control register */
    volatile u32 scb_mdi_cntrl;   /* MDI Control Register */
    /* Changed for 82558 enhancement */
    union {
        volatile u32 scb_rx_dma_cnt;   /* Rx DMA byte count */
        volatile d101_scb_ext d101_scb;   /* 82558/9 specific fields */
        volatile d101m_scb_ext d101m_scb;   /* 82559 specific fields */
        volatile d102_scb_ext d102_scb;
    } scb_ext;
} scb_t, *pscb_t __attribute__ ((__packed__));

/* Self test
 * This is used to dump results of the self test 
 */
typedef struct _self_test_t
{
    volatile u32 st_sign;              /* Self Test Signature */
    volatile u32 st_result;           /* Self Test Results */
} self_test_t, *pself_test_t __attribute__ ((__packed__));


/* 
 *  Statistical Counters 
 */
/* 82557 counters */
typedef struct _basic_cntr_t
{
    volatile u32 xmt_gd_frames;        /* Good frames transmitted */
    volatile u32 xmt_max_coll;        /* Fatal frames -- had max collisions */
    volatile u32 xmt_late_coll;        /* Fatal frames -- had a late coll. */
    volatile u32 xmt_uruns;           /* Xmit underruns (fatal or re-transmit) */
    volatile u32 xmt_lost_crs;        /* Frames transmitted without CRS */
    volatile u32 xmt_deferred;        /* Deferred transmits */
    volatile u32 xmt_sngl_coll;        /* Transmits that had 1 and only 1 coll. */
    volatile u32 xmt_mlt_coll;        /* Transmits that had multiple coll. */
    volatile u32 xmt_ttl_coll;        /* Transmits that had 1+ collisions. */
    volatile u32 rcv_gd_frames;        /* Good frames received */
    volatile u32 rcv_crc_errs;        /* Aligned frames that had a CRC error */
    volatile u32 rcv_algn_errs;        /* Receives that had alignment errors */
    volatile u32 rcv_rsrc_err;        /* Good frame dropped cuz no resources */
    volatile u32 rcv_oruns;           /* Overrun errors - bus was busy */
    volatile u32 rcv_err_coll;        /* Received frms. that encountered coll. */
    volatile u32 rcv_shrt_frames;     /* Received frames that were to short */
} basic_cntr_t, *pbasic_cntr_t;


/* 82558 extended statistic counters */
typedef struct _ext_cntr_t
{
    volatile u32 xmt_fc_frames;
    volatile u32 rcv_fc_frames;
    volatile u32 rcv_fc_unsupported;           
} ext_cntr_t, *pext_cntr_t;


/* 82559 TCO statistic counters */
typedef struct _tco_cntr_t
{
    volatile u16 xmt_tco_frames;
    volatile u16 rcv_tco_frames;
} tco_cntr_t, *ptco_cntr_t;

/* Structures to access thet physical dump area */
/* Use one of these types, according to the statisitcal counters mode,
   to cast the pointer to the physical dump area and access the cmd_complete
   DWORD. */

/* 557-mode : only basic counters + cmd_complete */
typedef struct _err_cntr_557_t 
{
	basic_cntr_t	basic_stats;
	volatile u32		cmd_complete;
} err_cntr_557_t, *perr_cntr_557_t;

/* 558-mode : basic + extended counters + cmd_complete */
typedef struct _err_cntr_558_t 
{
	basic_cntr_t	basic_stats;	
	ext_cntr_t		extended_stats;
	volatile u32		cmd_complete;
} err_cntr_558_t, *perr_cntr_558_t;

/* 559-mode : basic + extended + TCO counters + cmd_complete */
typedef struct _err_cntr_559_t 
{
	basic_cntr_t	basic_stats;
	ext_cntr_t		extended_stats;
	tco_cntr_t		tco_stats;
	volatile u32		cmd_complete;
} err_cntr_559_t, *perr_cntr_559_t;

/* This typedef defines the struct needed to hold the largest number of counters */
typedef err_cntr_559_t max_counters_t, *pmax_counters_t;


/* Different statistical-counters mode the controller may be in */
typedef enum _stat_mode_t {
	E100_BASIC_STATS = 0,	/* 82557 stats : 16 counters / 16 dw */
	E100_EXTENDED_STATS,	/* 82558 stats : 19 counters / 19 dw */  
	E100_TCO_STATS			/* 82559 stats : 21 counters / 20 dw */
} stat_mode_t, *pstat_mode_t;

/* dump statistical counters complete codes */
#define DUMP_STAT_COMPLETED	0xA005
#define DUMP_RST_STAT_COMPLETED	0xA007


/* Command Block (CB) Generic Header Structure*/
typedef struct _cb_header_t
{
    volatile u16 cb_status;              /* Command Block Status */
    volatile u16 cb_cmd;                 /* Command Block Command */
    volatile u32 cb_lnk_ptr;           /* Link To Next CB */
} cb_header_t, *pcb_header_t __attribute__ ((__packed__));

//* Individual Address Command Block (IA_CB)*/
typedef struct _ia_cb_t
{
    cb_header_t ia_cb_hdr;
    u8 ia_addr[ETH_ALEN];
} ia_cb_t, *pia_cb_t __attribute__ ((__packed__));


/* Configure Command Block (CONFIG_CB)*/
typedef struct _config_cb_t
{
    cb_header_t cfg_cbhdr;
    u8 cfg_byte[CB_CFIG_BYTE_COUNT + CB_CFIG_D102_BYTE_COUNT];
} config_cb_t, *pconfig_cb_t __attribute__ ((__packed__));


/* MultiCast Command Block (MULTICAST_CB)*/
typedef struct _multicast_cb_t
{
    cb_header_t mc_cbhdr;
    volatile u16 mc_count;              /* Number of multicast addresses */
    u8 mc_addr[(ETH_ALEN * MAX_MULTICAST_ADDRS)];
} mltcst_cb_t, *pmltcst_cb_t __attribute__ ((__packed__));


#define UCODE_MAX_DWORDS	134
/* Load Microcode Command Block (LOAD_UCODE_CB)*/
typedef struct _load_ucode_cb_t
{
    cb_header_t load_ucode_cbhdr;
    u32 ucode_dword[UCODE_MAX_DWORDS];
} load_ucode_cb_t, *pload_ucode_cb_t __attribute__ ((__packed__));

/* NON_TRANSMIT_CB -- Generic Non-Transmit Command Block , doesnot include
 * MultiCast as the addresses need to be saved
 */
typedef struct _nxmit_cb_t
{
    union {
        config_cb_t config;
        ia_cb_t setup;
        load_ucode_cb_t load_ucode;
        mltcst_cb_t multicast;
    } ntcb;
} nxmit_cb_t, *pnxmit_cb_t __attribute__ ((__packed__));


/* 82558 specific Extended TCB fields */
typedef struct _tcb_ext_t
{
    volatile u32 tbd0_buf_addr;        /* Physical Transmit Buffer Address */
    volatile u32 tbd0_buf_cnt;        /* Actual Count Of Bytes */
    volatile u32 tbd1_buf_addr;        /* Physical Transmit Buffer Address */
    volatile u32 tbd1_buf_cnt;        /* Actual Count Of Bytes */
} tcb_ext_t __attribute__ ((__packed__));


/* some defines for the ipcb */
#define IPCB_HARDWAREPARSING_ENABLE 0x01
#define IPCB_IP_ACTIVATION_DEFAULT      IPCB_HARDWAREPARSING_ENABLE

/* d102 specific fields */
typedef struct _tcb_ipcb_t
{
    volatile u16 schedule_low;
    volatile u8 ip_schedule;
    volatile u8 ip_activation_high;    
    volatile u16 vlan;
    volatile u8 ip_header_offset;
    volatile u8 tcp_header_offset;
    union {
        volatile u32 sec_rec_phys_addr;
        volatile u32 tbd_zero_address;
    } tbd_sec_addr;
    union {
        volatile u16 sec_rec_size;
        volatile u16 tbd_zero_size;
    } tbd_sec_size;
    volatile u16 total_tcp_payload;
} tcb_ipcb_t __attribute__ ((__packed__));

/* Transmit Command Block (TCB)*/
struct _tcb_t
{
  cb_header_t tcb_hdr;
  volatile u32 tcb_tbd_ptr;           /* TBD address */
  volatile u16 tcb_cnt;              /* Data Bytes In TCB past header */
  volatile u8 tcb_thrshld;           /* TX Threshold for FIFO Extender */
  volatile u8 tcb_tbd_num;

  union {
    tcb_ipcb_t ipcb;                  /* d102 ipcb fields */
    tcb_ext_t tcb_ext;        /* 82558 extended TCB fields */
  } tcbu;

  /* From here onward we can dump anything we want as long as the
   * size of the total structure is a multiple of a paragraph
   * boundary ( i.e. -16 bit aligned ).
   */
  struct sk_buff *tcb_skb;           /* the associated socket buffer */
  dma_addr_t dma_data_addr;
  dma_addr_t tcb_paddr;           /* phys addr of the TCB */
} __attribute__ ((__packed__));


#ifndef _TCB_T_
#define _TCB_T_
typedef struct _tcb_t tcb_t, *ptcb_t;
#endif


/* Transmit Buffer Descriptor (TBD)*/
typedef struct _tbd_t
{
    volatile u32 tbd_buf_addr;        /* Physical Transmit Buffer Address */
    volatile u32 tbd_buf_cnt;           /* Actual Count Of Bytes */
} tbd_t, *ptbd_t __attribute__ ((__packed__));


/* Receive Frame Descriptor (RFD) - will be using the simple model*/
struct _rfd_t
{
  /* 8255x */
  cb_header_t rfd_header;
  volatile u32    rfd_rbd_ptr;           /* Receive Buffer Descriptor Addr */
  volatile u16    rfd_act_cnt;           /* Number Of Bytes Received */
  volatile u16    rfd_sz;                /* Number Of Bytes In RFD */
  /* D102 aka Gamla */
  volatile u16    vlanid;
  volatile u8     rcvparserstatus;
  volatile u8     reserved;
  volatile u16    securitystatus;
  volatile u8     checksumstatus;
  volatile u8     zerocopystatus;
  volatile u8     pad[8];  /* data should be 16 byte aligned */
  volatile u8     data[RFD_DATA_SIZE];

} __attribute__ ((__packed__));

#ifndef _RFD_T_
#define _RFD_T_
typedef struct _rfd_t rfd_t, *prfd_t;
#endif


/* Receive Buffer Descriptor (RBD)*/
typedef struct _rbd_t
{
    volatile u16 rbd_act_cnt;           /* Number Of Bytes Received */
    volatile u16 rbd_filler;
    volatile u32 rbd_lnk_addr;        /* Link To Next RBD */
    volatile u32 rbd_rcb_addr;        /* Receive Buffer Address */
    volatile u16 rbd_sz;                 /* Receive Buffer Size */
    volatile u16 rbd_filler1;
} rbd_t, *prbd_t __attribute__ ((__packed__));

// this is the size of the eeprom buffer
// if there is ever an eeprom larger than 256 words,
// this value needs to change

typedef struct _lock_t
{
	atomic_t   counter;/* the number of readers that hold the lock */
	volatile int flag; /* when set - the lock was grabed by writer */
} lock_t;

#ifdef IDIAG_PRO_SUPPORT
typedef struct {	
  dma_addr_t     dma_handle;
   tcb_t	*tcb;
   rfd_t	*rfd;
   
} idiag_e100_diag_loopback_data_t;
#endif /* IDIAG_PRO_SUPPORT */

/*
 * This structure is used to maintain a FIFO access to a resource that is 
 * maintained as a circular queue. The resource to be maintained is pointed
 * to by the "data" field in the structure below. In this driver the TCBs', 
 * TBDs' & RFDs' are maintained  as a circular queue & are managed thru this
 * structure.
 */
typedef struct _buf_pool_t
{
    unsigned int head;                 /* index to first used resource */
    unsigned int tail;                 /* index to last used resource */
    void *data;                    /* points to resource pool */
} buf_pool_t, *pbuf_pool_t;

enum next_cu_cmd_e	{ RESUME_NO_WAIT = 0, RESUME_WAIT, START_WAIT  };
enum zero_lock_state_e	{ ZLOCK_INITIAL, ZLOCK_READING, ZLOCK_SLEEPING };
enum tx_queue_stop_type { LONG_STOP = 0, SHORT_STOP } ;
struct bdconfig
{
#ifdef IANS
    void *iANSreserved;           /* reserved for ANS */
    iANSsupport_t *iANSdata;
    unsigned long ans_link_status;
    unsigned long ans_line_speed;
    unsigned long ans_dplx_mode;
#endif
    struct bdconfig *bd_next;     /* pointer to next bd in chain */
    struct bdconfig *bd_prev;     /* pointer to prev bd in chain */
    u32 io_start;                 /* start of I/O base address */
    int bd_number;                /* board number in multi-board setup */
    u32 flags;                    /* board management flags */
    struct timer_list timer_id;   /* watchdog timer ID */
    u32 tx_per_underrun;
    unsigned int tx_count;
    u8 tx_thld;                   /* stores transmit threshold */
    u16 EEpromSize;
    u32 pwa_no;                   /* PWA: xxxxxx-0xx */
    u8 perm_node_address[ETH_ALEN];
    struct sk_buff *rfd_head;
    struct sk_buff *rfd_tail;
    u16 rfd_size;
    int skb_req;

    pself_test_t pselftest;            /* pointer to self test area */
    dma_addr_t selftest_paddr;         /* phys addr of selftest */
    pmax_counters_t pstats_counters;   /* pointer to stats table */
    dma_addr_t stat_cnt_paddr;         /* phys addr of stat counter area */
    pnxmit_cb_t pntcb;                 /* pointer to non xmit tcb */
    dma_addr_t nontx_paddr;            /* phys addr of  non-tx tcb */

    stat_mode_t stat_mode;
    pscb_t scbp;                       /* memory mapped ptr to 82557 scb */

    tcb_t *last_tcbp;                  /* pointer to last tcb sent */
    buf_pool_t tcb_pool;
    dma_addr_t tcb_paddr;              /* phys addr of start of TCBs */
    buf_pool_t tbd_pool;
    dma_addr_t tbd_paddr;              /* phys addr of start of TBDs */

    u16 cur_line_speed;
    u16 cur_dplx_mode;

    /* these are linux only */
    struct net_device *device;
    struct pci_dev *ppci_dev;
    struct driver_stats drv_stats;

    /* PCI info */
    u16 sub_ven_id;
    u16 sub_dev_id;
    u8  rev_id;
    
    unsigned int phy_addr;              /* address of PHY component */
    unsigned int PhyState;
    unsigned int PhyDelay;
    unsigned int PhyId;

    /* Lock defintions for the driver */
    spinlock_t bd_lock;           /* board lock */
    spinlock_t bd_tx_lock;        /* Transmit lock  */
    spinlock_t config_lock;        /* config block lock */
    spinlock_t mdi_access_lock;		

    int prev_rx_mode;
    enum next_cu_cmd_e next_cu_cmd;

    enum zero_lock_state_e ZeroLockState;
    u8 ZeroLockReadData[16]; 
    u16 ZeroLockReadCounter; 
    ulong ZeroLockSleepCounter;
    
    u8 config[CB_CFIG_BYTE_COUNT + CB_CFIG_D102_BYTE_COUNT];
    
    u8 ifs_state;
    u8 ifs_value;

#ifdef CONFIG_PROC_FS
    struct proc_dir_entry *proc_parent;
#endif /*CONFIG_PROC_FS*/

    lock_t isolate_lock;
#ifdef IDIAG_PRO_SUPPORT
    idiag_e100_diag_loopback_data_t loopback;
#endif /* IDIAG_PRO_SUPPORT */

#ifdef E100_ETHTOOL_IOCTL
    u32 speed_duplex_caps;
#endif
};

#ifndef _BD_CONFIG_T_
#define _BD_CONFIG_T_
typedef struct bdconfig bd_config_t;
#endif

/* ====================================================================== */
/*                              vendor_info                               */
/* ====================================================================== */

/* 
 * vendor_info_array
 *
 * This array contains the list of Subsystem IDs on which the driver
 * should load.
 *
 * The format of each entry of the array is as follows:
 * { VENDOR_ID, DEVICE_ID, SUBSYSTEM_VENDOR, SUBSYSTEM_DEV, REVISION, BRANDING_STRING }
 *
 * If there is a CATCHALL in the SUBSYSTEM_DEV field, the driver will
 * load on all subsystem device IDs of that vendor.
 * If there is a CATCHALL in the SUBSYSTEM_VENDOR field, the driver will
 * load on all cards, irrespective of the vendor.
 *
 * The last entry of the array must be:
 * { 0, 0, 0, 0, 0, null }
 */

#define CATCHALL 0xffff

typedef struct _e100_vendor_info_t
{
    u16 ven_id;
    u16 dev_id;
    u16 sub_ven;
    u16 sub_dev;
    u16 rev_id;
    char *idstr;                 // String to be printed for these IDs
} e100_vendor_info_t;

extern e100_vendor_info_t e100_vendor_info_array[];

/********* function prototypes *************/
void e100_isolate_driver (bd_config_t *bdp);
void e100_deisolate_driver (bd_config_t *bdp, unsigned char recover);
void e100_sw_reset (bd_config_t *bdp, u32 reset_cmd);
void e100_cu_start (bd_config_t *bdp, tcb_t *tcbp);
void e100_tx_notify_start(bd_config_t *bdp, enum tx_queue_stop_type);
unsigned char e100_exec_non_cu_cmd (bd_config_t *bdp);
unsigned char e100_selftest (bd_config_t *bdp, u32 *st_timeout, u32 *st_result);
unsigned char e100_hw_reset_recover (bd_config_t *bdp, u32 reset_cmd);
unsigned char e100_GetPhyLinkState (bd_config_t *bdp);
unsigned char e100_wait_scb (bd_config_t *bdp);
unsigned char e100_wait_exec_cmd (bd_config_t *bdp, u8 scb_cmd_low);

// - write - try-read-lock functions
// these locks are interruptable	

static __inline__ unsigned char try_read_lock(lock_t *lock)
{
  if ( !test_bit(0,&(lock->flag) ) ){
    
    atomic_inc( &(lock->counter) );
    
    if ( !test_bit(0,&(lock->flag) ) ) {
    
      return B_TRUE;
    }else{
      atomic_dec( &(lock->counter) );
    }
  }
  return B_FALSE;
}


static __inline__ void try_read_unlock(lock_t *lock)
{
    atomic_dec( &(lock->counter) );
}

static __inline__ void spin_write_lock(lock_t *lock)
{
    while ( test_and_set_bit(0,&(lock->flag) ) );
    
    while ( atomic_read(&(lock->counter)) );
}

static __inline__ void spin_write_unlock(lock_t *lock)
{
    clear_bit(0,&(lock->flag));
}

static __inline__ void lock_init(lock_t *lock)
{
    clear_bit(0,&(lock->flag)); 
    atomic_set(&(lock->counter),0);
    
}

/* 
 * Procedure:   e100_exec_cmd
 *
 * Description: This general routine will issue a command to the e100.
 *
 * Arguments:
 *      bdp -          Ptr to this card's e100_bdconfig structure
 *      scb_cmd_low - The command that is to be issued.
 * 
 */

#define e100_exec_cmd(bdp, cmd_low) writeb( (cmd_low),\
                       &((bdp)->scbp->scb_cmd_low))


#endif

