/**********************************************************************
This software program is available to you under a choice of one of two 
licenses. You may choose to be licensed under either the GNU General Public 
License (GPL) Version 2, June 1991, available at 
http://www.fsf.org/copyleft/gpl.html, or the Intel BSD + Patent License, the 
text of which follows:

Recipient has requested a license and Intel Corporation ("Intel") is willing
to grant a license for the software entitled Linux Base Driver for the 
Intel(R) PRO/100 Family of Adapters (e100) (the "Software") being provided 
by Intel Corporation. The following definitions apply to this license:

"Licensed Patents" means patent claims licensable by Intel Corporation which 
are necessarily infringed by the use of sale of the Software alone or when 
combined with the operating system referred to below.

"Recipient" means the party to whom Intel delivers this Software.

"Licensee" means Recipient and those third parties that receive a license to 
any operating system available under the GNU Public License version 2.0 or 
later.

Copyright (c) 1999 - 2002 Intel Corporation.
All rights reserved.

The license is provided to Recipient and Recipient's Licensees under the 
following terms.

Redistribution and use in source and binary forms of the Software, with or 
without modification, are permitted provided that the following conditions 
are met:

Redistributions of source code of the Software may retain the above 
copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form of the Software may reproduce the above 
copyright notice, this list of conditions and the following disclaimer in 
the documentation and/or materials provided with the distribution.

Neither the name of Intel Corporation nor the names of its contributors 
shall be used to endorse or promote products derived from this Software 
without specific prior written permission.

Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
royalty-free patent license under Licensed Patents to make, use, sell, offer 
to sell, import and otherwise transfer the Software, if any, in source code 
and object code form. This license shall include changes to the Software 
that are error corrections or other minor changes to the Software that do 
not add functionality or features when the Software is incorporated in any 
version of an operating system that has been distributed under the GNU 
General Public License 2.0 or later. This patent license shall apply to the 
combination of the Software and any operating system licensed under the GNU 
Public License version 2.0 or later if, at the time Intel provides the 
Software to Recipient, such addition of the Software to the then publicly 
available versions of such operating systems available under the GNU Public 
License version 2.0 or later (whether in gold, beta or alpha form) causes 
such combination to be covered by the Licensed Patents. The patent license 
shall not apply to any other combinations which include the Software. NO 
hardware per se is licensed hereunder.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/

/* Macros to make drivers compatible with 2.2, 2.4 Linux kernels
 *
 * In order to make a single network driver work with all 2.2, 2.4 kernels
 * these compatibility macros can be used.
 * They are backwards compatible implementations of the latest APIs.
 * The idea is that these macros will let you use the newest driver with old
 * kernels, but can be removed when working with the latest and greatest.
 */

#ifndef __E100_KCOMPAT_H__
#define __E100_KCOMPAT_H__

#include <linux/version.h>

/******************************************************************
 *#################################################################
 *#
 *# General definitions, not related to a specific kernel version.
 *#
 *#################################################################
 ******************************************************************/
#ifndef __init
#define __init
#endif

#ifndef __exit
#define __exit
#endif

#ifndef __devexit
#define __devexit
#endif

#ifndef __devinitdata
#define __devinitdata
#endif

#ifndef MODULE_LICENSE
#define MODULE_LICENSE(license)
#endif

#ifndef MOD_INC_USE_COUNT
#define MOD_INC_USE_COUNT do {} while (0)
#endif

#ifndef MOD_DEC_USE_COUNT
#define MOD_DEC_USE_COUNT do {} while (0)
#endif

/******************************************************************
 *#################################################################
 *#
 *# Kernels before 2.2.18
 *#
 *#################################################################
 ******************************************************************/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)

typedef unsigned long dma_addr_t;
typedef struct wait_queue *wait_queue_head_t;
#define init_waitqueue_head(x)                  *(x)=NULL
#define set_current_state(status)		{ current->state = (status); mb(); }

#ifdef MODULE

#define module_init(fn) int  init_module   (void) { return fn(); }
#define module_exit(fn) void cleanup_module(void) { return fn(); }

#else /* MODULE */

#define module_init(fn) int  e100_probe    (void) { return fn(); }
#define module_exit(fn)  /* NOTHING */

#endif /* MODULE */

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18) */

/******************************************************************
 *#################################################################
 *#
 *# Kernels before 2.3.0
 *#
 *#################################################################
 ******************************************************************/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)

#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#include <linux/types.h>
#include <linux/pci.h>
#include <linux/slab.h>
#include <asm/io.h>

#define pci_resource_start(dev, bar)                            \
    (((dev)->base_address[(bar)] & PCI_BASE_ADDRESS_SPACE_IO) ? \
    ((dev)->base_address[(bar)] & PCI_BASE_ADDRESS_IO_MASK) :   \
    ((dev)->base_address[(bar)] & PCI_BASE_ADDRESS_MEM_MASK))

static inline int pci_enable_device(struct pci_dev *dev) { return 0; }
#define __constant_cpu_to_le32 cpu_to_le32
#define __constant_cpu_to_le16 cpu_to_le16

#define PCI_DMA_TODEVICE   1
#define PCI_DMA_FROMDEVICE 2

extern inline void *pci_alloc_consistent (struct pci_dev *dev, 
                                          size_t size, 
                                          dma_addr_t *dma_handle) {
    void *vaddr = kmalloc(size, GFP_ATOMIC);
    if(vaddr != NULL) {
        *dma_handle = virt_to_bus(vaddr);
    }
    return vaddr; 
}

#define pci_dma_sync_single(dev,dma_handle,size,direction)   do{} while(0)
#define pci_dma_supported(dev, addr_mask)                    (1)
#define pci_free_consistent(dev, size, cpu_addr, dma_handle) kfree(cpu_addr)
#define pci_map_single(dev, addr, size, direction)           virt_to_bus(addr)
#define pci_unmap_single(dev, dma_handle, size, direction)   do{} while(0)


#define spin_lock_bh            spin_lock_irq
#define spin_unlock_bh	        spin_unlock_irq
#define del_timer_sync(timer)   del_timer(timer)
#define net_device              device

#define netif_start_queue(dev)   ( clear_bit(0, &(dev)->tbusy))
#define netif_stop_queue(dev)    (   set_bit(0, &(dev)->tbusy))
#define netif_wake_queue(dev)    { clear_bit(0, &(dev)->tbusy); \
                                   mark_bh(NET_BH); }
#define netif_running(dev)       (  test_bit(0, &(dev)->start))
#define netif_queue_stopped(dev) (  test_bit(0, &(dev)->tbusy))

#define dev_kfree_skb_irq(skb) dev_kfree_skb(skb)

#define netif_carrier_on(dev)  do {} while (0)
#define netif_carrier_off(dev) do {} while (0)


#define PCI_ANY_ID (~0U)

struct pci_device_id {
    unsigned int vendor, device;
    unsigned int subvendor, subdevice;
    unsigned int class, classmask;
    unsigned long driver_data;
};

#define MODULE_DEVICE_TABLE(bus, dev_table)
#define PCI_MAX_NUM_NICS 256

struct pci_driver {
    char *name;
    struct pci_device_id *id_table;
    int (*probe)(struct pci_dev *dev, const struct pci_device_id *id);
    void (*remove)(struct pci_dev *dev);
    void (*suspend)(struct pci_dev *dev);
    void (*resume)(struct pci_dev *dev);
    /* track devices on Linux 2.2, used by module_init and unregister_driver */
    /* not to be used by the driver directly */
    /* assumes single function device with function #0 to simplify */
    struct pci_dev *pcimap[PCI_MAX_NUM_NICS];
};

static inline int pci_module_init(struct pci_driver *drv)
{
    struct pci_dev *pdev;
    struct pci_device_id *pciid;
    uint16_t subvendor, subdevice;
    int board_count = 0;

    /* walk the global pci device list looking for matches */
    for (pdev = pci_devices; pdev && (board_count < PCI_MAX_NUM_NICS); pdev = pdev->next) {

        pciid = &drv->id_table[0];
        pci_read_config_word(pdev, PCI_SUBSYSTEM_VENDOR_ID, &subvendor);
        pci_read_config_word(pdev, PCI_SUBSYSTEM_ID, &subdevice);
        
        while (pciid->vendor != 0) {
            if (((pciid->vendor == pdev->vendor) || (pciid->vendor == PCI_ANY_ID)) &&
                ((pciid->device == pdev->device) || (pciid->device == PCI_ANY_ID)) &&
                ((pciid->subvendor == subvendor) || (pciid->subvendor == PCI_ANY_ID)) &&
                ((pciid->subdevice == subdevice) || (pciid->subdevice == PCI_ANY_ID))) {

                if (drv->probe(pdev, pciid) == 0) {
                    drv->pcimap[board_count] = pdev;
                    board_count++;
                }
                break;
            }
            pciid++;
        }
    }

    if (board_count < PCI_MAX_NUM_NICS) {
        drv->pcimap[board_count] = NULL;
    }

    return (board_count > 0) ? 0 : -ENODEV;
}

static inline void pci_unregister_driver(struct pci_driver *drv)
{
    int i;
    
    for (i = 0; i < PCI_MAX_NUM_NICS; i++) {
        if (!drv->pcimap[i])
            break;
        
        drv->remove(drv->pcimap[i]);
    }
}

/********** e100 specific code **********/

#define pci_set_drvdata(pcid, data) /* NOTHING */
#define pci_get_drvdata(pcid) ({                            \
    bd_config_t *_bdp;                                      \
    for (_bdp = e100_first; _bdp; _bdp = _bdp->bd_next) {   \
        if (_bdp->ppci_dev == pcid)                         \
            break;                                          \
    }                                                       \
    _bdp; })

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0) */


/******************************************************************
 *#################################################################
 *#
 *# Kernels before 2.4.5
 *#
 *#################################################################
 ******************************************************************/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,5)

#define skb_linearize(skb, gfp_mask) ({     \
    struct sk_buff *tmp_skb;                \
    tmp_skb = skb;                          \
    skb = skb_copy(tmp_skb, gfp_mask);      \
    dev_kfree_skb_irq(tmp_skb); })								

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,4,5) */

#endif /* __E100_KCOMPAT_H__ */
