/*  Displays help screen for Copy

    Copyright (c) Marty M. Peritsky 1996.
    All Rights Reserved.

    See COPY.TXT for more details.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <stdio.h>

// F U N C T I O N S ////////////////////////////////////////////////////////

void copyhlp(void)
{
    extern char *myname;
    int i;
    char *hlp[] = {
        "%s Ver. 3.00   Copies or concatenates files.\n\n",
        "Copyright (c) 1996 M. M. Peritsky.  All rights reserved.\n",
        "This program is part of the Free-DOS project. See COPY.TXT for details.\n\n",
        "Syntax:\n",
        "   %s /?|/H\n",
        "   %s [optns] dev|srcspec[+srcspec...] [optns] [dev|destspec [optns]]\n",
        "\n",
        "   dev          is device AUX, COMn, CON, LPTn, NUL, or PRN\n",
        "   srcspec      source device, file or list of files (wildcards allowed)\n",
        "   destspec     destination path, file(s), or device\n",
        "   optns        /A process file as ASCII (Ctrl-Z indicates end-of-file)\n",
        "                /B process file as binary (no special handling of Ctrl-Z)\n",
        "                /C request confirmation before processing\n",
        "                /K keep newer files (don't overwrite them)\n",
        "                /R replace existing files (don't copy others)\n",
        "                /S copy system or hidden files\n",
        "                /V verify that destination was written without errors\n",
        "                /W warn if destination file already exists\n",
        "                /Z zero the high-order bit of every byte in destination\n",
        "Examples:\n",
        "        %s fileA+fileB fileC","         %s *.exe c:mydir\n", NULL };

    i=0;
    while (hlp[i] != NULL)
        {
        if (strchr(hlp[i],'%')==NULL)
            printf(hlp[i++]);
        else
            printf(hlp[i++],myname);

        } // end while.

} // end copyhlp.
