/*    
   Memsort.c - routines to sort entries in memory.

   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

/* Quicksort on entries in memory. */

void MemorySortEntries(struct DirectoryEntry* entries,
                       int (*cmpfunc)(struct DirectoryEntry* e1,
                                      struct DirectoryEntry* e2),
                       int (*filterfunc)(int x),
                       int amofentries)
{
     int i, realentries = 0;

     if (entries[0] == 0x2e) entries++; /* .  */
     if (entries[0] == 0x2e) entries++; /* .. */

     for (i = 0; i < amofentries; i++)
         if ((entries[i] & FA_LABEL) == 0)
            realentries++;

     SortEntries(entries, cmpfunc, filterfunc, 0, realentries-1);
}

static void SortEntries(struct DirectoryEntry* entries,
                        int (*cmpfunc)(struct DirectoryEntry* e1,
                                       struct DirectoryEntry* e2),
                        int (*filterfunc)(int x),
                        int from, int to)
{
     int i, j;
     struct DirectoryEntry entry;

     i = from; j = to;
     entry = *(GetEntry(entries, (i + j) / 2));

     do {
         while (filterfunc(cmpfunc(GetEntry(entries, i), &entry)) == -1) i++;
         while (filterfunc(cmpfunc(GetEntry(entries, j), &entry)) ==  1) j--;

         if (i < j)
         {
            SwapEntry(entries, i, j);

            i++;
            j--;
         }
     } while (i <= j);

     if (j > from) MemorySortEntries(entries, cmpfunc, from, j);
     if (j < to)   MemorySortEntries(entries, cmpfunc, i, to);
}

static struct DirectoryEntry* GetEntry(struct DirectoryEntry* entries,
                                       int index)
{
     int i;

     for (i = 0; i < index; i++)
         while (entries->attribute & FA_LABEL)
               entries++;

     return entries;
}

static void SwapEntry(struct DirectoryEntry* entries,
                      int index1, int index2)
{
   struct DirectoryEntry temp;
   struct DirectoryEntry* entry1, entry2;
   int    len1, len2, i;

   entry1 = GetEntry(entries, index1);
   entry2 = GetEntry(entries, index2);

   len1 = EntryLength(entry1);
   len2 = EntryLength(entry2);

   if (len1 == len2)
   {
      for (i = 0; i < len1; i++)
      {
          temp      = entry1[i];
          entry1[i] = entry2[i];
          entry2[i] = temp;
      }
   }
   else
   {
      moeilijk

   }
}

static int EntryLength(struct DirectoryEntry* entry)
{
   int counter = 1;

   while (IsLFNEntry(entry)) {entry++; counter++;}

   return counter;
}
