#include <string.h>

#include "fte.h"
#include "tstfat12.h"

int MultipleFatCheck(RDWRHandle handle)
{
   unsigned short sectorsperfat = GetSectorsPerFat(handle);
   unsigned char  numberoffats  = GetNumberOfFats(handle);

   unsigned long bytesinfat = GetBytesInFat(handle), compared = 0, rest;

   int fat1start = GetFatStart(handle), fat2start = fat1start, i, j;

   char buffer1[BYTESPERSECTOR];
   char buffer2[BYTESPERSECTOR];

   if ((sectorsperfat == 0) || (numberoffats == 0) || (fat1start == 0) ||
       (bytesinfat == 0))
      return FALSE;                                  /* Not succeeded. */

   if (numberoffats == 1) return TRUE; /* Succeeded when only one fat? */

   rest = bytesinfat % BYTESPERSECTOR;
   for (i = 0; i < numberoffats - 1; i++)
   {
       fat2start += sectorsperfat;

       for (j = 0; j < sectorsperfat; j++)
       {
           ReadSectors(handle, 1, fat1start + j, buffer1);
           ReadSectors(handle, 1, fat2start + j, buffer2);

           if (compared == bytesinfat - rest)
           {
              if (memcmp(buffer1, buffer2, (int) rest) != 0)
                 return FALSE;

              compared = 0;
           }
           else
           {
              if (memcmp(buffer1, buffer2, BYTESPERSECTOR) != 0)
                 return FALSE;

              compared += BYTESPERSECTOR;
           }
       }
   }
   return TRUE;
}
