/*
// Program:  Format
// Version:  0.90
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  uformat.c
// Module Description:  Unconditional Format Functions
*/

#define UFORMAT

#include "format.h"
#include "uformat.h"
#include "floppy.h"
#include "driveio.h"

void Unconditional_Floppy_Format();
void Unconditional_Hard_Disk_Format();

/* Unconditionally Format the Drive */
void Unconditional_Format()
{
  bad_sector_map_pointer=0;

  if(param.drive_type==FLOPPY) Unconditional_Floppy_Format();
  else Unconditional_Hard_Disk_Format();
}

void Unconditional_Floppy_Format()
{
  int drive_number=param.drive_number;
  int index=0;

  unsigned long percentage;

  /* Reset the floppy disk controller */

  regs.h.ah = 0x00;
  regs.h.dl = drive_number;
  int86( 0x13, &regs, &regs);

  do
    {
    if(drive_specs[param.media_type].number_of_heads==2)
     Format_Floppy_Cylinder(index,0);
    Format_Floppy_Cylinder(index,1);

    percentage
     =((100*index)/(drive_specs[param.media_type].cylinders));
    Display_Percentage_Formatted(percentage);

    Compute_Sector_Skew();

    index++;
    }while(index<=drive_specs[param.media_type].cylinders);
}

void Unconditional_Hard_Disk_Format()
{
  int error_code;
  int number_of_sectors=32;

  int percentage_refresh_rate=10;
  int percentage_refresh_counter=10;

  unsigned index=0;

  unsigned long last_bad_sector=0;
  unsigned long sector_number=1;
  unsigned long max_logical_sector
   = drive_specs[param.media_type].total_logical_sectors
   - drive_specs[param.media_type].sectors_per_cluster;
  unsigned long percentage;

  /* Clear and check for bad sectors. (maximum of 32 at a time) */
  do
    {
    /* Set huge_sector_buffer to all 0xf6's. */
    memset(huge_sector_buffer, 0xf6, sizeof(huge_sector_buffer));

    Drive_IO(WRITE,sector_number, number_of_sectors);
    Drive_IO(READ,sector_number, number_of_sectors);

    /* Check for bad sectors by comparing the results of the sector read. */
    index=0;
    do
      {
      if(huge_sector_buffer[index] != 0xf6)
	{
	if( (last_bad_sector==0)
	 || (last_bad_sector!=(sector_number + ( (index+1) / 512) ) ) )
	  {
	  bad_sector_map[bad_sector_map_pointer]
	   = sector_number + ( (index+1) / 512 );
	  }
	}

      index++;
      }while(index< (32*512) );

    if(percentage_refresh_counter==0)
      {
      percentage=(100*sector_number)/max_logical_sector;
      Display_Percentage_Formatted(percentage);
      }
    if(percentage_refresh_counter==percentage_refresh_rate)
     percentage_refresh_counter=-1;
    percentage_refresh_counter++;

    sector_number=sector_number+32;
    }while(sector_number<max_logical_sector);
}
