#include <conio.h>
#include <stdlib.h>
#include "..\screen\screen.h"
#include "..\scandisk.h"
#include "hlpfncs.h"

#define AMOUNTOFHELPLINES 52

static char* contents[] = {"ScanDisk checks the following areas of an uncompressed drive:",
                           "",
                           "Media descriptor",
                           "",
                           "    The media descriptor is a specific code that identifies a",
                           "    drive as a DOS or Windows drive.",
                           "",
                           "    ScanDisk ensures that the media descriptor is in place.",
                           "",
                           "Directory structure",
                           "",
                           "   ScanDisk checks the validity of the drive's directory tree",
                           "   structure and also checks each directory in the tree.",
                           "",
                           "   Invalid directory entries can prevent other disk-repair",
                           "   utilities from recognizing lost clusters, which wastes",
                           "   space on your drive.  If the directory structure is damaged,",
                           "   other utilities may stop unexpectedly when you run them.",
                           "",
                           "File System",
                           "",
                           "   Disk space is made up of segments called clusters.  Only one",
                           "   file should store information in each cluster.  However, a",
                           "   large file may require many clusters for storage.",
                           "",
                           "   ScanDisk makes sure that only one file uses each cluster.",
                           "",
                           "   ScanDisk also checks for lost clusters -- areas of a drive",
                           "   that might contain data, but are not linked to files.  Lost",
                           "   clusters take up disk space tha you could otherwise use.",
                           "",
                           "File Allocation Tables",
                           "",
                           "   FreeDOS uses a file allocation table, or FAT, to determine",
                           "   where each files is stored on a drive.",
                           "",
                           "   FreeDOS drives often have one or more backup copies of the",
                           "   file allocation table.  If one copy is damaged, another can",
                           "   be used to recover it.  ScanDisk ensures that all copies of",
                           "   the file allocation table match.",
                           "",
                           "Free Space",
                           "",
                           "   ScanDisk ensures that free space is reported correctly.",
                           "",
                           "Surface Scan",
                           "",
                           "   ScanDisk tests every area of the drive thoroughly.  If it",
                           "   finds physical problems, ScanDisk moves any data in that",
                           "   location to a safe area of the drive, and then marks the",
                           "   damaged area as unusable.",
                           ""};

void DrawHelpLine(int line, int x, int y, int xlen)
{
     DrawSequence(x, y, xlen, ' ', BLACK, CYAN);
     
     if (line < AMOUNTOFHELPLINES)
        DrawText(x, y, contents[line], BLACK, CYAN);
}

int CheckHelpClick(int cx, int cy, int cxlen, int cylen, int msx, int msy)
{
    cx=cx,cy=cy,cxlen=cxlen,cylen=cylen,msx=msx,msy=msy;
    return 1;
}

void CheckHelpTab(void)
{
}

int CheckHelpEnter(void)
{
    return 2;
}

void SelectHelpPage(int index)
{
    index=index;
}

int PastEndOfHelp(int top, int ylen)
{
    ylen=ylen;
    if (top > AMOUNTOFHELPLINES)
       return TRUE;
    else
       return FALSE;
}

int GetLastHelpTop(int ylen)
{
    ylen=ylen;
    return AMOUNTOFHELPLINES;
}
