;
;     Free DOS Alternative Kernel;  FDBOOT v. 1.10 (01-06-98)
;
;     =                      Boot Sector                    =
;
;               by Yury Semenov (yury@ultra.paco.net)
;

INCLUDE FDBOOT.INC

PUBLIC FDBOOT_ENTRY

BOOT SEGMENT                      ; Code segment begins here
ASSUME CS:BOOT, DS:BOOT
	ORG 0
 FDBOOT_ENTRY:
 START:
        jmp near ptr BEGIN

BootRecord BOOTR <"FDLOADER",512,1,1,2,224,2880,0f0h,9,18,2,0,0,0,29h,0,"Free DOS","FAT12">

BEGIN:
        xor	ax,ax
        cli
        mov	ss,ax
        mov	sp, LOADED - 4        ; Why -4 ? Win'95 (aka MD'95 in xUSSR)
                                      ; store DataStart exactly into dword
                                      ; before LOADED
        sti
        mov	bx,1eh*4              ; Preserving Int 1e Interrupt Table
        lds	si,dword ptr ss:[bx]  ; entry address and (old) content of
        push	ds                    ; this entry in stack.
        push	si                    ; For compatibility with MS-DOS only...
        push	ss                    ; It seems to me that MS-DOS kernel also
        push	bx                    ; never use these preserved values ;-)
        mov	es,ax
        mov	ds,ax
        mov	dl,byte ptr BootRecord.PhysDrive[LOADED]
        int	13h                   ; Reset Drive
                                      ; and DataStart
        mov	byte ptr ds:[XBOOTADDR+2],0    ; Remove "XB" signature
; * Address space before this point will be used as FDBOOT work data area *
RESCAN:
        xor	ax,ax
        mov	bp,LOADED ;FDBOOTDATA  ; Initializing pointer to CurrentLS
        mov	KernOfs,ax  ;0
        mov	bx,DIRWIN

; * Root directory processing
        mov	al,ss:[bp+br_FATcnt]
;        xor	ah,ah
        mul	word ptr ss:[bp+br_FATsz]
        add	ax,ss:[bp+br_ResSec]
        adc	dx,0                  ; DX:AX - Starting dir logical sector
        add	ax,word ptr ss:[bp+br_Hidden]
        adc	dx,word ptr ss:[bp+br_Hidden+2]
        mov	CurrentLS_lo,ax      ; Store it to CurrentLS
        mov	CurrentLS_hi,dx
        xor	dx,dx
        mov	ax,ss:[bp+br_SectSz]
        mov	cx,20h
        div	cx
        xor	dx,dx
        push	dx
        mov	cx,ax
        mov	ax,ss:[bp+br_RootDirEnt]
        div	cx
        mov	dx,cx                 ; DX - number of dir entrys in sector
        mov	cx,ax                 ; CX - number of sectors in directory
        add	ax,CurrentLS_lo
        mov	DataStart_lo,ax
        pop	ax
        adc	ax,CurrentLS_hi
        mov	DataStart_hi,ax             ; Initializing DataStart
 rootproc:
        push	cx
        push	dx
        push	dx
        mov	ax,CurrentLS_lo
        mov	dx,CurrentLS_hi
        add	CurrentLS_lo,1
        adc	CurrentLS_hi,0
        call	TransLS
        call	ReadSector
        pop	cx
        mov	di,bx
 entryproc:
 	push	cx
;        cmp	byte ptr [di],0e5h ; Somebody tryes to load erased file :-()!
;        jz	notvalid           ; Maybe this is his own ploblem ;-)?
;        cmp	byte ptr [di],0    ; In any case size of this code: 10 bytes
;        jz	notvalid           ;
        test	byte ptr [di].F_attr, SUBDIR OR VOLUME
        jnz	notvalid
        cld
        mov	cx,11
        push	cx
        cmp	byte ptr ds:[XBOOTADDR+2],0
        jnz	notxboot
        lea	si,XBootName[bp]
        push	di
        rep	cmpsb
        pop	di
        jnz	notxboot
        ;XBoot Found!!! ;-)
        push	bx
        mov	bx,XBOOTADDR
        mov	cl,1
        mov	ax,[di].F_cluster
        mov	XBStart,ax
        call	LoadHead
        pop	bx
   notxboot:
        pop	cx

        cmp	KernOfs,0
        jnz	notvalid
        lea	si,KernelName[bp]
        push	di
        rep	cmpsb
        pop	di
        jnz	notvalid
        mov	KernOfs,di
    notvalid:
        add	di,20h
        pop	cx
        loop	entryproc
        cmp	KernOfs,0
        jz	WOkernel
        mov	bx,DATAWIN
   WOkernel:
        pop	dx
        pop	cx
        loop	rootproc
; * Miscellaneous boot actions
        cmp	ds:[XBOOTADDR+2],'BX'        ; Does we have loaded XBoot?
        jnz	NoXB                         ; No, now we'll try to load default kernel...
        mov	bx,XBOOTSTART                ; 11 bytes!
        mov	di,XBStart
        jmp	bx                           ; Good Bye! We go to XBoot!
DefKernLoad:
NoXB:	mov	di,KernOfs                   ; Does we have found default kernel?
        or	di,di
        jnz	Found
   Abort:
        lea	bx,FailMsg[bp]        ; Kernel and XBoot not found!
        call	puts                         ; Prompt to Reboot
        xor	ah,ah
        int	16h
        int	19h

Found:	mov	bx,DATAWIN           ; Loading default kernel...
        mov	cl,3                ; # of sectors to load
                                     ; DOS 3.30 - 1, 5.00 and 6.20 - 3 ... :-(
        mov	ax,[di].F_cluster
        call	LoadHead
        cmp	word ptr [bx],'ZM'
        jnz	NoMZ                 ; Not .EXE!
        cmp	byte ptr ds:[XBOOTADDR+2], 0        ; Does we have loaded XBoot?
        jz	Abort                        ; No XBoot - so we can't load .EXE
        mov	bx,XBOOTEXE                  ;
        jmp	bx                           ; Good Bye! We go to XBoot!
NoMZ:
        mov	ax, DataStart_hi
        mov	bx, DataStart_lo      ; AX:BX := DataStart
        mov	di, KernOfs
        mov	di, [di].F_cluster
;        mov	bp, LOADED           ; Win'95 feature ; already here!
        ; BTW: SS==DS isn't it? So I'll use [bp] instead [LOADED]
        mov	ch,ss:[bp+br_Media]
        mov	dl,byte ptr ss:[bp+br_PhysDrive]
; Borland Turbo Link makes here  -V- correct far jump to absolute address
;        jmp	KERNEL_ENTRY  ; Kernel Start
; but specially for VALlink I must use following construction
;   (maybe I don't know some VALlink modes or switches?):
        DB	0eah
        DB	0
W95     DB	0    ; Here must be 0 for usual kernel and 2 for W'95!
        DB	70h
        DB	0

LoadHead PROC NEAR      ; Load CL sequential sectors from file begining
                        ; AX    - file starting cluster
                        ; DS:BX - address of buffer
                        ; CL    - number of sectors
	push	cx
        call	TransCl
        pop	ax
        jmp	ReadALSect
LoadHead ENDP

TransCl PROC NEAR       ; Translate cluster number
                        ; AX - Cluster number
                        ; Returns: valid registers for sector reading
                        ; (int 13 Fn 2)
        ;sub	ax,2
        dec	ax
        dec	ax
        mov	dl,ss:[bp+br_ClustSz]
        xor	dh,dh
        mul	dx
        add	ax,DataStart_lo
        adc	dx,DataStart_hi
        ;jmp	TransLS ;                              Attention!
TransCl ENDP            ;                              vvvvvvv DON'T  INSERT
TransLS PROC NEAR       ; Translate logical sector     ^^^^^^^ HERE ANYTHING
                        ; DX:AX - Logical Sector
                        ; Returns: valid registers for sector reading
                        ; (int 13 Fn 2)
        div	word ptr ss:[bp+br_TrkSec]
        inc	dx
        push	dx
        xor	dx,dx
        div	word ptr ss:[bp+br_Heads]
        mov	ch,al
        and	ah,3
        ror	ah,1
        ror	ah,1
        mov	cl,ah
        pop	ax
        and	al,3fh
        or	cl,al
        mov	dh,dl
        mov	dl,byte ptr ss:[bp+br_PhysDrive]
 Empty: ret
TransLS ENDP


ReadSector PROC NEAR    ; Read Sector Procedure
                        ; Reads sector to buffer pointed by ES:BX
                        ; CX and DX must be prepared by previous procs
        mov	al,1
ReadALSect LABEL NEAR
        mov	ah,2
	push	bp
        mov	bp,DRV_TRY
 DRVretry:
        push	ax
        int	13h
        pop	ax
        jc	DRVreset
 DRVquit:
        pop	bp
        ret
 DRVreset:
        dec	bp
        jnz	DRVretry
        ;stc
        ;jmp	DRVquit
        jmp	Abort
ReadSector ENDP

puts	PROC NEAR       ; Print z-string
                        ; DS:BX - string address
	mov	al,[bx]
        or	al,al
;        jz	putz
        jz	Empty
        inc	bx
	push	bx
        push	bp
        put_al
        pop	bp
        pop	bx
        jmp	puts
;putz:	ret
PUTS	ENDP


FailMsg   DB "Boot Failed",13,10,0

FreeSpace LABEL BYTE

        ORG 474
           DW offset RESCAN      + LOADED
           DW offset DefKernLoad + LOADED
           DW offset puts        + LOADED
           DW offset ReadSector  + LOADED
           DW offset TransLS     + LOADED
           DW offset TransCl     + LOADED
           DW offset LoadHead    + LOADED
XBootName  DB "XBOOT   SYS"
KernelName DB "IO      SYS"
Boot_Sign  DW 0aa55h

BOOT ENDS

 end
