.\" Copyright 1999 Sun Microsystems, Inc.  All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbChangeIndicators __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbChangeIndicators \- Changes indicator maps or state without passing the 
entire keyboard description
.SH SYNOPSIS
.HP
.B Bool XkbChangeIndicators
.BI "(\^Display *" "dpy" "\^,"
.BI "XkbDescPtr " "xkb" "\^,"
.BI "XkbIndicatorChangesPtr " "changes" "\^,"
.BI "unsigned int " "state" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to the X server 
.TP
.I \- xkb
keyboard description from which names are to be taken. 
.TP
.I \- changes
indicators to be updated on the server
.TP
.I \- state
new state of indicators listed in changes->state_changes
.SH DESCRIPTION
.LP
The XkbIndicatorChangesRec identifies small modifications to the indicator map. 
Use it with the function 
.I XkbChangeIndicators 
to reduce the amount of traffic sent to the server (see STRUCTURES).
    
The 
.I state_changes 
field is a mask that specifies the indicators that have changed state, and
.I map_changes 
is a mask that specifies the indicators whose maps have changed.

.I XkbChangeIndicators 
copies any maps specified by 
.I changes 
from the keyboard description, 
.I xkb, 
to the server specified by 
.I dpy. 
If any bits are set in the 
.I state_changes 
field of 
.I changes, XkbChangeIndicators 
also sets the state of those indicators to the values specified in the 
.I state 
mask. A 1 bit in 
.I state 
turns the corresponding indicator on, a 0 bit turns it off.

In addition, it can also generate XkbIndicatorStateNotify and 
XkbIndicatorMapNotify events.

Whenever an indicator changes state, the server sends XkbIndicatorStateNotify events 
to all interested clients. Similarly, whenever an indicator's map changes, the 
server sends XkbIndicatorMapNotify events to all interested clients.

To receive XkbIndicatorStateNotify events, use 
.I XkbSelectEvents 
with both the 
.I bits_to_change 
and 
.I values_for_bits 
parameters containing XkbIndicatorStateNotifyMask. To receive XkbIndicatorMapNotify 
events, use 
.I XkbSelectEvents 
with XkbIndicatorMapNotifyMask.

To receive events for only specific indicators, use 
.I XkbSelectEventDetails. 
Set the 
.I event_type 
parameter to XkbIndicatorStateNotify or XkbIndicatorMapNotify, and set both the
.I bits_to_change 
and 
.I values_for_bits 
detail parameters to a mask where each bit specifies one indicator, turning on those 
bits that specify the indicators for which you want to receive events.

.I xkb_type 
is either XkbIndicatorStateNotify or XkbIndicatorMapNotify, depending on whether the 
event is a kbIndicatorStateNotify event or kbIndicatorMapNotify event.

The 
.I changed 
parameter is a mask that is the bitwise inclusive OR of the indicators that have 
changed. If the event is of type XkbIndicatorMapNotify, 
.I changed 
reports the maps that changed. If the event is of type XkbIndicatorStateNotify,
.I changed 
reports the indicators that have changed state. 
.I state 
is a mask that specifies the current state of all indicators, whether they have 
changed or not, for both XkbIndicatorStateNotify and IndicatorMapNotify events.
.SH STRUCTURES
.LP
.nf
     typedef struct _XkbIndicatorChanges {
         unsigned int	      state_changes;
         unsigned int	       map_changes;
     }XkbIndicatorChangesRec,*XkbIndicatorChangesPtr;
     
.fi 
Both types of indicator events use the same structure:

.nf
    typedef struct _XkbIndicatorNotify {
        int            type;        /\(** Xkb extension base event code */
        unsigned long  serial;      /\(** X server serial number for event */
        Bool           send_event;  /\(** True => synthetically generated */
        Display *      display;     /\(** server connection where event generated */
        Time           time;        /\(** server time when event generated */
        int            xkb_type;    /\(** specifies state or map notify */
        int            device;      /\(** Xkb device ID, will not be XkbUseCoreKbd*/
        unsigned int   changed;     /\(** mask of indicators with new state or map */
        unsigned int   state;       /\(** current state of all indicators */
    } XkbIndicatorNotifyEvent;
     
.fi     
.SH DIAGNOSTICS
.TP 15
.B BadAtom
A name is neither a valid Atom or None
.TP 15
.B BadImplementation
Invalid reply from server
.SH "SEE ALSO"
.BR XkbIndicatorMapNotify (__libmansuffix__),
.BR XkbIndicatorStateNotify (__libmansuffix__)
