% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{htmltools_value}
\alias{htmltools_value}
\title{flextable as an 'HTML' object}
\usage{
htmltools_value(
  x,
  ft.align = NULL,
  ft.shadow = NULL,
  extra_dependencies = NULL
)
}
\arguments{
\item{x}{a flextable object}

\item{ft.align}{flextable alignment, supported values are 'left', 'center' and 'right'.}

\item{ft.shadow}{deprecated.}

\item{extra_dependencies}{a list of HTML dependencies to
add in the HTML output.}
}
\value{
an object marked as \link[htmltools:HTML]{htmltools::HTML} ready to be used within
a call to \code{shiny::renderUI} for example.
}
\description{
get a \code{\link[htmltools:builder]{htmltools::div()}} from a flextable object.
This can be used in a shiny application. For an output within
"R Markdown" document, use \link{knit_print.flextable}.
}
\examples{
htmltools_value(flextable(iris[1:5, ]))
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{save_as_rtf}()},
\code{\link{to_html.flextable}()}
}
\concept{flextable print function}
