#!/usr/local/bin/perl
#
# Field.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Field;

use cgi::cafPage;
@Field::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
#??	{ fName => "id" },
	{ fName => "type" },
	{ fName => "name", fType => "atom", fMand => 1, fMin => 3, dMax => 30 }, 
	{ fName => "parent_id" },
	{ fName => "objectlabel" },
	{ fName => "created" },
	{ fName => "modified" },
	{ fName => "deleted" },
	{ fName => "comments" },
	{ fName => "status" },
	{ fName => "createdby" },
	{ fName => "modifiedby" },

	{ fName => "object_id" },
 	{ fName => "externalname", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "datatypeid", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "datalength", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "datascale", },
	{ fName => "dataformat", },
	{ fName => "fieldorder", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "fieldpos", },
	{ fName => "keyposition", },
	{ fName => "localfield", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "referto_id", },
	{ fName => "xmlnode", },
	{ fName => "defaultvalue", },
	{ fName => "nullable", },
	{ fName => "parent_id_name", },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search3} = $cgi->param("search3")) =~ s/ *//g;
	if ($self->_hiddenvar("_thiscontainer", $cgi->param("_thiscontainer"))) {
		$self->_hiddenvar("_thiscontainer0", $cgi->param("_thiscontainer0"));
		$self->{search2} = $self->_hiddenvar("_thiscontainer");
		$self->{search0} = $self->_hiddenvar("_thiscontainer0");
	}
	else {
		$self->_hiddenvar("_thiscontainer", undef);
		$self->_hiddenvar("_thiscontainer0", undef);
		($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
		($self->{search0} = $cgi->param("search0")) =~ s/ *//g;
	}

	my $currpage = $self->_hiddenvar ("_currpage");
	if ($currpage eq 'fieldt') { $self->{search3} = undef ;}

#	print "SEARCH 0 = $self->{search0} ; SEARCH 2 = $self->{search2} ; SEARCH 3 = $self->{search3}  ; SEARCH 1 = $self->{search1}";
	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) {
		$cond->[++$icond] = [ [ "objects.name", "field.externalname" ], "like", $self->{search1} ];
#		$cond->[++$icond] = [ "field.externalname", "like", $self->{search1} ];
	}
	if ($self->{search2}) { $self->{search2} =~ s/[^0-9]*//g; $cond->[++$icond] = [ "objects.parent_id", " = ", $self->{search2} ]; }
	if ($self->{search3}) { $cond->[++$icond] = [ "objects.status", "like", $self->{search3} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("field", $cond, "isobject");
	
	my $query = $dbh->newquery({ name => $self->{search1}, status => $self->{search3}, parent_id => $self->{search2} });
	$query->sfieldlist();

	my $rows;
	if ($currpage eq 'fieldt') { $rows = $self->{_list1} = $dbh->hexecfetchall($query); }
	else { $rows = $self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay); }
	$self->{list1count} = $query->hrowcount();

	if (($rows->[0]) && ($rows->[0]{"driverid"})) {
		$query = $dbh->newquery( { "driverid" => $rows->[0]{"driverid"}});
		$query->sdatatypelist();
		$self->{_datatypelist} = $dbh->hexecfetchall($query);
	}

	my @containerids;
	my %contids;
	foreach my $conn (@{$self->{_list1}}) {
		$contids{$conn->{parent_id}} = $conn->{parent_id} if ($conn->{parent_id} and (!$contids{$conn->{parent_id}}));
#		push @connectorids, $conn->{parent_id} if ($conn->{parent_id});
	}
	my @containerids = keys %contids;
	my $objectids = $self->_getobjectids(@containerids);

	foreach my $conn (@{$self->{_list1}}) {
		foreach my $server (@{$objectids}) {
			if ($conn->{parent_id} eq $server->{id}) { $conn->{parent_id_name} = $server->{name}; last; }
		}
	}

	$self->{containerids} = \@containerids if ($#containerids > -1);
	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "") unless ($currpage eq 'fieldt');
	$self->_setnavinfo("list1");
	# print "<BR>\nlist1count = $self->{list1count}";
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_systemvar("_miscinfo_", '_miscinfo_');
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'field');
	$self->_datavar("parent_id", -1) unless ($self->_datavar("parent_id"));
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search3", $cgi->param("search3"));
	if ($self->_hiddenvar("_thiscontainer", $cgi->param("_thiscontainer"))) {
		$self->_hiddenvar("_thiscontainer0", $cgi->param("_thiscontainer0"));
		$self->{search2} = $self->_hiddenvar("_thiscontainer");
		$self->{search0} = $self->_hiddenvar("_thiscontainer0");
	}
	else {
		$self->_hiddenvar("_thiscontainer", undef);
		$self->_hiddenvar("_thiscontainer0", undef);
		($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
		($self->{search0} = $cgi->param("search0")) =~ s/ *//g;
	}

	my $query = $dbh->newquery();
	$query->sprotocollist();
	$self->{_protocollist} = $dbh->hexecfetchall($query);

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id")); }

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	unless ($self->{_system}{noselect}) {
		$query = $dbh->newquery({ object_id => $self->_datavar("object_id"), id => $self->_datavar("object_id"), });
		$self->_datavar("id", $self->_datavar("object_id"));

		$query->sfieldlist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (keys %{$row}) { $self->_datavar($field, $row->{$field}); }

#		$query->sobject();
#		$row = $dbh->hexecfetchrow($query, 1);
#		foreach my $field (keys %{$row}) { $self->_datavar($field, $row->{$field}); }

		$query = $dbh->newquery({ object_id => $self->_datavar("parent_id"), id => $self->_datavar("parent_id"), });
		$query->scontainerlist();
		$row = $dbh->hexecfetchrow($query, 1);
#		foreach my $field (keys %{$row}) { $self->_datavar($field, $row->{$field}); }
#		print "<BR> $row->{name} - $row->{driverid} - ";
#		$self->_datavar("driverid", $row->{driverid});

		my $objectids = $self->_getmyobjectids(qw(parent_id));
	}
	if ($actiondetail eq 'copy') { $self->_datavar("object_id", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("objectid"));

	if ($self->_datavar("driverid")) {
        	$query = $dbh->newquery( { "driverid" => $self->_datavar("driverid") });
        	$query->sdatatypelist();
        	$self->{_datatypelist} = $dbh->hexecfetchall($query);
	}
	else {
        	$query = $dbh->newquery();
        	$query->sdatatypeliststd();
        	$self->{_datatypelist} = $dbh->hexecfetchall($query);
	}

	$self->_datavar("localfield", 'no') unless ($self->_datavar("localfield"));
	$self->_datavar("datatypeid", 'SQL_VARCHAR') unless ($self->_datavar("datatypeid"));
	$self->_datavar("status", 'online') unless ($self->_datavar("status"));
	$self->_datavar("parent_id", undef) unless ($self->_datavar("parent_id") > 0);

	$self->{_attributeslist} = $self->_getmyattributes($dbh);
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $ret;

	if ($self->_datavar("parent_id")) {
		$self->_datavar("object_id", $dbh->nextseq("objects"));
		my $bindvars = $self->_getmyfields();
		my $query = $dbh->newquery($bindvars);

		$query->iobject();
		if (($ret = $dbh->executefinish($query)) > 0) {
			$query->ifield();
			$ret = $dbh->executefinish($query);
			if ($ret > 0) { $self->_updateattributes(); }
			if ($ret > 0) { $dbh->commit(); }
			else { $dbh->rollback(); }
		}
		else { $dbh->rollback(); }
	}
	else { return undef; }

	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());
	my $ret;

	$query->uobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->ufield();
		if (($ret = $dbh->executefinish($query)) > 0) {
			$self->_updateattributes();
			$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }

	return ($ret);
}

sub updatefield {
	my $self = shift;
	my $field = shift;
	my $dbh = shift;

	my $query = $dbh->newquery($field);
	my $ret;

	$query->uobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->ufield();
		$ret = $dbh->executefinish($query);
	}
	return ($ret);
}


sub insertfield {
	my $self = shift;
	my $field = shift;
	my $dbh = shift;

	$field->{object_id} = $dbh->nextseq("objects");
	my $query = $dbh->newquery($field);
	my $ret;

	$query->iobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->ifield();
		$ret = $dbh->executefinish($query);
	}

	return ($ret);
}

sub meth_vedite {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $ret;


	my $ret = 1;
	my $parent_id = $cgi->param("_thiscontainer");
	for (my $i = 0; my $name = $cgi->param("name_$i"); $i++) {
		my $field = {};
		my $checked = $cgi->param("checked_$i");
		foreach my $f (@$editfields) {
			my $fName = $f->{fName};
			$field->{$fName} = $cgi->param($fName . "_$i");
		}
		$field->{type} = "field";
		$field->{localfield} = "no";
		$field->{parent_id} = $parent_id;
		$field->{currentuser} = $self->_hiddenvar("_userid");

		if ($checked and $field->{name} and $field->{externalname}) {
			if ($field->{object_id} > 0) {
				$ret = $self->updatefield($field, $dbh);
			}
			else {
				$ret = $self->insertfield($field, $dbh);
			}
		}
		last unless ($ret > 0);
	}
	if ($ret > 0) {
		$dbh->commit();
	}
	else { $dbh->rollback(); }
	$self->meth_edite($cgi, $dbh, $conf);
=over
	$self->_datavar("object_id", $cgi->param("_objectid")) unless ($self->_datavar("object_id"));
	my $query = $dbh->newquery($self->_getmyfields());

	$query->uobject();
	if (($ret = $dbh->executefinish($query)) > 0) {
		$query->ufield();
		if (($ret = $dbh->executefinish($query)) > 0) {
			$self->_updateattributes();
			$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }
=cut
	return ($ret);
}

sub meth_edite {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->meth_search($cgi, $dbh, $conf);

	my $containerids = $self->{containerids};
	if (! $containerids && ($self->_hiddenvar("_thiscontainer") > 0)) {
		$containerids = [ $self->_hiddenvar("_thiscontainer") ];
	}
	my $container;
	my $query;
	if ($containerids) {
		$query = $dbh->newquery({ object_id => $containerids->[0] });
		$query->scontainerlist();
		$container = $dbh->hexecfetchrownop($query, 1);
	}
	$self->{_container} = $container;

	if ($container->{driverid}) {
		$query = $dbh->newquery( { "driverid" => $container->{driverid} });
		$query->sdatatypelist();
	}
	$self->{_datatypelist} = $dbh->hexecfetchall($query);                                                                                 
	unshift @{$self->{_datatypelist}}, {datatypeid => undef, driverid => undef, stdname => "_________", };
	$self->{_list1} ||= [];
	push @{$self->{_list1}}, ({}, {}, {});
	$self->{list1count} += 3; 
=over
	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search3} = $cgi->param("search3")) =~ s/ *//g;
	if ($self->_hiddenvar("_thiscontainer", $cgi->param("_thiscontainer"))) {
		$self->_hiddenvar("_thiscontainer0", $cgi->param("_thiscontainer0"));
		$self->{search2} = $self->_hiddenvar("_thiscontainer");
		$self->{search0} = $self->_hiddenvar("_thiscontainer0");
	}
	else {
		$self->_hiddenvar("_thiscontainer", undef);
		$self->_hiddenvar("_thiscontainer0", undef);
		($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
		($self->{search0} = $cgi->param("search0")) =~ s/ *//g;
	}

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) {
		$cond->[++$icond] = [ [ "objects.name", "field.externalname" ], "like", $self->{search1} ];
#		$cond->[++$icond] = [ "field.externalname", "like", $self->{search1} ];
	}
	if ($self->{search2}) { $self->{search2} =~ s/[^0-9]*//g; $cond->[++$icond] = [ "objects.parent_id", " = ", $self->{search2} ]; }
	if ($self->{search3}) { $cond->[++$icond] = [ "objects.status", "like", $self->{search3} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("field", $cond, "isobject");
	
	my $query = $dbh->newquery({ name => $self->{search1}, status => $self->{search3}, parent_id => $self->{search2} });
	$query->sfieldlist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	my @serverids;
	foreach my $conn (@{$self->{_list1}}) {
		push @serverids, $conn->{parent_id} if ($conn->{parent_id});
	}
	my $objectids = $self->_getobjectids(@serverids);

	foreach my $conn (@{$self->{_list1}}) {
		foreach my $server (@{$objectids}) {
			if ($conn->{parent_id} eq $server->{id}) { $conn->{parent_id_name} = $server->{name}; last; }
		}
	}
			
	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
=cut
}
sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->dfield();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
