#!/usr/local/bin/perl
#
#aldbtypes.pm 05/03/2001
#
# deltaflow : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

# CHANGE HISTORY
#date time       user          Action
#==========      =====         ===========================================

# Type de bases de donnes

use strict;

package aldbtypes;

@aldtypes::objetypes = (
			['datb',   'Bases de donnes'],
			['tabl',   'Tables'],
			['cols',   'Champs de table'],
			['flow',   'Flux global'],
			['ftbl',   'Demi flux'],
			['prog',   'Scripts'],
			['clnd',   'Planifiaction']
			);

@aldtypes::evnttypes = (
			['flow',   'Planification d\'un flux'],
			['tabl',   'Planification de la purge d\'une table '],
			['prog',   'Planification d\'un script utilisateur'],
			);


@aldtypes::dbtypes = (
			['oracle', 'Oracle V7-V8'],
			['pg',     'Postgres'],
			['mysql',  'MySql'],
			['csv',    'Fichiers avec serparateurs'],
			['flff',   'Fichiers - Enr de taille fixe'],
			['xml',    'Fichiers XML'],
			['html',   'Fichiers HTML'],
			['vrac',   'En vrac']
			);

@aldtypes::proglang = (
			['perl',    'Perl V5'],
			['sql',     'Langage SQL'],
			);

@aldtypes::zobjestat = (
	        ['online',       'Actif'],
		['offline',      'Inactif'],
		['running',      'En execution'],
		['error',        'En erreur'],
);

@aldtypes::objestat = (
			['online',       'Actif'],
			['offline',      'Inactif'],
			['develop',      'En dve'],
			['test',         'En test'],
			['deleted',      'Supprim'],
			);

@aldtypes::prottylist = (
			['dbi',          'DBI de Perl'],
			['lfs',          'Systme de fichier local'],
			['ftp',          'Ftp'],
			['http',         'HTTP'],
			['smtp',         'SMTP'],
			['pop3',         'POP3'],
			);

@aldtypes::flowtypes = (
			['simple',         'Flux simple'],
			['replicat',       'Flux de rplication'],
			);

@aldtypes::ftblmethodsi = (
			['P',         'NORMAL'],
			['O',         'TRUNC'],
			);

@aldtypes::ftblmethodso = (
			['IU',         'INS-UPD'],
			['UI',         'UPD-INS'],
			['I',          'INSERT'],
			['U',          'UPDATE'],
			['DI',         'DEL-INS'],
			['D',          'DELETE'],
			['O',          'TRUNC'],
			);

@aldtypes::dflowlist = (
			['inco',         'Flux entrant'],
			['outgo',        'Flux sortant'],
			['inou',         'Flux mixte'],
			);

@aldtypes::dflowlist2 = (
			['inco',         'Flux entrant'],
			['outgo',        'Flux sortant'],
			);

@aldtypes::colnlist = (
			['none',         'Pas de nom de colonnes'],
			['first',        'Premiere ligne'],
			);

@aldtypes::trigtypes = (
			['no',           'Pas de triggers'],
			['yes',          'Utiliser les triggers'],
			['dattim',       'Champ date heure'],
			);

@aldtypes::tabletypes = (
		['table', 'Les tables'],
		['view',   'Les vues'],
		['both',   'Les tables et les vues']
		);
			
@aldtypes::progtypes = (
		['qrysel',     'Table : requte SELECT'],
		['qryins',     'Table : requte INSERT'],
		['qryupd',     'Table : requte UPDATE'],
		['qrydel',     'Table : requte DELETE'],
		['qrytrunc',   'Table : requte TRUNCATE'],
		['tblbopen',   'Table : avant ouvrir'],
		['tblaopen',   'Table : aprs ouvrir'],
		['tblbread',   'Table : avant lecture enr'],
		['tblaread',   'Table : aprs lecture enr'],
		['tbltrans',   'Table : transformation'],
		['tblbwrite',  'Table : avant criture enr'],
		['tblawrite',  'Table : aprs criture enr'],
		['tblbclose',  'Table : avant fermer'],
		['tblaclose',  'Table : aprs fermer'],
		['flwbopen',   'Flux  : avant ouvrir'],
		['flwaopen',   'Flux  : aprs ouvrir'],
		['flwbclose',  'Flux  : avant fermer'],
		['flwaclose',  'Flux  : aprs fermer'],
		['flwdatb',  'Flux  : autre base de donne'],
		['flwdatb',  'Flux  : autre base de donne'],
		['flwqry',   'Flux  : autre requte'],
		['flwqry',   'Flux  : autre requte'],
		['flwqry',   'Flux  : autre requte'],
		['flwqry',   'Flux  : autre requte'],
		['coltrans',   'Champ : transformation'],
#		['dtbbopen',   'BdD   : avant connexion'],
#		['dtbaopen',   'BdD   : aprs connexion'],
#		['dtbbclose',  'BdD   : avant dconnexion'],
#		['dtbaclose',  'BdD   : aprs dconnexion'],
		['userscript', 'Scripts utilisateur'],
		['onerror',    'Gestion d\'erreurs'],
		);

@aldtypes::tblprogtypes = (
		['qrysel',     'Table : requte SELECT'],
		['qryins',     'Table : requte INSERT'],
		['qryupd',     'Table : requte UPDATE'],
		['qrydel',     'Table : requte DELETE'],
		['qrytrunc',   'Table : requte TRUNCATE'],
		['tblbopen',   'Table : avant ouvrir'],
		['tblaopen',   'Table : aprs ouvrir'],
		['tblbread',   'Table : avant lecture enr'],
		['tblaread',   'Table : aprs lecture enr'],
		['tbltrans',   'Table : transformation'],
		['tblbwrite',  'Table : avant criture enr'],
		['tblawrite',  'Table : aprs criture enr'],
		['tblbclose',  'Table : avant fermer'],
		['tblaclose',  'Table : aprs fermer'],
		['onerror',    'Gestion d\'erreurs'],
		);

@aldtypes::flwprogtypes = (
		['flwbopen',   'Flux  : avant ouvrir'],
		['flwaclose',  'Flux  : aprs fermer'],
		['onerror',    'Gestion d\'erreurs'],
		);

@aldtypes::dtbprogtypes = (
		['dtbbopen',   'BdD   : avant connexion'],
		['dtbaopen',   'BdD   : aprs connexion'],
		['dtbbclose',  'BdD   : avant dconnexion'],
		['dtbaclose',  'BdD   : aprs dconnexion'],
		['onerror',    'Gestion d\'erreurs'],
		);

%aldtypes::sqlprogtypes = (
		'qrysel'   => 1,
		'qryins'   => 1,
		'qryupd'   => 1,
		'qrydel'   => 1,
		'qrytrunc' => 1,
		);

# Les protocoles
@aldtypes::prottypes = (
			['dbi',     'Driver DBI'],
			['lfs',     'System de fichier local'],
			['ftp',     'service ftp'],
			['mail',    'Mail (pop3)'],
			['http',    'Serveur www'],
			['telnet',  'Service telnet']
			);

# Type de champ <=> XML
@aldtypes::xmlelttypes = (
				[ 'node',    'Noeud' ],
				[ 'leaf',    'Feuille' ],
				[ 'attrib',  'Attribut' ],
);

#Format de donnes

#Types de donnes

%aldtypes::datatypesconv = (
'standard' => {
         0 => 'SQL_ALL_TYPES',
         1 => 'SQL_CHAR',
         2 => 'SQL_NUMERIC',
         3 => 'SQL_DECIMAL',
         4 => 'SQL_INTEGER',
         5 => 'SQL_SMALLINT',
         6 => 'SQL_FLOAT',
         7 => 'SQL_REAL',
         8 => 'SQL_DOUBLE',
         9 => 'SQL_DATE',
        10 => 'SQL_TIME',
        11 => 'SQL_TIMESTAMP',
        12 => 'SQL_VARCHAR',
        -1 => 'SQL_LONGVARCHAR',
        -2 => 'SQL_BINARY',
        -3 => 'SQL_VARBINARY',
        -4 => 'SQL_LONGVARBINARY',
        -5 => 'SQL_BIGINT',
        -6 => 'SQL_TINYINT',
        -7 => 'SQL_BIT',
        -8 => 'SQL_WCHAR',
        -9 => 'SQL_WVARCHAR',
       -10 => 'SQL_WLONGVARCHAR'
				},
'mysql'    => {
        'VARCHAR'    =>  12,
        'DECIMAL'    =>   3,
        'TINYINT'    =>  -6,
        'SMALLINT'   =>   5,
        'INTEGER'    =>   4,
        'FLOAT'      =>   7,
        'DOUBLE'     =>   8,
        'TIMESTAMP'  =>   11,
        'BIGINT'     =>   -5,
        'MIDDLEINT'  =>   4,
        'DATE'       =>   9,
        'TIME'       =>   10,
        'DATETIME'   =>   11,
        'YEAR'       =>   5,
        'DATE'       =>   9,
        'ENUM'       =>   12,
        'SET'        =>   12,
        'BLOB'       =>   -1,
        'TINYBLOB'   =>   -1,
        'MEDIUMBLOB' =>   -1,
        'LONGBLOB'   =>   -1
				},
'pg'       => {
        'BOOL'       =>   0,
        'INT8'       =>   8,
        'INT2'       =>   5,
        'INT4'       =>   4,
        'TEXT'       =>  12,
        'FLOAT4'     =>   6,
        'FLOAT8'     =>   7,
        'ABSTIME'    =>  10,
        'RELTIME'    =>  10,
        'TINTERVAL'  =>  11,
        'MONEY'      =>   0,
        'BPCHAR'     =>  12,
        'VARCHAR'    =>  12,
        'DATE'       =>   9,
        'TIME'       =>  10,
        'DATETIME'   =>  11,
        'TIMESPAN'   =>  11,
        'TIMESTAMP'  =>  10
        },
'oracle'    => {
        'LONG_RAW'   =>  -4,
        'RAW'        =>  -3,
        'LONG'       =>  -1,
        'CHAR'       =>   1,
        'NUMBER'     =>   3,
        'DOUBLE'     =>   8,
        'DATE'       =>  11,
        'VARCHAR2'   =>  12
        },
'csv'       => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'flff'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'xml'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'html'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'vrac'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
);

%aldtypes::datatypes = (
'standard' => [
        ['SQL_ALL_TYPES', 'SQL_ALL_TYPES'],
        ['SQL_CHAR', 'SQL_CHAR'],
        ['SQL_NUMERIC', 'SQL_NUMERIC'],
        ['SQL_DECIMAL', 'SQL_DECIMAL'],
        ['SQL_INTEGER', 'SQL_INTEGER'],
        ['SQL_SMALLINT', 'SQL_SMALLINT'],
        ['SQL_FLOAT', 'SQL_FLOAT'],
        ['SQL_REAL', 'SQL_REAL'],
        ['SQL_DOUBLE', 'SQL_DOUBLE'],
        ['SQL_DATE', 'SQL_DATE'],
        ['SQL_TIME', 'SQL_TIME'],
        ['SQL_TIMESTAMP', 'SQL_TIMESTAMP'],
        ['SQL_VARCHAR', 'SQL_VARCHAR'],
        ['SQL_LONGVARCHAR', 'SQL_LONGVARCHAR'],
        ['SQL_BINARY', 'SQL_BINARY'],
        ['SQL_VARBINARY', 'SQL_VARBINARY'],
        ['SQL_LONGVARBINARY', 'SQL_LONGVARBINARY'],
        ['SQL_BIGINT', 'SQL_BIGINT'],
        ['SQL_TINYINT', 'SQL_TINYINT'],
        ['SQL_BIT', 'SQL_BIT'],
        ['SQL_WCHAR', 'SQL_WCHAR'],
        ['SQL_WVARCHAR', 'SQL_WVARCHAR'],
        ['SQL_WLONGVARCHAR', 'SQL_WLONGVARCHAR']
		],
'mysql'    => [
        ['VARCHAR', 'VARCHAR'],
        ['DECIMAL', 'DECIMAL'],
        ['TINYINT', 'TINYINT'],
        ['INT', 'INT'],
        ['SMALLINT', 'SMALLINT'],
        ['INTEGER', 'INTEGER'],
        ['FLOAT', 'FLOAT'],
        ['DOUBLE', 'DOUBLE'],
        ['TIMESTAMP', 'TIMESTAMP'],
        ['BIGINT', 'BIGINT'],
        ['MIDDLEINT', 'MIDDLEINT'],
        ['DATE', 'DATE'],
        ['TIME', 'TIME'],
        ['DATETIME', 'DATETIME'],
        ['YEAR', 'YEAR'],
        ['DATE', 'DATE'],
        ['ENUM', 'ENUM'],
        ['SET', 'SET'],
        ['BLOB', 'BLOB'],
        ['TINYBLOB', 'TINYBLOB'],
        ['MEDIUMBLOB', 'MEDIUMBLOB'],
        ['LONGBLOB', 'LONGBLOB']
		],
'pg'       => [
        ['BOOL', 'BOOL'],
        ['INT8', 'INT8'],
        ['INT2', 'INT2'],
        ['INT4', 'INT4'],
        ['TEXT', 'TEXT'],
        ['FLOAT4', 'FLOAT4'],
        ['FLOAT8', 'FLOAT8'],
        ['ABSTIME', 'ABSTIME'],
        ['RELTIME', 'RELTIME'],
        ['TINTERVAL', 'TINTERVAL'],
        ['MONEY', 'MONEY'],
        ['BPCHAR', 'BPCHAR'],
        ['VARCHAR', 'VARCHAR'],
        ['DATE', 'DATE'],
        ['TIME', 'TIME'],
        ['DATETIME', 'DATETIME'],
        ['TIMESPAN', 'TIMESPAN'],
        ['TIMESTAMP', 'TIMESTAMP']
     ],
'oracle'    => [
        ['LONG_RAW', 'LONG_RAW'],
        ['RAW', 'RAW'],
        ['LONG', 'LONG'],
        ['CHAR', 'CHAR'],
        ['NUMBER', 'NUMBER'],
        ['DOUBLE', 'DOUBLE'],
        ['DATE', 'DATE'],
        ['VARCHAR2', 'VARCHAR2']
     ],
'csv'       => [
        ['VARCHAR', 'VARCHAR'],
        ['CHAR', 'CHAR'],
        ['INTEGER', 'INTEGER'],
        ['REAL', 'REAL'],
        ['BLOB', 'BLOB'],
        ['DATETIME', 'DATETIME'],
        ['TEXT', 'TEXT']
			],
'flff'      => [
        ['VARCHAR', 'VARCHAR'],
        ['CHAR', 'CHAR'],
        ['INTEGER', 'INTEGER'],
        ['REAL', 'REAL'],
        ['BLOB', 'BLOB'],
        ['DATETIME', 'DATETIME'],
        ['TEXT', 'TEXT']
			],
'xml'      => [
        ['VARCHAR', 'VARCHAR'],
        ['CHAR', 'CHAR'],
        ['INTEGER', 'INTEGER'],
        ['REAL', 'REAL'],
        ['BLOB', 'BLOB'],
        ['DATETIME', 'DATETIME'],
        ['TEXT', 'TEXT']
			],
'html'      => [
        ['VARCHAR', 'VARCHAR'],
        ['CHAR', 'CHAR'],
        ['INTEGER', 'INTEGER'],
        ['REAL', 'REAL'],
        ['BLOB', 'BLOB'],
        ['DATETIME', 'DATETIME'],
        ['TEXT', 'TEXT']
			],
'vrac'      => [
        ['VARCHAR', 'VARCHAR'],
        ['CHAR', 'CHAR'],
        ['INTEGER', 'INTEGER'],
        ['REAL', 'REAL'],
        ['BLOB', 'BLOB'],
        ['DATETIME', 'DATETIME'],
        ['TEXT', 'TEXT']
			],
);

sub aldtypes::getdtyplist ($) {
	my ($mnemdbty) = @_;

	return($aldtypes::datatypes{$mnemdbty ? $mnemdbty : 'standard'});

}		
