#!/usr/local/bin/perl
#
# cafUtils.pm 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;

package cafUtils;
 

sub cafdatetime0 {
	my $self = shift;

	my $time = shift || time ();
#  0    1    2     3     4    5     6     7     8
# ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)

	my @now = localtime($time);
	
	$now[4] += 1;
	$now[5] += 1900;
	$now[3] = "0" . $now[3] unless ($now[3] > 9);
	$now[4] = "0" . $now[4] unless ($now[4] > 9);
	$now[0] = "0" . $now[0] unless ($now[0] > 9);
	$now[1] = "0" . $now[1] unless ($now[1] > 9);
	$now[2] = "0" . $now[2] unless ($now[2] > 9);
	
	return wantarray ? @now : \@now;
}

sub datetime1 {
	my $self = shift;
	my $time = shift;

	my @now = $self->cafdatetime0($time);

	return "$now[3]/$now[4]/$now[5] $now[2]:$now[1]:$now[0]";
}

sub datetime2 {
	my $self = shift;
	my $time = shift;

	my @now = $self->cafdatetime0($time);

	return "$now[3]" . "$now[4]" . "$now[5]" . "$now[2]" . "$now[1]" . "$now[0]";
}

sub datetime3 {
	my $self = shift;
	my $time = shift;

	my @now = $self->cafdatetime0($time);

	return "$now[5]/$now[4]/$now[3] $now[2]:$now[1]:$now[0]";
}

sub fdatetime {
	my $self = shift;
	my $format = shift || "YMD--HmS";
	my $time = shift;

	my %fequiv = (Y =>5, y =>6, M =>4, D =>3, H =>2, m =>1, S =>0);
	my @now = $self->cafdatetime0($time);
	$now[6] = $now[5] % 100;
	$now[6] = "0" . $now[6] unless ($now[6] > 9);
	print "$now[6]\n";

	my @f = split ('', $format);
	my $ret = "";
	foreach my $c (@f) {
		if (exists($fequiv{$c})) { $ret .= $now[$fequiv{$c}]; }
		else { $ret .= $c; }
	}
	$ret;
}

sub convdatetime3to2 {
	my $self = shift;
	my $date = shift;

	$date =~ s/^([\d]{4})(.)(\d\d)(.)(\d\d)/$5$2$3$4$1/;
	$date;
}

sub parsedatetime3 {
	my $self = shift;
	my $date = shift;

	require Time::ParseDate;
	Time::ParseDate::parsedate($self->convdatetime3to2($date));
}

sub parseformula {
	my $class = shift;
	my $text = shift;

	my @atext = split(//,$text);
	my $ret = "";
	my $context = "NC";
	my @error;

	for (my $i = 0; $atext[$i]; $i++) {
		my $c = $atext[$i];
		if ($c eq "\\") {
			$ret .= "$c$atext[$i+1]";
			next;
		}
		elsif ($c eq "'") {
			if ($context eq "SQ") { $context = "NC"; }
			else { $context = "SQ"; }
			$ret .= $c;
			next;
		}
		elsif ($c eq '"') {
			if ($context eq "DQ") { $context = "NC"; }
			else { $context = "DQ"; }
			$ret .= $c;
			next;
		}
		elsif ($context ne "NC") { $ret .= $c; next; }
		elsif ($c eq ":") {
			my $chunk = "";
			while (($c = $atext[$i + 1]) && ($c =~ /[_[:alnum:]]/)) { $chunk .= $c; $i++; }
			parseerror(\@error, "CV", 1, $i, $text) if ($chunk !~ /^[cfistgok]_/);
			$ret .= '$self->' . $chunk;
		}
		elsif ($c eq "&") {
			my $chunk = "";
			while (($c = $atext[$i + 1]) && ($c =~ /[_[:alnum:]]/)) { $chunk .= $c; $i++; }
			parseerror(\@error, "FC", 1, $i, $text) if ($chunk !~ /^[[:alpha:]]/);
			$ret .= '$self->' . $chunk;
		}
		else { $ret .= $c; next; }
	}

	return { text => $ret, errors => \@error, nerrors => $#error };
}

sub parseerror {
	my $ar = shift;
	my $context = shift;
	my $l = shift;
	my $c = shift;
	my $lt = shift;

	push @$ar, "Invalid char in $context at line $l char $c : $lt";
	my %contexts = ( BV => "bind variable",
			IV => "inline variable",
			AL => "alias name",
			DQ => "queted string",
			SQ => "simple quote string",
			NC => "NC",
			CV => "Cafeterra Var",
			FC => "Function Call",
	);
	print "50001;Invalid char in $contexts{$context} at line $l char $c : $lt\n";
	cafDbg->pusherror("50001;Invalid char in $contexts{$context} at line $l char $c : $lt");
}

sub parsesql {
	my $class = shift;
	my $text = shift;

	my @text = split("", $text);
	my @texts = ();
	my @bindvars = ();
	my @aliases = ();
	my @errors = ();
	my ($lt, $l, $c, $ret, $context, $oldcontext) = ("", 1, 0, {}, "NC", "");
	my $chunk = "";
	my $from;

	my $iparsed = -1;

	for (my $i = 0; $i <= $#text; $i++) {
		$c++;
		$lt .= $text[$i];

		if (!$from) {
			if (($text[$i] =~ /F/i) and ($text[$i+1] =~ /R/i) and ($text[$i+2] =~ /O/i) and ($text[$i+3] =~ /M/i)) {
				$from="from";
			}
		}
		if (($text[$i] eq "#") and ($c == 1)) { # comments
			while ($text[$i] ne "\n") { $i++; }
			$l++;
			$lt = "";
			$c = 0;
		}
		elsif ($text[$i] eq "\\") {
			if (index (";BV;IV;AL", $context) > 0) {
				parseerror(\@errors, $context, $l, $c, $lt);
			}
			$i++; $chunk .= $text[$i]; next;
			$c++; $lt .= $text[$i];
		}
		elsif ($text[$i] eq ":") { 
			if ($context eq "NC") {
				push @texts, {type => $context, content => $chunk}; $chunk = "";
				$i++;
				while ($text[$i] =~ /[_[:alnum:]]/) { $chunk .= $text[$i]; $c++; $i++}
				$i--;
				if ($chunk !~ /^[cfistgok]_/) {  parseerror(\@errors, "BV", $l, $c, $lt); }
				push @texts, { type => "BV", content => $chunk, };
				push @bindvars, $chunk;
				$context = "NC"; $chunk = "";
			}
			elsif (($context ne "SQ") and ($context ne "DQ")) { parseerror(\@errors, $context, $l, $c, $lt); }
			else { $chunk .= $text[$i]; }
		}
		elsif ($text[$i] eq "\$") {
			if (($context eq "NC") or ($context eq "SQ") or ($context eq "DQ")) { #begining of inline Var
				$oldcontext = $context;
				push @texts, {type => "NC", content => $chunk}; $chunk = ""; $context = "IV";

				$i++;
				while ($text[$i] =~ /[_[:alnum:]]/) { $chunk .= $text[$i]; $c++; $i++}
				$i--;
				if ($chunk !~ /^[cfistgok]_/) {  parseerror(\@errors, "IV", $l, $c, $lt); }
				push @texts, { type => "IV", content => $chunk, }; $chunk = ""; $context = $oldcontext;
			}
			else { parseerror(\@errors, $context, $l, $c, $lt); }
		}
		elsif ($text[$i] eq "@") { 
			if (($context eq "NC") and (!$from)) { #begining of Alias
				push @texts, {type => $context, content => $chunk}; $chunk = ""; $context = "AL";

				$i++;
				while ($text[$i] =~ /[_[:alnum:]]/) { $chunk .= $text[$i]; $c++; $i++}
				$i--;
				if ($chunk !~ /^[cfistgok]_/) {  parseerror(\@errors, "AL", $l, $c, $lt); }
				push @aliases, $chunk; $chunk = ""; $context = "NC";
			}
			#else { parseerror(\@errors, $context, $l, $c, $lt); }
			elsif (($context ne "SQ") and ($context ne "DQ") and (! $from)) { parseerror(\@errors, $context, $l, $c, $lt); }
			else { $chunk .= $text[$i]; }
		}
		elsif ($text[$i] eq "'") {
			$chunk .= $text[$i];
			if ($context eq "SQ") { $context = "NC"; }
			elsif (($context ne "NC") and ($context ne 'DQ')) { parseerror(\@errors, $context, $l, $c, $lt); }
			else { $context = "SQ"; }
		}
		elsif ($text[$i] eq '"') {
			$chunk .= $text[$i];
			if ($context eq "DQ") { $context = "NC"; }
			elsif (($context ne "NC") and ($context ne 'SQ')) { parseerror(\@errors, $context, $l, $c, $lt); }
			else { $context = "DQ"; }
		}
		else {
			if ($text[$i] eq "\n") {
				$l++;
				$lt = "";
				$c=0;
			}
			$chunk .= $text[$i];
			if (index (";BV;IV;AL", $context) > 0) {
				my $invalid = $chunk ? ($text[$i] !~ /[a-zA-Z0-9._]/) : ($text[$i] !~ /[a-zA-Z]/);
				if ($invalid) { parseerror(\@errors, $context, $l, $c, $lt); }
			}
		}
	}
	if ($chunk) {
		if ($context eq "IV") { push @texts, {type => $context, content => $chunk}; }
		elsif ($context eq "BV") { push @bindvars, $chunk; }
		elsif ($context eq "AL") { push @aliases, $chunk; }
		else { push @texts, {type => "NC", content => $chunk}; }
	}

	if ($#errors >= 0) {
		$ret = { nerrors => $#errors + 1, errors => \@errors, };
	}
	else {
		$ret = {
			text => \@texts,
			bindvars => \@bindvars,
			aliases  => \@aliases,
		}
	}
	return $ret;
}

sub generateperl {
	my $class = shift;
	$class = ref($class) || $class;
	my $scripttype = shift;
	my $relatedobject = shift;
	my $translator = shift;

	if ($scripttype eq 'onerror') {
		return '# OnError script 
#Possible return Codes : (string)
# HALTE
# SKIP
# RETRYLATER
# STOP
# DEFAULT or undef

	my $self = shift;
	my $code = "DEFAULT";

	return $code;
';

	}
	elsif ($scripttype eq 'ftransform') {
		return '# Field transformation script 
# Must return a value to assign to the field
#	use undef to NULLIFY the field

	my $self = shift;

	my $value;


	return $value;
';
	}
	else {
		return '# ' . $scripttype . ' script
#
#
	my $self = shift;

';
	}
}
1;
