#!/usr/local/bin/perl
#
# MMsg.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use Time::ParseDate;

use strict;
package MMsg;

@MMsg::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "objectlabel", },
	{ fName => "parent_id" },
	{ fName => "rt_status" },
	{ fName => "object_id" },
	{ fName => "type"},
	{ fName => "status_date"},
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $currpage = $self->_hiddenvar ("_currpage");
	if (($currpage eq 'sflowl') and ($curraction eq 'search')) { $curraction = 'searchs'; }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;


	my $idstr;
	if ($self->_hiddenvar ("_curraction") eq "edit") {
		$idstr = $cgi->param("_objectid");
	}
	else {
		$idstr = $cgi->param("_flow_subflow_id") if ($cgi->param("_currpage") eq $self->_hiddenvar("_prevpage"));
		$idstr = $cgi->param("_objectid") unless ($idstr);
	}
#	print "$idstr <BR>";
	$self->_hiddenvar("_flow_subflow_id", $idstr);
#	$idstr =~ s/-/;/g;
#	$idstr =~ s/;;/;-/g;
#	$idstr =~ s/^;/-/;
	my $flow_id = $idstr;
	my $subflow_id = $idstr;
	my $msgseq = $idstr;
	$flow_id =~ s/^([-[:digit:]]+);.*/$1/;
	$subflow_id =~ s/^[-[:digit:]]+;([-[:digit:]]+).*$/$1/;
	$subflow_id = undef unless($flow_id != $subflow_id);

        $flow_id = undef unless ($flow_id =~ /^[[:digit:]]*$/);
        $subflow_id = undef unless ($subflow_id =~ /^[[:digit:]]*$/);

	$msgseq =~ s/^[-[:digit:]]+;[-[:digit:]]+;([[:digit:]]+)$/$1/;
	$msgseq = undef unless ($msgseq =~ /^[[:digit:]]*$/);
#	print "$idstr flow_id $flow_id / subflow_id $subflow_id / msgseq $msgseq<BR>";
	$self->_datavar("object_id", $flow_id) unless ($self->_datavar("object_id"));

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	if ($actiondetail eq "search") {
		$actiondetail = $self->_hiddenvar ("_actiondetail", "bottom");
	}

	if ($flow_id and $subflow_id) {
		$self->{search1} = $subflow_id;
	}
	if ($flow_id) {
		$self->{search1} = $flow_id;
	}
	else {
		($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
		$self->{search1} = undef unless ($self->{search1} =~ /^[[:digit:]]*$/);
		($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
		$flow_id = $self->{search1};
	}

	my $d = Time::ParseDate::parsedate($cgi->param("search3"), UK => 1);
	$d = undef unless ($d =~ /^[[:digit:]]*$/);
	$d = cafUtils->datetime1($d) if ($d);
	$self->{search3} = $d;

	my $d = Time::ParseDate::parsedate($cgi->param("search4"), UK => 1);
	$d = undef unless ($d =~ /^[[:digit:]]*$/);
	$d = cafUtils->datetime1($d) if ($d);
	$self->{search4} = $d;

	my $query;
	if ($flow_id) {
		$query = $dbh->newquery({ object_id => $flow_id });
		$query->sflowlist();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_flow} = $row;
	}
	if ($subflow_id) {
		$query = $dbh->newquery({ object_id => $subflow_id });
		$query->ssubflowlist();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_subflow} = $row;
	}
	else {
		$self->{_subflow} = {object_id => 0};
	}


	my ($tableprefix, $mastertable, $datatable);
	my ($itableprefix, $imastertable, $idatatable);
	if (($self->{_subflow}{flowdirection} eq "incom") or (! $subflow_id)) {
		$tableprefix = sprintf("z%s_%08.8d", substr($conf->{contextid},0,4), $flow_id);
		$mastertable = $tableprefix . "_i";
		$datatable = $tableprefix . "_id";
	}
	else {
		$tableprefix = sprintf("z%s_%08.8d", substr($conf->{contextid},0,4), $subflow_id);
		$mastertable = $tableprefix . "_o";
		$datatable = $tableprefix . "_od";

		$itableprefix = sprintf("z%s_%08.8d", substr($conf->{contextid},0,4), $self->{_subflow}{flow_id});
		$imastertable = $itableprefix . "_i";
		$idatatable = $itableprefix . "_id";
	}

	my $cond = [];
	my $icond = -1;

	if ($self->{search3}) { $cond->[++$icond] = [ "msgdate", ">=", $self->{search3}, "date", "DD/MM/YYYY HH24:MI:SS" ]; }
	if ($self->{search4}) { $cond->[++$icond] = [ "msgdate", "<=", $self->{search4}, "date", "DD/MM/YYYY HH24:MI:SS" ]; }
	if ($msgseq) { $cond->[++$icond] = [ "msgseq", "=", $msgseq ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ($mastertable, $cond);
	
	my $qAtt = {
		mastertable => $mastertable,
		datatable => $datatable,
		ge_msgdate => $self->{search3},
		le_msgdate => $self->{search4},
		msgseq   => $msgseq,
	};
	my $query = $dbh->newquery($qAtt);
	$query->smastertable();

	my $row = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	if ($row) {
		my @msgids;
		foreach my $r (@$row) {
			push (@msgids, $r->{msgseq});
		}
		$query = $dbh->newquery({ msgseq => \@msgids, mastertable => $mastertable, datatable => $datatable, });
		$query->sdatatable();
		my $rows = $dbh->hexecfetchall($query);
		my $msgid = undef;
		my $imsg = -1;
		my @msgs;
		my $ifld = 1;
		foreach my $r (@$rows) {
			if ($msgid != $r->{msgseq}) {
				$imsg++; $msgs[$imsg] = $r;
				#$msgs[$imsg]->{$r->{field_id}} = $r->{field_value};
				$msgs[$imsg]->{field_values} = [ { field_id => $r->{field_id}, field_value => $r->{field_value} } ];
				$ifld = 1;
				$msgs[$imsg]->{_msgdata} = "$r->{field_id} = $r->{field_value}";
				$msgid = $r->{msgseq};
			}
			else {
				#$msgs[$imsg]->{$r->{field_id}} = $r->{field_value};
				$msgs[$imsg]->{field_values}[$ifld] = { field_id => $r->{field_id}, field_value => $r->{field_value} };
				$ifld++;
				$msgs[$imsg]->{_msgdata} .= "|$r->{field_id} = $r->{field_value}";
			}
		}
		$self->{_list1} = \@msgs;
		$self->{_message} = $msgs[0];
		if ($self->{_subflow}{flowdirection} eq "outgo") {
			my $imsgid = $msgs[0]->{inmsgseq};
			$query = $dbh->newquery({ msgseq => $imsgid, mastertable => $imastertable, datatable => $idatatable, });
			$query->sdatatable();
			$rows = $dbh->hexecfetchall($query);

			my @imsg;
			$self->{_imessagecount} = 0;
			foreach my $r (@$rows) {
				last unless ($imsgid == $r->{msgseq});
				$self->{_imessagecount} += 1;
				push @imsg, { field_id => $r->{field_id}, field_value => $r->{field_value} };
			}
			$self->{_imessage} = \@imsg;
		}
			
	}

	# monitoring refreshing
	$self->_monitorvar("refresh", $cgi->param("refreshinterval"));

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "$idstr") if ($flow_id);
	$self->_setnavinfo("list1");
}

sub meth_edit {
	meth_search(@_);
}
sub xmeth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_systemvar("_miscinfo_", '_miscinfo_');
	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	my $flow_id;
	my $subflow_id;
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("type", 'flow');
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));
	$self->_hiddenvar ("search3", $cgi->param("search3"));
	$self->_hiddenvar ("search4", $cgi->param("search4"));

	my $idstr = $cgi->param("_flow_subflow_id");
	$self->_hiddenvar("_flow_subflow_id", $idstr);
	$self->_hiddenvar("_objectid", $idstr);
	$self->_hiddenvar("object_id", $cgi->param("object_id"));

	$actiondetail = $self->_hiddenvar ("_actiondetail");

	my $query = $dbh->newquery({ error_id => $cgi->param("object_id") });
	$query->swrunerrorslist();

	$self->{_data} = $dbh->hexecfetchrow($query, 1);
	$flow_id = $self->{_data}{object_id};

	if ($flow_id) {
		my $query = $dbh->newquery({ object_id => $flow_id });
		$query->sobject ();
		my $row = $dbh->hexecfetchrow($query, 1);
		if ($row->{type} eq 'subflow') {
			$query->ssubflowlist ();
			$row = $dbh->hexecfetchrow($query, 1);
			$self->{_subflow} = $row; # || {};

			$query = $dbh->newquery({ object_id => $row->{parent_id} });
			$query->sflowlist ();
			$row = $dbh->hexecfetchrow($query, 1);
			$self->{_flow} = $row; # || {};
		}
		elsif ($row->{type} eq 'flow') {
			$query->sflowlist ();
			$row = $dbh->hexecfetchrow($query, 1);
			$self->{_flow} = $row; # || {};
		}
	}

}

1;
