--
-- Selected TOC Entries:
--
--
-- TOC Entry ID 2 (OID 1960791)
--
-- Name: objects Type: TABLE Owner: aliphe
--

CREATE TABLE objects (
	id integer NOT NULL,
	type character varying(20) NOT NULL,
	name character varying(50) NOT NULL,
	parent_id integer DEFAULT -1 NOT NULL,
	created timestamp with time zone DEFAULT now() NOT NULL,
	modified timestamp with time zone DEFAULT now() NOT NULL,
	deleted timestamp with time zone,
	comments character varying(255),
	status character varying(20) DEFAULT 'online',
	createdby character varying,
	modifiedby character varying,
	objectlabel character varying(100),
	Constraint objects_pkey Primary Key (id)
);

--
-- TOC Entry ID 3 (OID 1960791)
--
-- Name: createdby_objects_key Type: INDEX Owner: aliphe
--

CREATE  INDEX createdby_objects_key on objects using btree ( createdby varchar_ops );

--
-- TOC Entry ID 4 (OID 1960791)
--
-- Name: objectlabel_objects_key Type: INDEX Owner: aliphe
--

CREATE  INDEX objectlabel_objects_key on objects using btree ( objectlabel varchar_ops );

--
-- TOC Entry ID 5 (OID 1960791)
--
-- Name: objects_ukey1 Type: INDEX Owner: aliphe
--

CREATE UNIQUE INDEX objects_ukey1 on objects using btree ( name varchar_ops, parent_id int4_ops, type varchar_ops );

