#!/usr/local/bin/perl
#
# SFlowRt.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
 
package SFlowRt;
 
@ISA = ('FlowRt');

use strict;
 
sub CallBack {

}


#sub CloseSubFlow {
#
#TO DO
#
#}


sub StartSubFlow {
	my $this = shift;
	my $class = ref($this) || $this;
	my $myId = shift;
	my $dir = shift;
	my $self;

	if (ref($this) and ($this->MyId() == $myId)) { $this->{status} = {}; $self = $this;}
	else {
		$self = { myId => $myId, direction => $dir, status => {}, };

		bless $self, $class;
	}

	my $objHier = $self->ObjectHierarchy();
	my $subFlow = $objHier->getdata($self->MyId());
	$self->KeepAlive($subFlow->{keepalive});
	$self->MailOnError($subFlow->{keepalive});
	$self->MailOnSuccess($subFlow->{mailonerr});
	$self->MailOnSuccess($subFlow->{mailonsucc});
	$self->OnErrorAction($subFlow->{onoutgoerr});
	$self->MyFlowMethod($subFlow->{flowmethod});
	return (undef) unless($self->CanIRun());

#	$self->OpenExternalDb();
	$self;
}

sub MyFlowMethod {
	my $self = shift;

	if (@_) { $self->{MyFlowMethod} = shift; }
	$self->{myFlowMethod};
}

sub MailOnError {
	my $self = shift;

	return @_ ? $self->{mailOnError} = shift : $self->{mailOnError};

#	my $context = $self->MyContext();
#	if (@_) {
#		$self->{mailOnError} = shift;
#		if ($self->{mailOnError} ne "yes") { $self->{mailOnError} = undef; }
#	}
#	return $self->{mailOnError} ? $context->{adminmail} : undef;
}

sub MailOnSuccess {
	my $self = shift;

	return @_ ? $self->{mailOnError} = shift : $self->{mailOnSuccess};

#	if (@_) {
#		$self->{mailOnSuccess} = shift;
#		if ($self->{mailOnSuccess} ne "yes") { $self->{mailOnSuccess} = undef; }
#	}
#	return $self->{mailOnSuccess} ? $context->{adminmail} : undef;
}

sub KeepAlive {
	my $self = shift;

	if (@_) {
		$self->{keepAlive} = shift;
		if ($self->{keepAlive} ne "yes") { $self->{keepAlive} = undef; }
	}
	return $self->{keepAlive};
}

sub ClosedSubFlow {
	my $self = shift;

	$self->{status}{closed} = shift if (@_);
	$self->{status}{closed};

}

sub CloseSubFlow {
	my $self = shift;
	my $force = shift;

	$self->BeforeClose();

	$self->LogSysTrace("CloseSubFlow ". $self->MyId() . " KeepAlive = " . $self->KeepAlive());
	if ($force || (! $self->KeepAlive())) {
		$self->BeforeDisconnect();
		$self->CloseExternalDb();
		$self->AfterDisconnect();
		$self->ClosedSubFlow(1);
		
	}
	else { $self->ClosedSubFlow(undef); }
	$self->{QUERIESH} = {};
	$self->AfterClose();
	$self->IFinished();
	if ($force || (! $self->KeepAlive())) { return "closed" }
	else { "stillopen"; }
}

sub OpenExternalDb {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();
	return $dbh if ($dbh);

	$self->PushContext("OpenExternalDb");

	my $objHier = $self->ObjectHierarchy();
	my $subFlow = $objHier->getdata($self->MyId());

	my $container = $objHier->getdata($subFlow->{container_id});
	$self->BeforeConnect ();
	my $db = $self->GetExternalDbHash ($container->{parent_id});
	$dbh = $self->GetExternalDbh(refDBI->ExtConnect($db));

	$self->AfterConnect ();
	$self->PopContext("OpenExternalDb");

	return $dbh;
}

sub CloseExternalDb {
	my $self = shift;

	$self->LogSysTrace("CloseExternalDb ". $self->MyId());
	my $dbh = $self->GetExternalDbh();
	return 1 unless ($dbh);

	$self->PushContext("CloseExternalDb");

	$self->BeforeDisconnect();

	$dbh->disconnect();

	$self->GetExternalDbh(undef);

	$self->AfterDisconnect();
	$self->PopContext("CloseExternalDb");

}

sub BeforeConnect {
	my $self = shift;

	$self->RunScriptByStep('sbconnect');
}

sub AfterConnect {
	my $self = shift;

	$self->RunScriptByStep('saconnect');
}

sub BeforeDisconnect {
	my $self = shift;

	$self->RunScriptByStep('sbdiscon');
}

sub AfterDisconnect {
	my $self = shift;

	$self->RunScriptByStep('sadiscon');
}

sub BeforeOpen {
	my $self = shift;

	return "0E0" if ($self->{status}{opened}); 
	my $ret = $self->RunScriptByStep('sbopen');
	$self->{status}{opened} = "openning"; 
	return $ret;
}

sub AfterOpen {
	my $self = shift;

	return "0E0" if ($self->{status}{opened} eq "opened");
	my $ret = $self->RunScriptByStep('saopen') if ($self->{status}{opened});
	$self->{status}{opened} = "opened"; 
	return $ret;
}

sub BeforeClose {
	my $self = shift;

	my $ret = "0E0" if (!$self->{status}{opened} or $self->{status}{closed});
	$ret = $self->RunScriptByStep('sbclose');
	$self->{status}{opened} = undef;
	$self->{status}{closed} = "closing";
	$ret;
}

sub AfterClose {
	my $self = shift;

	my $ret = "0E0" if ($self->{status}{opened} ne "closing");
	$ret = $self->RunScriptByStep('saclose') if ($self->{status}{opened});
	$self->{status}{closed} = undef;
	$ret;
}

sub BeforeRead {
	my $self = shift;

	$self->RunScriptByStep('sbread');
}

sub AfterRead {
	my $self = shift;

	$self->RunScriptByStep('saread');
}

sub BeforeWrite {
	my $self = shift;

	$self->RunScriptByStep('sbwrite');
}

sub AfterWrite {
	my $self = shift;

	$self->RunScriptByStep('sawrite');
}

sub BeforeTransformation {
	my $self = shift;

	return "0E0" if ($self->{status}{transformed}); 
	$self->RunScriptByStep('sbtransf');
	$self->{status}{transformed} = "transformed";
}

sub TransformMsg {
	my $self = shift;

	$self->PushContext("transformmsg");
	$self->RunScriptByStep('stransform');
	$self->PopContext("transformmsg");
	$self->FieldsTransformation();
}

sub AfterTransformation {
	my $self = shift;

	$self->RunScriptByStep('satransf') if ($self->{status}{transformed});
	$self->{status}{transformed} = undef;
}

sub FormatField {
	my $self = shift;
	my $direction = shift;
	my $oField = shift;
	my $iField = shift;
	my $value = shift;

	foreach my $f ("rpad","lpad","rtrim","ltrim","trim","maj","min") {
		my $F = uc ($f);
		if ($oField->{dataformat} =~ /^$F/) {
			my $func = "Format_$f";
			my $oFormat = substr($oField->{dataformat}, length($f));
			my $oMaxLen = $oField->{datalength};
			my $result = $self->$func($value, $oMaxLen, $oFormat);
			if ($direction = "outgo") { $self->OutgoFieldValue($oField->{name}, $result); }
			elsif ($direction = "incom") { $self->IncomFieldValue($oField->{name}, $result); }
			return;
		}

	}

	my $numTypes = "|SQL_NUMERIC|SQL_DECIMAL|SQL_INTEGER|SQL_SMALLINT|SQL_FLOAT|SQL_REAL|SQL_DOUBLE|";
	if ($numTypes =~ /$oField->{datatypeid}/) {
		my $result = $self->Format_tonumber($value, $oField->{dataformat});
		if ($direction = "outgo") { $self->OutgoFieldValue($oField->{name}, $result); }
		elsif ($direction = "incom") { $self->IncomFieldValue($oField->{name}, $result); }
		return;
	}

	if ($iField and ($direction = "outgo") and ("|SQL_DATE|SQL_TIMESTAMP|" =~ /$oField->{datatypeid}/)) {
		my $result = $self->Format_todate($value, $iField->{dataformat}, $oField->{dataformat});
		$self->OutgoFieldValue($oField->{name}, $result);
	}
}

	
sub FieldsTransformation {
	my $self = shift;

	my $objHier = $self->ObjectHierarchy();
	my $fieldsTrans = $self->MyMappingList();
	my $mappedFields = $fieldsTrans->{__MAPPEDFIELDS__};
	my @mappedFields;
	@mappedFields = @{$mappedFields} if ($mappedFields and ($#$mappedFields >= 0));
	my $direction = $self->FlowDirection();
	foreach my $fldId (@mappedFields) {
		my $rightValue;
		my $trans = $fieldsTrans->{$fldId};
		my $leftField = $objHier->getobject($trans->{outgofield_id});
		my $leftName = $self->ObjectNameById($trans->{outgofield_id});
		if ($trans->{incomfield_id} and ($direction = "outgo")) {
			my $rightName = $self->ObjectNameById($trans->{incomfield_id});
			$rightValue = $self->OutgoFieldValue($leftName, $self->IncomFieldValue($rightName));
		}

		if ($trans->{pformula}) {
			$rightValue = $self->RunFormula($trans->{outgofield_id});
			if ($direction = "outgo") { $self->OutgoFieldValue($leftName, $rightValue); }
			elsif ($direction = "incom") { $self->IncomFieldValue($leftName, $rightValue); }
		}
		if ($trans->{script_id}) {
			$rightValue = $self->RunScriptById($trans->{script_id});
			if ($direction = "outgo") { $self->OutgoFieldValue($leftName, $rightValue); }
			elsif ($direction = "incom") { $self->IncomFieldValue($leftName, $rightValue); }
		}

		if ($leftField->{dataformat}) {
			$self->FormatField($direction, $leftField, $objHier->getobject($trans->{incomfield_id}), $rightValue);
		}
	}
	$self->PopContext("fieldtransformation");
}

sub OpenQuery {
	my $self = shift;
	my $dbh = shift;
	my $qlabel = shift;

	my $qryh;
	unless ($qryh = $self->{QUERIESH}{$qlabel}) {
		$qryh = $dbh->newqueryfromhash($self->GetQueryByStep($qlabel));
		$self->{QURIESH}{$qlabel} = $qryh;
	}

	unless ($qryh->_attribute("sth")) {
		$self->BeforeOpen();
		$dbh->execute($qryh);
		$self->AfterOpen();
	}

	$qryh;
}

sub ParseIncomColsValues {
	my $self = shift;
	my $row = shift;
	my $query = shift;

	if ($row) {
#		$self->LogSysTrace("ParseIncomColsValues = ROW = " . join(' *', @$row));
		my $columnsAliases = $query->columns();
		for (my $i = 0; $i <= $#$columnsAliases; $i++) { $self->ParseVarName($columnsAliases->[$i], $row->[$i]); }
	}
	else { $self->LastRow(1); }

	$self->AfterRead();
	$self->BeforeTransformation();
	$self->TransformMsg();

}

sub FinishGetNextMessage {
	my $self = shift;
	my $query = shift;
	my $dbh = shift;

	$self->AfterTransformation();
	$self->BeforeClose();
	$self->LogSysTrace("GetNextMessage Finishing Query $dbh For " . $self->MyId());
	$dbh->finish($query);
	$self->ClearIncomFields();
}

sub AknowledgeMessageOk {
	my $self = shift;
	@_ ? $self->{status}{AknowledgeMessageOk} = shift : $self->{status}{AknowledgeMessageOk};
}

sub ProcessPostLastRow {
	my $self = shift;

	@_ ? $self->{status}{ProcessPostLastRow} = shift : $self->{status}{ProcessLastRow};
}

sub LastRow {
	my $self = shift;

	@_ ? $self->{status}{LastRow} = shift : $self->{status}{LastRow};
}

sub GetNextMessage {
	my $self = shift;

	my $query;
	$self->PushContext("getnextmessage");
	my $dbh = $self->GetExternalDbh();
	my $ret;
#	$self->LogSysTrace("GetNextMessage ");
	unless ($query = $self->{QUERIESH}{getmsg}) {
		$self->BeforeOpen();
		my $queryText = $self->GetQueryByUsedFor ("getmsg");
#		$self->LogSysTrace(" ==========================\n      THE GETMSG QUERY\n===================" .$queryText);
		$query = $self->{QUERIESH}{getmsg} = $dbh->newqueryfromhash($queryText);

		my @bindVars = ();

		my $bindVarLabels = $query->bindvarlabels();
		foreach my $bindVarLabel (@$bindVarLabels) {
			push @bindVars, $self->ParseVarName($bindVarLabel);
		}
		$query->bindvars(\@bindVars);
#	print STDERR "GetNextMessage $dbh BVL ", $query->query(), " : ", join (" - ", @$bindVarLabels), "\n\tGetNextMessage BV : ", join (" - ", @bindVars), "\n";
		eval {
			$ret = $dbh->execute($query);
		};
		if ($@) { $self->OnError($@); return undef; }
		$self->AfterOpen();
	}

	if ($self->LastRow()) { $self->FinishGetNextMessage($query, $dbh); return undef; }
	$self->BeforeRead();
	my $row;
	$self->AknowledgeMessageOk(1);
	eval {
		$row = $dbh->fetchrownop($query);
	};
	if ($@) { $self->OnError($@); return undef; }
	
	if ($row || $self->ProcessPostLastRow()) { $self->ParseIncomColsValues($row, $query); $ret = 1}
	else { $self->FinishGetNextMessage($query, $dbh); $ret = undef; }

=comment
# BEGIN 25/07/2003
# Create the lastrow function this code is now processed by 2 func : ParseIncomColsValues and FinishGetNextMessage
	my $columnsAliases = $query->columns();
	if ($row) {
#		print STDERR "ROW READ \n";
		for (my $i = 0; $i <= $#$columnsAliases; $i++) { $self->ParseVarName($columnsAliases->[$i], $row->[$i]); }
		$self->AfterRead();
		$self->BeforeTransformation();
		$self->TransformMsg();
	}
	else { # Termine
		$self->AfterTransformation();
		$self->BeforeClose();
		$self->LogSysTrace("GetNextMessage Finishing Query $dbh For " . $self->MyId());
		$dbh->finish($query);
		$self->ClearIncomFields();
		#for (my $i = 0; $i <= $#$columnsAliases; $i++) { $self->ParseVarName($columnsAliases->[$i], undef); }
	}
	$self->PopContext("getnextmessage");
	$row ? 1 : undef;
# END 25/07/2003
=cut
	$self->PopContext("getnextmessage");
	$ret;
}

sub AcknowledgeMsg {
	my $self = shift;

	my $ackType;
	return 1 unless ($ackType = $self->AknowledgeMessageOk());
	my $queryText;
# aziz 31/07/2003 Added support for user to assign the query for assignement, otherwise use defaulted
	$queryText = $self->GetQueryByUsedFor("ackmsg") unless ($queryText = $self->GetQueryByStep ($ackType));
	return 1 unless ($queryText and $queryText->{mylabel});
	my $dbh = $self->GetExternalDbh();
	my $query = $dbh->newqueryfromhash($queryText);

	my @bindVars = ();

	my $bindVarLabels = $query->bindvarlabels();
	foreach my $bindVarLabel (@$bindVarLabels) {
		push @bindVars, $self->ParseVarName($bindVarLabel);
	}
	$query->bindvars(\@bindVars);

	$dbh->executefinish($query);
}
	
sub GlobalAck{
	my $self = shift;

	$self->LogSysTrace("GlobalAck");
	my $queryText = $self->GetQueryByUsedFor("globalack");
	return 1 unless ($queryText and $queryText->{mylabel});
	my $dbh = $self->GetExternalDbh();
	my $query = $dbh->newqueryfromhash($queryText);

	my @bindVars = ();

	my $bindVarLabels = $query->bindvarlabels();
	foreach my $bindVarLabel (@$bindVarLabels) {
		push @bindVars, $self->ParseVarName($bindVarLabel);
	}
	$query->bindvars(\@bindVars);

	$dbh->executefinish($query);
}

sub xxLogIncomMessage {
	my $self = shift;

	my $fNames;
	return 1 unless ($fNames = $self->IncomFieldNames());

	my $dbh = $self->QueueDbh();
	my $dbhA = $self->QueueDbhAutocommit();
	my $tablePrefix = $self->GenIncomTableName();
	my $masterTable = $tablePrefix . "_i";
	my $dataTable = $tablePrefix . "_id";
	$self->LogSysTrace("LogIncomMessage tablePrefix $tablePrefix");
	my $msgseq = $dbhA->nextseq($tablePrefix);

	my $query = $dbh->newquery({ msgseq => $msgseq, tablename => $masterTable });
	
	$query->iincommsg();
	$dbh->executefinish($query);

	foreach my $fldname (@$fNames) {
		my $fldvalue = $self->IncomFieldValue($fldname);
		if (defined($fldvalue)) {
			my $query2 = $dbh->newquery({ msgseq => $msgseq, tableprefix => $dataTable, field_id => $fldname, field_value => $fldvalue });
			$query->iincommsgdata();
			$dbh->executefinish($query);
		}
		$self->OurCurrIncomMsgId($msgseq);
	}
}

sub LogTransformedMsg {
	my $self = shift;

	my $fNames;
	return 1 if ($self->DirectFlow());
	return 1 unless ($fNames = $self->OutgoFieldNames());

	my $inmsgseq = $self->OurCurrIncomMsgId();
	my $dbh = $self->QueueDbh();
	my $dbhA = $self->QueueDbhAutocommit();
	my $tablePrefix = $self->GenOutgoTableName();
	my $masterTable = $tablePrefix . "_o";
	my $dataTable = $tablePrefix . "_od";
#	print "LogTransformedMsg tablePrefix $tablePrefix \n";
	my $msgseq = $dbhA->nextseq($tablePrefix);

	my $query = $dbh->newquery({ msgseq => $msgseq, inmsgseq => $inmsgseq, mastertable => $masterTable });
	
	$query->itransformedmsg();
	$dbh->executefinish($query);

#	$self->LogSysTrace("LogTransformedMsg - Sequence is $msgseq for incom $inmsgseq $fNames $#$fNames");
	foreach my $fldname (@$fNames) {
		my $fldvalue = $self->OutgoFieldValue($fldname);
#		$self->LogSysTrace("LogTransformedMsg : $fldname ========== $fldvalue");
		if (defined($fldvalue)) {
			my $msgdata = {
				msgseq => $msgseq,
				field_id => $fldname,
				field_value => $fldvalue,
				datatable => $dataTable,
			};
			my $query2 = $dbh->newquery($msgdata);
			$query2->itransformedmsgdata();
			$dbh->executefinish($query2);
		}
	}
	$self->MyCurrIncomMsgId($inmsgseq);
	$self->MyCurrTransformedMsgId($msgseq);
	$self->IncTransformsCount();
}

sub LogSentMsg {
	my $self = shift;

	return 1 if ($self->DirectFlow());
	return 1 if ($self->SkipMessage() || $self->RetryLater());
	my $msgseq = $self->MyCurrTransformedMsgId();
	
	my $dbh = $self->QueueDbh();
	my $tablePrefix = $self->GenOutgoTableName();
	my $masterTable = $tablePrefix . "_o";
	my $query = $dbh->newquery({ msgseq => $msgseq, mastertable => $masterTable, msgstatus => "sent" });
	
	$query->usentmsg();
	$dbh->executefinish($query);
	$self->MyCurrSentMsgId($msgseq);
	$self->IncOutgosCount();
}

sub ExecuteSendQuery {
	my $self = shift;
	my $dbh = shift;
	my $which = shift;
	my $type = shift || "usedfor";

	my $queryText;
#	print STDERR "ExecuteSendQuery $dbh $which / $type\n";
#	$self->LogSysTrace("ExecuteSendQuery $which $type : STARTED - PREPARING");
	if ($type eq "usedfor") { $queryText = $self->GetQueryByUsedFor ($which); }
	elsif ($type eq "step") { $queryText = $self->GetQueryByStep ($which); }
	elsif ($type eq "name") { $queryText = $self->GetQueryByName ($which); }
	elsif ($type eq "id") { $queryText = $self->GetQueryById ($which); }

	return 0 unless ($queryText);
	my $query = $dbh->newqueryfromhash($queryText);

	my @bindVars = ();

#	$self->LogSysTrace("ExecuteSendQuery $which $type : STARTED - BIDVARIABLES FOR : " . $query->query());
	my $bindVarLabels = $query->bindvarlabels();
	foreach my $bindVarLabel (@$bindVarLabels) {
		push @bindVars, $self->ParseVarName($bindVarLabel);
#		$self->LogSysTrace("ExecuteSendQuery $which $type : STARTED - BIDVARIABLES : $bindVarLabel => " .  $self->ParseVarName($bindVarLabel));
	}
#	print STDERR "ExecuteSendQuery $dbh BVL $which : ", $query->query(), " : ", join (" - ", @$bindVarLabels), "\nExecuteSendQuery BV : ", join (" - ", @bindVars), "\n";
	$query->bindvars(\@bindVars);
	
	#print "calling executefinish\n";
	#<STDIN>;
#	print "ExecuteSendQuery $dbh\n";
#	$self->LogSysTrace("ExecuteSendQuery $which $type : STARTED - EXECUTING with : " . join (" -", @bindVars));
#	$dbh->trace();
	my $ret = $dbh->executefinish($query);
	$dbh->untrace();
#	$self->LogSysTrace("ExecuteSendQuery $which $type : ENDED");
	$ret;
}

sub SendMsg {
	my $self = shift;

	$self->PushContext("sendmsg");
	my $dbh = $self->GetExternalDbh();
#	$self->LogSysTrace(print "SendMsg $dbh");

	my $action;
	my $type;
	if ($action = $self->UserDefinedAction("step")) { $type = "step"; }
	elsif ($action = $self->UserDefinedAction("name")) { $type = "name"; }
	elsif ($action = $self->UserDefinedAction("id")) { $type = "id"; }
	else { $action = "sendmsg"; $type = "usedfor"; }

	my $ret = 0;
	$self->BeforeOpen();
	eval {
		# $ret = $self->ExecuteSendQuery($dbh,"sendmsg");
		$ret = $self->ExecuteSendQuery($dbh,$action, $type);
	};
	$self->AfterOpen();
	my $e = $@ || "";
#	print "SENDMSG ==> $ret";
	if ($ret == 0) {
		my $method = $self->MyFlowMethod();
		if ($method = /updins|delins|insupd/) {
			if ($action = $self->UserAlternateAction("step")) { $type = "step"; }
			elsif ($action = $self->UserAlternateAction("name")) { $type = "name"; }
			elsif ($action = $self->UserAlternateAction("id")) { $type = "id"; }
			else { $action = "sendmsgbis"; $type = "usedfor"; }

			eval {
			# $ret = $self->ExecuteSendQuery($dbh,"sendmsgbis");
				$ret = $self->ExecuteSendQuery($dbh,$action, $type);
			};
		}
		if ($@) { $e .= " THEN " . $@; }
		else { $e = undef; }
#		print " SENDMSGBIS ==> $ret";
	}
#	print "\n";
	$self->ClearUserDefinedAction();
	if ($e) { $self->OnError($e); }
	$self->PopContext("sendmsg");
	$ret;
}

sub FinalRollback {
	my $self = shift;

	$self->LogSysTrace("Final Rollback for ". $self->MyId());
	$self->PushContext("FinalRollback");
	my $dbh = $self->GetExternalDbh();

	$dbh->finalrollback() if ($dbh);
	$self->PopContext("FinalRollback");
}

sub FinalCommit {
	my $self = shift;

	$self->LogSysTrace("Final Commit for ". $self->MyId());
	$self->PushContext("FinalCommit");
	my $dbh = $self->GetExternalDbh();

	$dbh->finalcommit() if ($dbh);
	$self->PopContext("FinalCommit");
}

sub PartialCommit {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();

	$dbh->partialcommit();
}

sub xxxCloseSubFlow {
	my $self = shift;

	$self->BeforeClose();
	my $dbh = $self->GetExternalDbh();
	$dbh->Close();
	$self->AfterClose();
}

sub GetRollBackData {
	my $self = shift;

	my $qryh;
	my $dbh = $self->GetExternalDbh();
	$self->PushContext("getrollbackdata");
	eval {
	if ($self->{container}{rollbackspace} eq 'yes') {
		unless ($qryh = $self->{QURIESH}{getrbinfo}) {
			my $q;
			if ($q = $self->GetQueryByUsedFor('getrbinfo')) {
				$qryh = $dbh->newqueryfromhash($q);
				$self->{QURIESH}{getrbinfo} = $qryh;
			}
			else { $self->{container}{rollbackspace} eq 'no'; }
		}
		unless ($qryh->_attribute("sth")) {
			$dbh->execute($qryh);
		}
		my $row = $dbh->fetchrownop($qryh);
		$self->LogRBInfo($row);
		$self->IncRollbacksCount();
	}
	};
	if ($@) { $self->OnError($@); }
	$self->PopContext("getrollbackdata");
}

=over not used
sub TransformAndSend {
	my $self = shift;

	my $dbh = $self->OpenExternalDb ();

	$self->ClearTarget($dbh);
	$self->Transform($dbh);
	$self->LogTransformed($dbh);
	$self->GetRollBackData($dbh);
	$self->SendMsg($dbh);
}
=cut

sub ClearTarget {
	my $self = shift;

	return 1 unless ($self->TargetCleared ());

	my $qryh;
	my $dbh = $self->GetExternalDbh();
	$self->PushContext("cleartarget");
	eval {
	if ($self->{flowmethod} eq 'truncate') {
		unless ($qryh = $self->{QURIESH}{cleartarget}) {
			my $q;
			if ($q = $self->GetQueryByUsedFor('cleartarget')) {
				$qryh = $dbh->newqueryfromhash($q);
				$self->{QURIESH}{cleartarget} = $qryh;
			}
		}
		unless ($qryh->_attribute("sth")) {
			$dbh->execute($qryh);
		}
	}
	};
	if ($@) { $self->OnError($@); }
	$self->PopContext("cleartarget");
	$self->TargetCleared ("YES");
}

sub LogRbsMessage {
	my $self = shift;

	return 1 if ($self->DirectFlow());
	my $tablename = $self->OutgoTableName();

	my $dbh = $self->QueueDbh();
	my $msgseq = $self->OutgoMsgSeq();
	my $query = $dbh->newquery({ msgseq => $msgseq, tablename => $tablename });
	
	$query->irbsmsg();
	$dbh->executefinish($query);

	foreach my $fldname (keys %{$self->{fields}}) {
		my $fldvalue;
		if ($fldvalue = $self->MyFieldValue($self->MyId(), $fldname)) {
			my $query2 = $dbh->newquery({ msgseq => $msgseq, tablename => $tablename, field_id => $fldname, field_value => $fldvalue });
			$query->irbsmsgdata();
			$dbh->executefinish($query);
		}
	}
}
	

