#package SOAP::Transport::HTTP::Daemon::ForkOnAccept;
package SOAPHTTPWS;

use strict;
use vars qw(@ISA);
use SOAP::Transport::HTTP;

# Idea and implementation of Michael Douglass

@ISA = qw(SOAP::Transport::HTTP::Daemon);
sub AcceptFrom {
	my $self = shift;
	my $a = $self->{__CAFETERRA__}{ACCEPTFROMSTR} = shift || '*';
	$a =~ s/\./\\\./g;
	$a =~ s/\*/\\\.\*/g;
	my @a = split (";", $a);
	$self->{__CAFETERRA__}{ACCEPTFROMARR} = \@a;
}

sub CanAccept {
	my $self = shift;
	my $addr = shift;

	return 1 unless ($self->{__CAFETERRA__}{ACCEPTFROMSTR});
	foreach my $pat (@{$self->{__CAFETERRA__}{ACCEPTFROMARR}}) {
		if ($addr =~ /^$pat$/) { return 1; }
	}
	return undef;
}

sub PeerAddress {
	my $self = shift;
	if (@_) { $self->{__CAFETERRA__}{PEERADDRESS} = shift; }
	$self->{__CAFETERRA__}{PEERADDRESS};
}

sub handle {
	my $self = shift->new;

	CLIENT:
	while (1) {
	if (my $c = $self->accept) {
		if (! $self->CanAccept($c->peerhost)) { $c->close; next; }
		my $pid = fork();

		# We are going to close the new connection on one of two conditions
		#	1. The fork failed ($pid is undefined)
		#	2. We are the parent ($pid != 0)
		if ($pid) {
			$c->close;
			next;
		}
		else {
		# From this point on, we are the child.

			$self->PeerAddress ($c->peerhost);
			$self->close;	# Close the listening socket (always done in children)

		# Handle requests as they come in
			while (my $r = $c->get_request) {
				$self->request($r);
				$self->SOAP::Transport::HTTP::Server::handle;
				$c->send_response($self->response);
			}
			$c->close;
			exit;
		}
	}
	}
}

1;
